/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.processing.helper;

import gama.dependencies.kabeja.dxf.DXFArc;
import gama.dependencies.kabeja.dxf.DXFConstants;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.dxf.DXFLayer;
import gama.dependencies.kabeja.dxf.DXFLine;
import gama.dependencies.kabeja.dxf.DXFPolyline;
import gama.dependencies.kabeja.dxf.DXFVertex;
import gama.dependencies.kabeja.dxf.helpers.DXFUtils;
import gama.dependencies.kabeja.dxf.helpers.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PolylineQueue {
    private final List<DXFEntity> elements = new ArrayList<DXFEntity>();
    private Point startPoint;
    private Point endPoint;
    private double radius = DXFConstants.POINT_CONNECTION_RADIUS;

    public PolylineQueue(DXFEntity dXFEntity, Point point, Point point2, double d) {
        this.elements.add(dXFEntity);
        this.startPoint = point;
        this.endPoint = point2;
        this.radius = d;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean connectDXFEntity(DXFEntity dXFEntity, Point point, Point point2) {
        if (DXFUtils.equals(this.startPoint, point2, this.radius)) {
            this.startPoint = point;
            this.elements.add(0, dXFEntity);
            return true;
        }
        if (DXFUtils.equals(this.endPoint, point, this.radius)) {
            this.endPoint = point2;
            this.elements.add(dXFEntity);
            return true;
        }
        if (DXFUtils.equals(this.startPoint, point, this.radius)) {
            this.startPoint = point2;
            this.reverse(dXFEntity);
            this.elements.add(0, dXFEntity);
            return true;
        }
        if (DXFUtils.equals(this.endPoint, point2, this.radius)) {
            this.endPoint = point;
            this.reverse(dXFEntity);
            this.elements.add(dXFEntity);
            return true;
        }
        return false;
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public Point getEndPoint() {
        return this.endPoint;
    }

    public Iterator getElementIterator() {
        return this.elements.iterator();
    }

    public boolean connect(PolylineQueue polylineQueue) {
        if (DXFUtils.equals(polylineQueue.getStartPoint(), this.endPoint, this.radius)) {
            this.add(polylineQueue);
            return true;
        }
        if (DXFUtils.equals(polylineQueue.getEndPoint(), this.startPoint, this.radius)) {
            this.insertBefore(polylineQueue);
            return true;
        }
        if (DXFUtils.equals(polylineQueue.getStartPoint(), this.startPoint, this.radius)) {
            polylineQueue.reverse();
            this.insertBefore(polylineQueue);
            return true;
        }
        if (DXFUtils.equals(polylineQueue.getEndPoint(), this.endPoint, this.radius)) {
            polylineQueue.reverse();
            this.add(polylineQueue);
            return true;
        }
        return false;
    }

    public void createDXFPolyline(DXFLayer dXFLayer) {
        DXFPolyline dXFPolyline = new DXFPolyline();
        DXFVertex dXFVertex = new DXFVertex(this.startPoint);
        dXFPolyline.addVertex(dXFVertex);
        for (DXFEntity dXFEntity : this.elements) {
            DXFEntity dXFEntity2;
            if ("LINE".equals(dXFEntity.getType())) {
                dXFEntity2 = (DXFLine)dXFEntity;
                dXFVertex = new DXFVertex(((DXFLine)dXFEntity2).getEndPoint());
                dXFPolyline.addVertex(dXFVertex);
            } else if ("POLYLINE".equals(dXFEntity.getType()) || "LWPOLYLINE".equals(dXFEntity.getType())) {
                dXFEntity2 = (DXFPolyline)dXFEntity;
                var7_7 = ((DXFPolyline)dXFEntity2).getVertex(0).getBulge();
                if (var7_7 != 0.0) {
                    dXFVertex.setBulge(var7_7);
                }
                int n = 1;
                while (n < ((DXFPolyline)dXFEntity2).getVertexCount()) {
                    dXFVertex = ((DXFPolyline)dXFEntity2).getVertex(n);
                    dXFPolyline.addVertex(dXFVertex);
                    ++n;
                }
            } else if ("ARC".equals(dXFEntity.getType()) && ((DXFArc)(dXFEntity2 = (DXFArc)dXFEntity)).getTotalAngle() > 0.0) {
                var7_7 = ((DXFArc)dXFEntity2).getRadius() * (1.0 - Math.cos(Math.toRadians(((DXFArc)dXFEntity2).getTotalAngle() / 2.0)));
                double d = ((DXFArc)dXFEntity2).getChordLength();
                if (DXFUtils.equals(((DXFArc)dXFEntity2).getStartPoint(), dXFVertex.getPoint(), this.radius)) {
                    dXFVertex.setBulge(2.0 * var7_7 / d);
                    dXFVertex = new DXFVertex(((DXFArc)dXFEntity2).getEndPoint());
                } else {
                    dXFVertex.setBulge(-1.0 * (2.0 * var7_7 / d));
                    dXFVertex = new DXFVertex(((DXFArc)dXFEntity2).getStartPoint());
                }
                dXFPolyline.addVertex(dXFVertex);
            }
            dXFLayer.removeDXFEntity(dXFEntity);
        }
        dXFPolyline.setLayerName(dXFLayer.getName());
        dXFLayer.addDXFEntity(dXFPolyline);
    }

    protected void reverse(DXFEntity dXFEntity) {
        if ("LINE".equals(dXFEntity.getType())) {
            DXFUtils.reverseDXFLine((DXFLine)dXFEntity);
        } else if ("POLYLINE".equals(dXFEntity.getType()) || "LWPOLYLINE".equals(dXFEntity.getType())) {
            DXFUtils.reverseDXFPolyline((DXFPolyline)dXFEntity);
        } else {
            "ARC".equals(dXFEntity.getType());
        }
    }

    protected void reverse() {
        Point point = this.endPoint;
        this.endPoint = this.startPoint;
        this.startPoint = point;
        int n = this.elements.size() - 1;
        int n2 = 0;
        while (n2 < n + 1) {
            DXFEntity dXFEntity = this.elements.get(n2);
            this.reverse(dXFEntity);
            if (n2 < n) {
                DXFEntity dXFEntity2 = this.elements.set(n, dXFEntity);
                this.reverse(dXFEntity2);
                this.elements.set(n2, dXFEntity2);
                --n;
            }
            ++n2;
        }
    }

    public void insertBefore(PolylineQueue polylineQueue) {
        this.startPoint = polylineQueue.getStartPoint();
        Iterator iterator = polylineQueue.getElementIterator();
        int n = 0;
        while (iterator.hasNext()) {
            DXFEntity dXFEntity = (DXFEntity)iterator.next();
            this.elements.add(n, dXFEntity);
            ++n;
        }
    }

    public void add(PolylineQueue polylineQueue) {
        this.endPoint = polylineQueue.getEndPoint();
        Iterator iterator = polylineQueue.getElementIterator();
        while (iterator.hasNext()) {
            DXFEntity dXFEntity = (DXFEntity)iterator.next();
            this.elements.add(dXFEntity);
        }
    }
}

