/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import gama.dependencies.osmosis.Storeable;

public class OsmUser
implements Storeable {
    private final String name;
    private final int id;
    private static final int USER_ID_NONE = -1;
    public static final OsmUser NONE = new OsmUser(-1, "");

    public OsmUser(int n, String string) {
        if (string == null) {
            throw new NullPointerException("The user name cannot be null.");
        }
        if (NONE != null && n == -1) {
            throw new OsmosisRuntimeException("A user id of -1 is not permitted.");
        }
        this.name = string;
        this.id = n;
    }

    public OsmUser(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        this.name = storeReader.readString();
        this.id = storeReader.readInteger();
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        storeWriter.writeString(this.name);
        storeWriter.writeInteger(this.id);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OsmUser)) {
            return false;
        }
        OsmUser osmUser = (OsmUser)object;
        return this.name.equals(osmUser.name) && this.id == osmUser.id;
    }

    public int hashCode() {
        int n = -17;
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.id;
        return n;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

