/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.maths.random;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.maths.random.ForwardingGenerator;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.random.RandomGenerator;

public class Random2 {
    @GamlAnnotations.operator(value={"gamma_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns a random value from a gamma distribution with specified values of the shape and scale parameters", examples={@GamlAnnotations.example(value="gamma_rnd(9,0.5)", equals="0.731", test=false)}, see={"binomial", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_rnd", "gamma_trunc_rnd"})
    public static Double OpGammaDist(IScope iScope, Double d, Double d2) throws GamaRuntimeException {
        GammaDistribution gammaDistribution = new GammaDistribution((RandomGenerator)new ForwardingGenerator(iScope.getRandom().getGenerator()), d.doubleValue(), d2.doubleValue(), 1.0E-9);
        return gammaDistribution.sample();
    }

    @GamlAnnotations.operator(value={"weibull_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns a random value from a Weibull distribution with specified values of the shape (alpha) and scale (beta) parameters. See https://mathworld.wolfram.com/WeibullDistribution.html for more details (equations 1 and 2). ", examples={@GamlAnnotations.example(value="weibull_rnd(2,3) ", equals="0.731", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_trunc_rnd"})
    public static Double OpWeibullDist(IScope iScope, Double d, Double d2) throws GamaRuntimeException {
        WeibullDistribution weibullDistribution = new WeibullDistribution((RandomGenerator)new ForwardingGenerator(iScope.getRandom().getGenerator()), d.doubleValue(), d2.doubleValue());
        return weibullDistribution.sample();
    }

    @GamlAnnotations.operator(value={"exp_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns a random value from a exponential distribution with specified values of the rate (lambda) parameters. See https://mathworld.wolfram.com/ExponentialDistribution.html for more details ). ", examples={@GamlAnnotations.example(value="exp_rnd(5) ", equals="0.731", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_trunc_rnd"})
    public static Double OpExpDist(IScope iScope, Double d) throws GamaRuntimeException {
        ExponentialDistribution exponentialDistribution = new ExponentialDistribution((RandomGenerator)new ForwardingGenerator(iScope.getRandom().getGenerator()), d.doubleValue());
        return exponentialDistribution.sample();
    }

    @GamlAnnotations.operator(value={"lognormal_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns a random value from a Log-Normal distribution with specified values of the expected value (or mean) of the variable's natural logarithm (shape) and the standard deviation of the variable's natural logarithm (scale) parameters. See https://en.wikipedia.org/wiki/Log-normal_distribution for more details. ", examples={@GamlAnnotations.example(value="lognormal_rnd(2,3)", equals="0.731", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_rnd", "lognormal_trunc_rnd"})
    public static Double OpLogNormalDist(IScope iScope, Double d, Double d2) throws GamaRuntimeException {
        LogNormalDistribution logNormalDistribution = new LogNormalDistribution((RandomGenerator)new ForwardingGenerator(iScope.getRandom().getGenerator()), d.doubleValue(), d2.doubleValue());
        return logNormalDistribution.sample();
    }

    @GamlAnnotations.operator(value={"lognormal_trunc_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns a random value from a truncated Log-Normal distribution (in a range or given only one boundary) with specified values of the shape (alpha) and scale (beta) parameters. See https://en.wikipedia.org/wiki/Log-normal_distribution for more details. ", usages={@GamlAnnotations.usage(value="when 2 float operands are specified, they are taken as mininimum and maximum values for the result", examples={@GamlAnnotations.example(value="lognormal_trunc_rnd(2,3,0,5)", test=false)})}, see={"lognormal_rnd", "gamma_trunc_rnd", "weibull_trunc_rnd", "truncated_gauss"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="lognormal_trunc_rnd(2,3,0,5) <= 5.0"), @GamlAnnotations.test(value="lognormal_trunc_rnd(2,3,0.0,5.0) >= 0.0")})
    public static Double OpLogNormalTruncDist(IScope iScope, Double d, Double d2, Double d3, Double d4) throws GamaRuntimeException {
        double d5 = 0.0;
        while ((d5 = Random2.OpLogNormalDist(iScope, d, d2).doubleValue()) > d4 || d5 < d3) {
        }
        return d5;
    }

    @GamlAnnotations.operator(value={"lognormal_trunc_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="when 1 float and a boolean (isMax) operands are specified, the float value represents the single boundary (max if the boolean is true, min otherwise),", examples={@GamlAnnotations.example(value="lognormal_trunc_rnd(2,3,5,true)", test=false)})}, see={"lognormal_rnd", "gamma_trunc_rnd", "weibull_trunc_rnd", "truncated_gauss"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="lognormal_trunc_rnd(2,3,5,true) <= 5.0"), @GamlAnnotations.test(value="lognormal_trunc_rnd(2,3,0.0,false) >= 0.0")})
    public static Double OpLogNormalTruncDist(IScope iScope, Double d, Double d2, Double d3, Boolean bl) throws GamaRuntimeException {
        double d4 = 0.0;
        if (bl.booleanValue()) {
            while ((d4 = Random2.OpLogNormalDist(iScope, d, d2).doubleValue()) > d3) {
            }
        } else {
            while ((d4 = Random2.OpLogNormalDist(iScope, d, d2).doubleValue()) < d3) {
            }
        }
        return d4;
    }

    @GamlAnnotations.operator(value={"weibull_trunc_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns a random value from a truncated Weibull distribution (in a range or given only one boundary) with specified values of the shape (alpha) and scale (beta) parameters. See https://mathworld.wolfram.com/WeibullDistribution.html for more details (equations 1 and 2). ", usages={@GamlAnnotations.usage(value="when 2 float operands are specified, they are taken as mininimum and maximum values for the result", examples={@GamlAnnotations.example(value="weibull_trunc_rnd(2,3,0.0,5.0)", test=false)})}, see={"weibull_rnd", "gamma_trunc_rnd", "lognormal_trunc_rnd", "truncated_gauss"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="weibull_trunc_rnd(2,3,0,5) <= 5.0"), @GamlAnnotations.test(value="weibull_trunc_rnd(2,3,0.0,5.0) >= 0.0")})
    public static Double OpWeibullTruncDist(IScope iScope, Double d, Double d2, Double d3, Double d4) throws GamaRuntimeException {
        double d5 = 0.0;
        while ((d5 = Random2.OpWeibullDist(iScope, d, d2).doubleValue()) > d4 || d5 < d3) {
        }
        return d5;
    }

    @GamlAnnotations.operator(value={"weibull_trunc_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="when 1 float and a boolean (isMax) operands are specified, the float value represents the single boundary (max if the boolean is true, min otherwise),", examples={@GamlAnnotations.example(value="weibull_trunc_rnd(2,3,5,true)", test=false)})}, see={"weibull_rnd", "gamma_trunc_rnd", "lognormal_trunc_rnd", "truncated_gauss"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="weibull_trunc_rnd(2,3,5,true) <= 5.0"), @GamlAnnotations.test(value="weibull_trunc_rnd(2,3,0.0,false) >= 0.0")})
    public static Double OpWeibullTruncDist(IScope iScope, Double d, Double d2, Double d3, Boolean bl) throws GamaRuntimeException {
        double d4 = 0.0;
        if (bl.booleanValue()) {
            while ((d4 = Random2.OpWeibullDist(iScope, d, d2).doubleValue()) > d3) {
            }
        } else {
            while ((d4 = Random2.OpWeibullDist(iScope, d, d2).doubleValue()) < d3) {
            }
        }
        return d4;
    }

    @GamlAnnotations.operator(value={"gamma_trunc_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns a random value from a truncated gamma distribution (in a range or given only one boundary) with specified values of the shape and scale parameters.", usages={@GamlAnnotations.usage(value="when 2 float operands are specified, they are taken as mininimum and maximum values for the result", examples={@GamlAnnotations.example(value="gamma_trunc_rnd(2,3,0,5)", test=false)})}, see={"gamma_rnd", "weibull_trunc_rnd", "lognormal_trunc_rnd", "truncated_gauss"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="gamma_trunc_rnd(2,3,0,5) <= 5.0"), @GamlAnnotations.test(value="gamma_trunc_rnd(2,3,0.0,5.0) >= 0.0")})
    public static Double OpGammaTruncDist(IScope iScope, Double d, Double d2, Double d3, Double d4) throws GamaRuntimeException {
        double d5 = 0.0;
        while ((d5 = Random2.OpGammaDist(iScope, d, d2).doubleValue()) > d4 || d5 < d3) {
        }
        return d5;
    }

    @GamlAnnotations.operator(value={"gamma_trunc_rnd"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="when 1 float and a boolean (isMax) operands are specified, the float value represents the single boundary (max if the boolean is true, min otherwise),", examples={@GamlAnnotations.example(value="gamma_trunc_rnd(2,3,5,true)", test=false)})}, see={"gamma_rnd", "weibull_trunc_rnd", "lognormal_trunc_rnd", "truncated_gauss"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="gamma_trunc_rnd(2,3,5,true) <= 5.0"), @GamlAnnotations.test(value="gamma_trunc_rnd(2,3,0.0,false) >= 0.0")})
    public static Double OpGammaTruncDist(IScope iScope, Double d, Double d2, Double d3, Boolean bl) throws GamaRuntimeException {
        double d4 = 0.0;
        if (bl.booleanValue()) {
            while ((d4 = Random2.OpGammaDist(iScope, d, d2).doubleValue()) > d3) {
            }
        } else {
            while ((d4 = Random2.OpGammaDist(iScope, d, d2).doubleValue()) < d3) {
            }
        }
        return d4;
    }

    @GamlAnnotations.operator(value={"weibull_density"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="weibull_density(x,shape,scale) returns the probability density function (PDF) at the specified point x of the Weibull distribution with the given shape and scale.", examples={@GamlAnnotations.example(value="weibull_rnd(1,2,3) ", equals="0.731", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "lognormal_density", "gamma_density"})
    public static Double OpWeibullDistDensity(IScope iScope, Double d, Double d2, Double d3) throws GamaRuntimeException {
        WeibullDistribution weibullDistribution = new WeibullDistribution((RandomGenerator)new ForwardingGenerator(iScope.getRandom().getGenerator()), d2.doubleValue(), d3.doubleValue());
        return weibullDistribution.density(d.doubleValue());
    }

    @GamlAnnotations.operator(value={"exp_density"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="returns the probability density function (PDF) at the specified point x of the exponential distribution with the given rate.", examples={@GamlAnnotations.example(value="exp_density(5,3) ", equals="0.731", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "lognormal_density", "gamma_density"})
    public static Double OpExpDistDensity(IScope iScope, Double d, Double d2) throws GamaRuntimeException {
        ExponentialDistribution exponentialDistribution = new ExponentialDistribution((RandomGenerator)new ForwardingGenerator(iScope.getRandom().getGenerator()), d2.doubleValue());
        return exponentialDistribution.density(d.doubleValue());
    }

    @GamlAnnotations.operator(value={"lognormal_density"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="lognormal_density(x,shape,scale) returns the probability density function (PDF) at the specified point x of the logNormal distribution with the given shape and scale.", examples={@GamlAnnotations.example(value="lognormal_density(1,2,3) ", equals="0.731", test=false)}, see={"binomial", "gamma_rnd", "gauss_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_rnd", "weibull_density", "gamma_density"})
    public static Double OpLogNormalDist(IScope iScope, Double d, Double d2, Double d3) throws GamaRuntimeException {
        LogNormalDistribution logNormalDistribution = new LogNormalDistribution((RandomGenerator)new ForwardingGenerator(iScope.getRandom().getGenerator()), d2.doubleValue(), d3.doubleValue());
        return logNormalDistribution.density(d.doubleValue());
    }

    @GamlAnnotations.operator(value={"gamma_density"}, can_be_const=false, category={"Random operators"}, concept={"random"})
    @GamlAnnotations.doc(value="gamma_density(x,shape,scale) returns the probability density function (PDF) at the specified point x of the Gamma distribution with the given shape and scale.", examples={@GamlAnnotations.example(value="gamma_density(1,9,0.5)", equals="0.731", test=false)}, see={"binomial", "gauss_rnd", "lognormal_rnd", "poisson", "rnd", "skew_gauss", "truncated_gauss", "weibull_rnd", "weibull_density", "lognormal_density"})
    public static Double OpGammaDist(IScope iScope, Double d, Double d2, Double d3) throws GamaRuntimeException {
        GammaDistribution gammaDistribution = new GammaDistribution((RandomGenerator)new ForwardingGenerator(iScope.getRandom().getGenerator()), d2.doubleValue(), d3.doubleValue(), 1.0E-9);
        return gammaDistribution.density(d.doubleValue());
    }
}

