/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.view;

import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.swt.NewtCanvasSWT;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.camera.IMultiListener;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.view.GamaGLAnimator;
import gama.ui.shared.bindings.IDelegateEventsToParent;
import gama.ui.shared.utils.WorkbenchHelper;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;

public class GamaGLCanvas
extends Composite
implements GLAutoDrawable,
IDelegateEventsToParent,
FPSCounter {
    final Control canvas;
    final GLWindow drawable;
    GamaGLAnimator animator;
    protected boolean detached = false;
    final String name;
    volatile boolean visible;
    private Monitor monitor;

    static {
        DEBUG.OFF();
    }

    public GamaGLCanvas(final Composite composite, IOpenGLRenderer iOpenGLRenderer, String string) {
        super(composite, 0);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent controlEvent) {
                DEBUG.OUT((Object)("Setting monitor for GLCanvas " + composite.getMonitor().toString()));
                GamaGLCanvas.this.setMonitor(composite.getMonitor());
            }

            public void controlResized(ControlEvent controlEvent) {
                DEBUG.OUT((Object)("Setting monitor for GLCanvas " + composite.getMonitor().toString()));
                GamaGLCanvas.this.setMonitor(composite.getMonitor());
            }
        });
        this.name = string;
        composite.setLayout((Layout)new FillLayout());
        this.setLayout((Layout)new FillLayout());
        GLCapabilities gLCapabilities = this.defineCapabilities();
        this.drawable = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        this.drawable.setAutoSwapBufferMode(true);
        this.canvas = new NewtCanvasSWT((Composite)this, 0, (Window)this.drawable);
        this.animator = new GamaGLAnimator((GLAutoDrawable)this.drawable);
        iOpenGLRenderer.setCanvas(this);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (PlatformHelper.isMac()) {
                    boolean bl;
                    boolean bl2 = bl = composite.getShell().getText().length() == 0;
                    if (bl) {
                        if (!GamaGLCanvas.this.detached) {
                            GamaGLCanvas.this.reparentWindow();
                            GamaGLCanvas.this.detached = true;
                        }
                    } else if (GamaGLCanvas.this.detached) {
                        GamaGLCanvas.this.reparentWindow();
                        GamaGLCanvas.this.detached = false;
                    }
                }
            }
        });
        this.addDisposeListener(disposeEvent -> new Thread(() -> {
            this.animator.stop();
            this.animator = null;
        }).start());
    }

    protected void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    protected void checkWidget() {
    }

    private GLCapabilities defineCapabilities() throws GLException {
        GLCapabilities gLCapabilities = new GLCapabilities(OpenGL.PROFILE);
        gLCapabilities.setDepthBits(24);
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setNumSamples(8);
        return gLCapabilities;
    }

    public void setRealized(boolean bl) {
        this.drawable.setRealized(bl);
    }

    public boolean isRealized() {
        return this.drawable.isRealized();
    }

    public int getSurfaceWidth() {
        return this.drawable.getSurfaceWidth();
    }

    public int getSurfaceHeight() {
        return this.drawable.getSurfaceHeight();
    }

    public boolean isGLOriented() {
        return this.drawable.isGLOriented();
    }

    public void swapBuffers() throws GLException {
        this.drawable.swapBuffers();
    }

    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        return this.drawable.getChosenGLCapabilities();
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        return this.drawable.getRequestedGLCapabilities();
    }

    public GLProfile getGLProfile() {
        return this.drawable.getGLProfile();
    }

    public NativeSurface getNativeSurface() {
        return this.drawable.getNativeSurface();
    }

    public long getHandle() {
        return this.drawable.getHandle();
    }

    public GLDrawableFactory getFactory() {
        return this.drawable.getFactory();
    }

    public GLDrawable getDelegatedDrawable() {
        return this.drawable.getDelegatedDrawable();
    }

    public GLContext getContext() {
        return this.drawable.getContext();
    }

    public GLContext setContext(GLContext gLContext, boolean bl) {
        return this.drawable.setContext(gLContext, bl);
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawable.addGLEventListener(gLEventListener);
    }

    public void addGLEventListener(int n, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.drawable.addGLEventListener(n, gLEventListener);
    }

    public int getGLEventListenerCount() {
        return this.drawable.getGLEventListenerCount();
    }

    public boolean areAllGLEventListenerInitialized() {
        return this.drawable.areAllGLEventListenerInitialized();
    }

    public GLEventListener getGLEventListener(int n) throws IndexOutOfBoundsException {
        return this.drawable.getGLEventListener(n);
    }

    public boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        return this.drawable.getGLEventListenerInitState(gLEventListener);
    }

    public void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        this.drawable.setGLEventListenerInitState(gLEventListener, bl);
    }

    public GLEventListener disposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        return this.drawable.disposeGLEventListener(gLEventListener, bl);
    }

    public GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        return this.drawable.removeGLEventListener(gLEventListener);
    }

    public void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        this.drawable.setAnimator(gLAnimatorControl);
    }

    public GLAnimatorControl getAnimator() {
        return this.drawable.getAnimator();
    }

    public Thread setExclusiveContextThread(Thread thread) throws GLException {
        return this.drawable.setExclusiveContextThread(thread);
    }

    public Thread getExclusiveContextThread() {
        return this.drawable.getExclusiveContextThread();
    }

    public boolean invoke(boolean bl, GLRunnable gLRunnable) throws IllegalStateException {
        return this.drawable.invoke(bl, gLRunnable);
    }

    public boolean invoke(boolean bl, List<GLRunnable> list) throws IllegalStateException {
        return this.drawable.invoke(bl, list);
    }

    public void flushGLRunnables() {
        this.drawable.flushGLRunnables();
    }

    public void destroy() {
        this.drawable.destroy();
    }

    public void display() {
        this.drawable.display();
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.drawable.setAutoSwapBufferMode(bl);
    }

    public boolean getAutoSwapBufferMode() {
        return this.drawable.getAutoSwapBufferMode();
    }

    public void setContextCreationFlags(int n) {
        this.drawable.setContextCreationFlags(n);
    }

    public int getContextCreationFlags() {
        return this.drawable.getContextCreationFlags();
    }

    public GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    public GL getGL() {
        return this.drawable.getGL();
    }

    public GL setGL(GL gL) {
        return this.drawable.setGL(gL);
    }

    public Object getUpstreamWidget() {
        return this.drawable.getUpstreamWidget();
    }

    public RecursiveLock getUpstreamLock() {
        return this.drawable.getUpstreamLock();
    }

    public boolean isThreadGLCapable() {
        return this.drawable.isThreadGLCapable();
    }

    public Window getNEWTWindow() {
        return this.drawable;
    }

    public void reparentWindow() {
        DEBUG.OUT((Object)("Entering making GLWindow " + this.name + " reparent "));
        GLWindow gLWindow = this.drawable;
        this.setWindowVisible(false);
        gLWindow.setFullscreen(true);
        gLWindow.setFullscreen(false);
        this.setWindowVisible(true);
    }

    public boolean setWindowVisible(boolean bl) {
        GLWindow gLWindow = this.drawable;
        if (!gLWindow.isNativeValid()) {
            return false;
        }
        gLWindow.setVisible(bl);
        return true;
    }

    public boolean setFocus() {
        return this.canvas.setFocus();
    }

    public void addCameraListeners(IMultiListener iMultiListener) {
        WorkbenchHelper.asyncRun(() -> {
            if (this.isDisposed() || this.canvas.isDisposed()) {
                return;
            }
            this.drawable.addKeyListener((KeyListener)iMultiListener);
            this.drawable.addMouseListener((MouseListener)iMultiListener);
        });
    }

    public void removeCameraListeners(IMultiListener iMultiListener) {
        WorkbenchHelper.asyncRun(() -> {
            if (this.isDisposed() || this.canvas.isDisposed()) {
                return;
            }
            this.drawable.removeKeyListener((KeyListener)iMultiListener);
            this.drawable.removeMouseListener((MouseListener)iMultiListener);
        });
    }

    public void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.animator.setUpdateFPSFrames(n, printStream);
    }

    public void resetFPSCounter() {
        this.animator.resetFPSCounter();
    }

    public int getUpdateFPSFrames() {
        return this.animator.getUpdateFPSFrames();
    }

    public long getFPSStartTime() {
        return this.animator.getFPSStartTime();
    }

    public long getLastFPSUpdateTime() {
        return this.animator.getLastFPSUpdateTime();
    }

    public long getLastFPSPeriod() {
        return this.animator.getLastFPSPeriod();
    }

    public float getLastFPS() {
        return this.animator.getLastFPS();
    }

    public int getTotalFPSFrames() {
        return this.animator.getTotalFPSFrames();
    }

    public long getTotalFPSDuration() {
        return this.animator.getTotalFPSDuration();
    }

    public float getTotalFPS() {
        return this.animator.getTotalFPS();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.setWindowVisible(bl);
        if (!this.isDisposed()) {
            super.setVisible(bl);
        }
    }

    public boolean getVisibleStatus() {
        return this.visible;
    }

    public void updateVisibleStatus(boolean bl) {
        this.visible = bl;
    }
}

