/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor;

import com.google.common.collect.Iterables;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ValidationContext;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;

public class GamlEditorState {
    boolean hasInternalErrors;
    boolean hasImportedErrors;
    boolean hasExperiments;
    boolean hasNullStatus;
    final boolean showExperiments;
    public final List<String> experiments;
    public final List<String> abbreviations;
    final List<String> types;
    final Map<String, URI> importedErrors;
    public static final String NO_EXP_DEFINED = "No experiments defined";
    public static final String ERRORS_DETECTED = "Error(s) detected";
    public static final String IN_IMPORTED_FILES = "Error(s) in imported files";
    public static final String IMPOSSIBLE_TO_RUN = "Impossible to run any experiment";

    public GamlEditorState(ValidationContext validationContext, Iterable<? extends IDescription> iterable) {
        if (validationContext != null) {
            this.hasImportedErrors = validationContext.hasImportedErrors();
            this.importedErrors = this.hasImportedErrors ? validationContext.getImportedErrorsAsStrings() : Collections.EMPTY_MAP;
            this.hasInternalErrors = validationContext.hasInternalErrors() || validationContext.hasInternalSyntaxErrors();
            this.hasNullStatus = false;
            this.showExperiments = !validationContext.getNoExperiment();
        } else {
            this.hasNullStatus = true;
            this.importedErrors = Collections.EMPTY_MAP;
            this.showExperiments = true;
        }
        int n = Iterables.size(iterable);
        if (n > 0) {
            this.hasExperiments = true;
            this.experiments = new ArrayList<String>(n);
            this.abbreviations = new ArrayList<String>(n);
            this.types = new ArrayList<String>(n);
            for (IDescription iDescription : iterable) {
                String string = iDescription.getName();
                this.experiments.add(string);
                this.abbreviations.add(string);
                ExperimentDescription experimentDescription = (ExperimentDescription)iDescription;
                this.types.add("batch".equals(experimentDescription.getLitteral("type")) ? "batch" : (experimentDescription.isMemorize() != false ? "record" : "gui"));
            }
        } else {
            this.experiments = Collections.EMPTY_LIST;
            this.abbreviations = Collections.EMPTY_LIST;
            this.types = Collections.EMPTY_LIST;
        }
    }

    public boolean equals2(Object object) {
        if (!(object instanceof GamlEditorState)) {
            return false;
        }
        GamlEditorState gamlEditorState = (GamlEditorState)object;
        return gamlEditorState.hasNullStatus == this.hasNullStatus && gamlEditorState.hasImportedErrors == this.hasImportedErrors && gamlEditorState.hasInternalErrors == this.hasInternalErrors && gamlEditorState.experiments.equals(this.experiments) && gamlEditorState.showExperiments == this.showExperiments && gamlEditorState.types.equals(this.types);
    }

    public int hashCode() {
        return Objects.hash(this.experiments, this.hasImportedErrors, this.hasInternalErrors, this.hasNullStatus, this.showExperiments, this.types);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GamlEditorState gamlEditorState = (GamlEditorState)object;
        if (!Objects.equals(this.experiments, gamlEditorState.experiments) || this.hasImportedErrors != gamlEditorState.hasImportedErrors || this.hasInternalErrors != gamlEditorState.hasInternalErrors || this.hasNullStatus != gamlEditorState.hasNullStatus) {
            return false;
        }
        return this.showExperiments == gamlEditorState.showExperiments && Objects.equals(this.types, gamlEditorState.types);
    }

    public GamaColors.GamaUIColor getColor() {
        if (this.hasImportedErrors || this.hasInternalErrors) {
            return IGamaColors.ERROR;
        }
        if (!this.hasExperiments) {
            return IGamaColors.WARNING;
        }
        return IGamaColors.OK;
    }

    public String getStatus() {
        Object object = null;
        if (this.hasInternalErrors) {
            object = ERRORS_DETECTED;
            if (this.hasImportedErrors) {
                object = IN_IMPORTED_FILES;
            }
        } else if (this.hasImportedErrors) {
            object = IN_IMPORTED_FILES;
        } else {
            if (!this.hasExperiments) {
                return NO_EXP_DEFINED;
            }
            return null;
        }
        if (this.hasExperiments) {
            object = (String)object + ". Impossible to run any experiment";
        }
        return object;
    }

    public Map<String, URI> getImportedErrors() {
        return this.importedErrors;
    }
}

