/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor.toolbar;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.ui.shared.bindings.GamaKeyBindings;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import gama.ui.shared.views.toolbar.Selector;
import gaml.compiler.ui.editor.GamlEditor;
import gaml.compiler.ui.editor.toolbar.EditorSearchControls;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;

public class EditorToolbar {
    ToolItem next;
    ToolItem previous;
    EditorSearchControls find;
    final GamlEditor editor;
    public Pref<Boolean> markPref;
    volatile boolean searching;
    final Selector globalPrevious = selectionEvent -> {
        boolean bl = WorkbenchHelper.runCommand((String)"org.eclipse.ui.navigate.backwardHistory");
    };
    final Selector globalNext = selectionEvent -> {
        boolean bl = WorkbenchHelper.runCommand((String)"org.eclipse.ui.navigate.forwardHistory");
    };
    final Selector searchPrevious = selectionEvent -> this.find.findPrevious();
    final Selector searchNext = selectionEvent -> this.find.findNext();

    static {
        DEBUG.ON();
        Command command = WorkbenchHelper.getCommand((String)"org.eclipse.ui.edit.text.zoomOut");
        if (command != null) {
            command.setHandler(null);
        }
        if ((command = WorkbenchHelper.getCommand((String)"org.eclipse.ui.edit.text.zoomIn")) != null) {
            command.setHandler(null);
        }
        if ((command = WorkbenchHelper.getCommand((String)"org.eclipse.ui.edit.text.zoomOut")) != null) {
            command.setHandler(null);
        }
        if (PlatformHelper.isMac()) {
            GamaKeyBindings.plug((GamaKeyBindings.PluggableBinding)new GamaKeyBindings.PluggableBinding(SWT.MOD1 | 0x20000, 61){

                public void run() {
                    IEditorPart iEditorPart = WorkbenchHelper.getActiveEditor();
                    if (iEditorPart instanceof GamlEditor) {
                        GamlEditor gamlEditor = (GamlEditor)iEditorPart;
                        gamlEditor.zoomIn();
                    }
                }
            });
        } else {
            GamaKeyBindings.plug((GamaKeyBindings.PluggableBinding)new GamaKeyBindings.PluggableBinding(SWT.MOD1, 43){

                public void run() {
                    IEditorPart iEditorPart = WorkbenchHelper.getActiveEditor();
                    if (iEditorPart instanceof GamlEditor) {
                        GamlEditor gamlEditor = (GamlEditor)iEditorPart;
                        gamlEditor.zoomIn();
                    }
                }
            });
        }
        GamaKeyBindings.plug((GamaKeyBindings.PluggableBinding)new GamaKeyBindings.PluggableBinding(SWT.MOD1, 103){

            public void run() {
                IEditorPart iEditorPart = WorkbenchHelper.getActiveEditor();
                if (iEditorPart instanceof GamlEditor) {
                    GamlEditor gamlEditor = (GamlEditor)iEditorPart;
                    gamlEditor.doSearch();
                }
            }
        });
        GamaKeyBindings.plug((GamaKeyBindings.PluggableBinding)new GamaKeyBindings.PluggableBinding(SWT.MOD1, 61){

            public void run() {
                IEditorPart iEditorPart = WorkbenchHelper.getActiveEditor();
                if (iEditorPart instanceof GamlEditor) {
                    GamlEditor gamlEditor = (GamlEditor)iEditorPart;
                    gamlEditor.zoomFit();
                }
            }
        });
        GamaKeyBindings.plug((GamaKeyBindings.PluggableBinding)new GamaKeyBindings.PluggableBinding(SWT.MOD1, 45){

            public void run() {
                IEditorPart iEditorPart = WorkbenchHelper.getActiveEditor();
                if (iEditorPart instanceof GamlEditor) {
                    GamlEditor gamlEditor = (GamlEditor)iEditorPart;
                    gamlEditor.zoomOut();
                }
            }
        });
    }

    public EditorToolbar(GamlEditor gamlEditor) {
        this.editor = gamlEditor;
    }

    public EditorSearchControls fill(GamaToolbarSimple gamaToolbarSimple) {
        this.previous = gamaToolbarSimple.button("editor/command.lastedit", null, "Previous edit location", this.globalPrevious);
        this.find = new EditorSearchControls(this.editor).fill(gamaToolbarSimple);
        this.next = gamaToolbarSimple.button("editor/command.nextedit", null, "Next edit location", this.globalNext);
        gamaToolbarSimple.button("editor/local.menu", "Presentation preferences", "Presentation preferences", selectionEvent -> {
            GamaMenu gamaMenu = new GamaMenu(){

                protected void fillMenu() {
                    IViewPart iViewPart;
                    GamaCommand.build((String)"display/zoom.in", (String)"Zoom In ", (String)"Increases the size of the font in this editor", selectionEvent -> EditorToolbar.this.editor.zoomIn()).toItem(this.mainMenu).setAccelerator(SWT.MOD1 | 0x2B);
                    GamaCommand.build((String)"display/zoom.fit", (String)"Zoom Reset ", (String)"Resets the size of the font to its default in the preferences", selectionEvent -> EditorToolbar.this.editor.zoomFit()).toItem(this.mainMenu).setAccelerator(SWT.MOD1 | 0x3D);
                    GamaCommand.build((String)"display/zoom.out", (String)"Zoom Out ", (String)"Decreases the size of the font in this editor", selectionEvent -> EditorToolbar.this.editor.zoomOut()).toItem(this.mainMenu).setAccelerator(SWT.MOD1 | 0x2D);
                    GamaMenu.separate((Menu)this.mainMenu);
                    EditorToolbar.this.addPresentationItems(this.mainMenu, -1);
                    EditorToolbar.this.addManagementItems(this.mainMenu, -1);
                    GamaMenu.separate((Menu)this.mainMenu);
                    IViewPart iViewPart2 = WorkbenchHelper.getPage().findView("gama.ui.application.view.outline");
                    String string = iViewPart2 == null ? "Show outline" : "Hide outline";
                    Selector selector = iViewPart2 == null ? selectionEvent -> EditorToolbar.this.showView("gama.ui.application.view.outline") : selectionEvent -> WorkbenchHelper.getPage().hideView(iViewPart2);
                    GamaCommand.build((String)"editor/command.outline", (String)string, null, (Selector)selector).toItem(this.mainMenu);
                    if (GamaBundleLoader.isDiagramEditorLoaded()) {
                        GamaCommand.build((String)"editor/command.graphical", (String)"Toggle diagram view", (String)"Switch to diagram", selectionEvent -> EditorToolbar.this.editor.switchToDiagram()).toItem(this.mainMenu);
                    }
                    string = (iViewPart = WorkbenchHelper.getPage().findView("gama.ui.application.view.minimap")) == null ? "Show minimap" : "Hide minimap";
                    selector = iViewPart == null ? selectionEvent -> EditorToolbar.this.showView("gama.ui.application.view.minimap") : selectionEvent -> WorkbenchHelper.getPage().hideView(iViewPart);
                    GamaCommand.build((String)"editor/command.navigation", (String)string, null, (Selector)selector).toItem(this.mainMenu);
                }
            };
            gamaMenu.open((Control)gamaToolbarSimple, selectionEvent, gamaToolbarSimple.getSize().y, 100);
        });
        this.hookToCommands(this.previous, this.next);
        this.hookToSearch(this.previous, this.next);
        return this.find;
    }

    private void showView(String string) {
        try {
            WorkbenchHelper.getPage().showView(string);
        }
        catch (PartInitException partInitException) {}
    }

    public void addPresentationItems(Menu menu, int n) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("Presentation");
        menuItem.setImage(GamaIcon.named((String)"editor/menu.presentation").image());
        Menu menu2 = new Menu(menuItem);
        if (menuItem.getMenu() != null) {
            menuItem.getMenu().dispose();
        }
        menuItem.setMenu(menu2);
        menu2.addListener(22, event -> {
            this.markPref = GamaPreferences.get((String)"pref_editor_mark_occurrences", Boolean.class);
            MenuItem[] menuItemArray = menu2.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                menuItem.dispose();
                ++n2;
            }
            this.createLineToggle(menu2);
            this.createFoldingToggle(menu2);
            this.createMarkToggle(menu2);
            this.createOverviewToggle(menu2);
            this.createWordWrapToggle(menu2);
        });
    }

    public void addManagementItems(Menu menu, int n) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("Management");
        menuItem.setImage(GamaIcon.named((String)"views/layout.menu").image());
        Menu menu2 = new Menu(menuItem);
        if (menuItem.getMenu() != null) {
            menuItem.getMenu().dispose();
        }
        menuItem.setMenu(menu2);
        menu2.addListener(22, event -> {
            MenuItem[] menuItemArray = menu2.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                menuItem.dispose();
                ++n2;
            }
            GamaCommand.build((String)"views/layout.vertical", (String)"Split Vertically ", (String)"", selectionEvent -> WorkbenchHelper.runCommand((String)"org.eclipse.ui.window.splitEditor", Map.of("Splitter.isHorizontal", "true"))).toItem(menu2);
            GamaCommand.build((String)"views/layout.horizontal", (String)"Split Horizontally ", (String)"", selectionEvent -> WorkbenchHelper.runCommand((String)"org.eclipse.ui.window.splitEditor", Map.of("Splitter.isHorizontal", "false"))).toItem(menu2);
            GamaCommand.build((String)"views/layout.stack", (String)"Clone ", (String)"", selectionEvent -> WorkbenchHelper.runCommand((String)"org.eclipse.ui.window.newEditor")).toItem(menu2);
        });
    }

    private void hookToSearch(ToolItem toolItem, ToolItem toolItem2) {
        this.find.getFindControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                EditorToolbar.this.searching = true;
                EditorToolbar.this.previous.removeSelectionListener((SelectionListener)EditorToolbar.this.globalPrevious);
                EditorToolbar.this.previous.setToolTipText("Search previous occurence");
                EditorToolbar.this.next.removeSelectionListener((SelectionListener)EditorToolbar.this.globalNext);
                EditorToolbar.this.next.setToolTipText("Search next occurence " + GamaKeyBindings.format((int)SWT.MOD1, (int)71));
                EditorToolbar.this.previous.addSelectionListener((SelectionListener)EditorToolbar.this.searchPrevious);
                EditorToolbar.this.next.addSelectionListener((SelectionListener)EditorToolbar.this.searchNext);
                EditorToolbar.this.previous.setEnabled(true);
                EditorToolbar.this.next.setEnabled(true);
            }

            public void focusLost(FocusEvent focusEvent) {
                EditorToolbar.this.searching = false;
                EditorToolbar.this.previous.removeSelectionListener((SelectionListener)EditorToolbar.this.searchPrevious);
                EditorToolbar.this.previous.setToolTipText("Previous edit location");
                EditorToolbar.this.next.removeSelectionListener((SelectionListener)EditorToolbar.this.searchNext);
                EditorToolbar.this.next.setToolTipText("Next edit location");
                EditorToolbar.this.previous.addSelectionListener((SelectionListener)EditorToolbar.this.globalPrevious);
                EditorToolbar.this.next.addSelectionListener((SelectionListener)EditorToolbar.this.globalNext);
                EditorToolbar.this.previous.setEnabled(WorkbenchHelper.getCommand((String)"org.eclipse.ui.navigate.backwardHistory").isEnabled());
                EditorToolbar.this.next.setEnabled(WorkbenchHelper.getCommand((String)"org.eclipse.ui.navigate.forwardHistory").isEnabled());
            }
        });
    }

    private void hookToCommands(ToolItem toolItem, ToolItem toolItem2) {
        WorkbenchHelper.runInUI((String)"Hooking to commands", (int)0, iProgressMonitor -> {
            Command command;
            Command command2 = WorkbenchHelper.getCommand((String)"org.eclipse.ui.navigate.forwardHistory");
            if (!toolItem2.isDisposed()) {
                toolItem2.setEnabled(command2.isEnabled());
                command = commandEvent -> toolItem2.setEnabled(this.searching || command2.isEnabled());
                command2.addCommandListener((ICommandListener)command);
                toolItem2.addDisposeListener(arg_0 -> EditorToolbar.lambda$12(command2, (ICommandListener)command, arg_0));
            }
            command = WorkbenchHelper.getCommand((String)"org.eclipse.ui.navigate.backwardHistory");
            if (!toolItem.isDisposed()) {
                ICommandListener iCommandListener = commandEvent -> toolItem.setEnabled(this.searching || command.isEnabled());
                toolItem.setEnabled(command.isEnabled());
                command.addCommandListener(iCommandListener);
                toolItem.addDisposeListener(disposeEvent -> command.removeCommandListener(iCommandListener));
            }
        });
    }

    public void createMarkToggle(Menu menu) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = (Boolean)this.markPref.getValue();
        menuItem.setText(bl ? " Do not mark symbols occurences" : " Mark occurences of symbols");
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.mark").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditorToolbar.this.markPref.set((Object)menuItem.getSelection()).save();
            }
        });
    }

    public void createWordWrapToggle(Menu menu) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = this.getEditor().isWordWrapEnabled();
        menuItem.setText(bl ? " Turn Word Wrap off" : " Turn Word Wrap on");
        menuItem.setImage(GamaIcon.named((String)"editor/word.wrap").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditorToolbar.this.getEditor().setWordWrap(menuItem.getSelection());
            }
        });
    }

    public void createOverviewToggle(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = this.getEditor().isOverviewRulerVisible();
        menuItem.setText(bl ? " Hide markers overview" : " Show markers overview");
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.overview").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = EditorToolbar.this.getEditor().isOverviewRulerVisible();
                if (bl) {
                    EditorToolbar.this.getEditor().hideOverviewRuler();
                } else {
                    EditorToolbar.this.getEditor().showOverviewRuler();
                }
            }
        });
    }

    public void createFoldingToggle(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = this.getEditor().isRangeIndicatorEnabled();
        menuItem.setText(bl ? " Unfold code sections" : " Fold code sections");
        menuItem.setSelection(bl);
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.folding").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditorToolbar.this.getEditor().getAction("FoldingToggle").run();
            }
        });
    }

    public void createLineToggle(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = this.getEditor().isLineNumberRulerVisible();
        menuItem.setText(bl ? " Hide line numbers" : " Display line numbers");
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.numbers").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditorToolbar.this.getEditor().getAction("Linenumbers.Toggle").run();
            }
        });
    }

    private GamlEditor getEditor() {
        return this.editor;
    }

    private static /* synthetic */ void lambda$12(Command command, ICommandListener iCommandListener, DisposeEvent disposeEvent) {
        command.removeCommandListener(iCommandListener);
    }
}

