/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.reference;

import gama.dev.DEBUG;
import gama.gaml.operators.Strings;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import gaml.compiler.ui.editor.GamlEditor;
import gaml.compiler.ui.reference.GamlReferenceMenu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PartInitException;

public class TemplateReferenceMenu
extends GamlReferenceMenu {
    TemplateRoot tree = null;
    TemplateStore store;

    @Override
    protected void fillMenu() {
        if (this.tree == null || this.tree.getChildren().isEmpty()) {
            TemplatePersistenceData[] templatePersistenceDataArray;
            this.tree = new TemplateRoot();
            this.store = this.getEditor().getTemplateStore();
            TemplatePersistenceData[] templatePersistenceDataArray2 = templatePersistenceDataArray = this.store.getTemplateData(false);
            int n = templatePersistenceDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray2[n2];
                this.tree.add(templatePersistenceData);
                ++n2;
            }
        }
        this.tree.fillMenu(this.mainMenu);
    }

    @Override
    public void reset() {
        super.reset();
        this.tree.clear();
        this.tree = null;
    }

    public void editTemplate(String string) {
        boolean bl;
        TemplatePersistenceData templatePersistenceData = this.store.getTemplateData(string);
        boolean bl2 = templatePersistenceData != null;
        GamlEditor gamlEditor = this.getEditor();
        if (templatePersistenceData == null) {
            templatePersistenceData = new TemplatePersistenceData(new Template("", "", "gaml.compiler.gaml.Gaml.Model", gamlEditor.getSelectedText(), true), true, string);
        }
        if (bl = gamlEditor.openEditTemplateDialog((org.eclipse.text.templates.TemplatePersistenceData)templatePersistenceData, bl2)) {
            this.reset();
        }
    }

    @Override
    protected void openView() {
        try {
            WorkbenchHelper.getPage().showView("gaml.compiler.gaml.ui.templates");
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    @Override
    protected Image getImage() {
        return GamaIcon.named((String)"editor/reference.templates").image();
    }

    @Override
    protected String getTitle() {
        return "Templates";
    }

    @Override
    protected boolean isDynamic() {
        return true;
    }

    abstract class Node {
        final Node parent;

        Node(Node node) {
            this.parent = node;
        }

        abstract String getPath();

        abstract String getName();

        abstract Set<Node> getChildren();

        abstract void fillMenu(Menu var1);
    }

    class TemplateNode
    extends Node {
        final String name;
        final String desc;
        final String pattern;
        final int rank;

        TemplateNode(Node node, TemplatePersistenceData templatePersistenceData, int n) {
            super(node);
            this.name = templatePersistenceData.getTemplate().getName();
            this.desc = templatePersistenceData.getTemplate().getDescription();
            this.pattern = templatePersistenceData.getTemplate().getPattern();
            this.rank = n;
        }

        @Override
        String getName() {
            return this.name + ": " + this.desc;
        }

        @Override
        String getPath() {
            String string = this.parent.getPath();
            if (string.isEmpty()) {
                return "" + this.rank;
            }
            return string + "." + this.rank;
        }

        @Override
        Set<Node> getChildren() {
            return Collections.EMPTY_SET;
        }

        @Override
        void fillMenu(Menu menu) {
            Menu menu2 = TemplateReferenceMenu.sub((Menu)menu, (String)this.name, (String)this.desc);
            TemplateReferenceMenu.action((Menu)menu2, (String)"Insert", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DEBUG.OUT((Object)("PATH: " + TemplateNode.this.getPath()));
                    DEBUG.OUT((Object)("NAME: " + TemplateNode.this.getName()));
                    TemplateReferenceMenu.this.applyTemplate(((TemplateNode)TemplateNode.this).TemplateReferenceMenu.this.store.getTemplateData(TemplateNode.this.getPath()).getTemplate());
                }
            }).setToolTipText(this.pattern);
            TemplateReferenceMenu.action((Menu)menu2, (String)"Edit...", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TemplateReferenceMenu.this.editTemplate(TemplateNode.this.getPath());
                }
            });
            TemplateReferenceMenu.action((Menu)menu2, (String)"Delete...", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ((TemplateNode)TemplateNode.this).TemplateReferenceMenu.this.store.delete(((TemplateNode)TemplateNode.this).TemplateReferenceMenu.this.store.getTemplateData(TemplateNode.this.getPath()));
                    TemplateReferenceMenu.this.reset();
                }
            });
        }
    }

    class TemplateRoot
    extends TemplateTree {
        TemplateRoot() {
            super(null, "");
        }

        @Override
        void fillMenu(Menu menu) {
            for (Node node : this.children) {
                node.fillMenu(menu);
            }
        }

        void clear() {
            this.children.clear();
        }

        @Override
        String getPath() {
            return "";
        }
    }

    class TemplateTree
    extends Node {
        final Set<Node> children;
        final String name;

        TemplateTree(Node node, String string) {
            super(node);
            this.children = new LinkedHashSet<Node>();
            this.name = string;
        }

        void add(TemplatePersistenceData templatePersistenceData) {
            String string = templatePersistenceData.getId();
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split("\\.")));
            this.add(templatePersistenceData, arrayList);
        }

        Node childWithName(String string) {
            for (Node node : this.getChildren()) {
                if (!node.getName().equals(string)) continue;
                return node;
            }
            return null;
        }

        void add(TemplatePersistenceData templatePersistenceData, List<String> list) {
            if (list.size() == 0) {
                this.children.add(new TemplateNode(this, templatePersistenceData, 1));
            } else if (list.size() == 1 && Strings.isGamaNumber((String)list.get(0)).booleanValue()) {
                this.children.add(new TemplateNode(this, templatePersistenceData, Integer.decode(list.get(0))));
            } else {
                String string = list.remove(0);
                Node node = this.childWithName(string);
                if (node == null) {
                    node = new TemplateTree(this, string);
                    this.children.add(node);
                }
                ((TemplateTree)node).add(templatePersistenceData, list);
            }
        }

        @Override
        void fillMenu(Menu menu) {
            Menu menu2 = TemplateReferenceMenu.this.sub(menu, this.getName());
            for (Node node : this.children) {
                node.fillMenu(menu2);
            }
            TemplateReferenceMenu.this.sep(menu2);
            TemplateReferenceMenu.action((Menu)menu2, (String)"Add new template here...", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = TemplateReferenceMenu.this.getEditor().getNewTemplateId(TemplateTree.this.getPath());
                    TemplateReferenceMenu.this.editTemplate(string);
                }
            });
        }

        @Override
        String getName() {
            return this.name;
        }

        @Override
        String getPath() {
            String string = this.parent.getPath();
            if (string.isEmpty()) {
                return this.getName();
            }
            return string + "." + this.getName();
        }

        @Override
        Set<Node> getChildren() {
            return this.children;
        }
    }
}

