/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Injector;
import gama.annotations.precompiler.GamlProperties;
import gama.core.common.GamlFileExtension;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.IPreferenceChangeListener;
import gama.core.util.GamaFont;
import gama.dev.DEBUG;
import gama.dev.FLAGS;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.ValidationContext;
import gama.gaml.operators.Strings;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.interfaces.IModelRunner;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaFonts;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.CleanupHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gama.ui.shared.views.toolbar.Selector;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.validation.IGamlBuilderListener;
import gaml.compiler.ui.decorators.GamlAnnotationImageProvider;
import gaml.compiler.ui.editor.GamaSourceViewer;
import gaml.compiler.ui.editor.GamlEditorDragAndDropHandler;
import gaml.compiler.ui.editor.GamlEditorState;
import gaml.compiler.ui.editor.IDiagramOpener;
import gaml.compiler.ui.editor.toolbar.CreateExperimentSelectionListener;
import gaml.compiler.ui.editor.toolbar.EditorSearchControls;
import gaml.compiler.ui.editor.toolbar.EditorToolbar;
import gaml.compiler.ui.editor.toolbar.OpenExperimentSelectionListener;
import gaml.compiler.ui.editor.toolbar.OpenImportedErrorSelectionListener;
import gaml.compiler.ui.editor.toolbar.RevalidateModelSelectionListener;
import gaml.compiler.ui.reference.BuiltinReferenceMenu;
import gaml.compiler.ui.reference.ColorReferenceMenu;
import gaml.compiler.ui.reference.OperatorsReferenceMenu;
import gaml.compiler.ui.reference.TemplateReferenceMenu;
import gaml.compiler.ui.templates.GamlEditTemplateDialog;
import gaml.compiler.ui.templates.GamlEditTemplateDialogFactory;
import gaml.compiler.ui.templates.GamlTemplateStore;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.SurroundWithBracketsStrategy;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.codemining.annotation.AnnotationCodeMiningPreferenceConstants;
import org.eclipse.ui.internal.editors.text.codemining.annotation.AnnotationCodeMiningProvider;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextType;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.editor.validation.MarkerIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class GamlEditor
extends XtextEditor
implements IGamlBuilderListener,
IToolbarDecoratedView {
    private static IPreferenceStore miningPreferencesStore;
    static IDiagramOpener diagramOpener;
    static Map<String, Image> images;
    static Map<String, Image> menu_images;
    static int buttonPadding;
    GamlEditorState state = new GamlEditorState(null, Collections.EMPTY_LIST);
    GamaToolbar2 toolbar;
    Composite toolbarParent;
    private EditorSearchControls findControl;
    @Inject
    public IResourceSetProvider resourceSetProvider;
    @Inject
    Injector injector;
    @Inject
    IModelRunner runner;
    @Inject
    private GamlEditTemplateDialogFactory templateDialogFactory;
    @Inject
    private TemplateStore templateStore;
    @Inject
    private IResourceValidator validator;
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private MarkerTypeProvider markerTypeProvider;
    @Inject
    private IssueResolutionProvider issueResolver;
    @Inject
    private IHighlightingConfiguration highlightingConfiguration;
    private final GamlEditorDragAndDropHandler dndHandler;
    private final IPreferenceChangeListener.IPreferenceAfterChangeListener dndChangedListener = object -> {
        this.uninstallTextDragAndDrop((ISourceViewer)this.getInternalSourceViewer());
        this.installTextDragAndDrop((ISourceViewer)this.getInternalSourceViewer());
    };
    private boolean fIsTextDragAndDropInstalled;
    private URI fileURI;
    static GamlAnnotationImageProvider imageProvider;
    FlatButton fakeButton;
    Set<String> toRemove = Set.of("revert", "save", "Preferences.ContextAction", "QuickAssist", "Open W&ith", "Sho&w In\t\u2325\u2318W", "group.open");

    static {
        DEBUG.ON();
        IPreferenceStore iPreferenceStore = GamlEditor.getPreferences();
        if (iPreferenceStore != null) {
            iPreferenceStore.setDefault("showAnnotationAsCodeMiningLevel", 6);
            iPreferenceStore.setValue("showAnnotationAsCodeMiningLevel", 6);
        }
        images = new HashMap<String, Image>();
        menu_images = new HashMap<String, Image>();
        buttonPadding = 4;
        iPreferenceStore = EditorsUI.getPreferenceStore();
        iPreferenceStore.setDefault("show_range_indicator", false);
        iPreferenceStore.setDefault("spellingEnabled", false);
        iPreferenceStore.setValue("spellingEnabled", false);
        images.put("batch", GamaIcon.named((String)"overlays/small.exp.batch.white").image());
        images.put("record", GamaIcon.named((String)"overlays/small.exp.back.white").image());
        images.put("regular", GamaIcon.named((String)"overlays/small.exp.run.white").image());
        menu_images.put("batch", GamaIcon.named((String)(ThemeHelper.isDark() ? "overlays/small.exp.batch.white" : "overlays/small.exp.batch.green")).image());
        menu_images.put("record", GamaIcon.named((String)(ThemeHelper.isDark() ? "overlays/small.exp.back.white" : "overlays/small.exp.back.green")).image());
        menu_images.put("regular", GamaIcon.named((String)(ThemeHelper.isDark() ? "overlays/small.exp.run.white" : "overlays/small.exp.run.green")).image());
        images.put("new", GamaIcon.named((String)"overlays/small.exp.plus").image());
        imageProvider = new GamlAnnotationImageProvider();
    }

    protected static IPreferenceStore getPreferences() {
        if (miningPreferencesStore == null) {
            miningPreferencesStore = AnnotationCodeMiningPreferenceConstants.getPreferenceStore();
        }
        return miningPreferencesStore;
    }

    public GamlEditor() {
        this.dndHandler = new GamlEditorDragAndDropHandler(this);
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess(){

            public int getLayer(Annotation annotation) {
                if (annotation.isMarkedDeleted()) {
                    return 0;
                }
                return super.getLayer(annotation);
            }

            public void paint(Annotation annotation, GC gC, Canvas canvas, Rectangle rectangle) {
                Image image = imageProvider.getManagedImage(annotation);
                if (image != null) {
                    ImageUtilities.drawImage((Image)image, (GC)gC, (Canvas)canvas, (Rectangle)rectangle, (int)0x1000000, (int)128);
                } else {
                    super.paint(annotation, gC, canvas, rectangle);
                }
            }

            public boolean isPaintable(Annotation annotation) {
                if (imageProvider.getManagedImage(annotation) != null) {
                    return true;
                }
                return super.isPaintable(annotation);
            }
        };
    }

    protected void rulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.rulerContextMenuAboutToShow(iMenuManager);
        iMenuManager.remove("projection");
        MenuManager menuManager = new MenuManager(XtextUIMessages.Editor_FoldingMenu_name, "projection");
        iMenuManager.appendToGroup("rulers", (IContributionItem)menuManager);
        IAction iAction = this.getAction("FoldingToggle");
        menuManager.add(iAction);
        iAction = this.getAction("FoldingExpandAll");
        menuManager.add(iAction);
        iAction = this.getAction("FoldingCollapseAll");
        menuManager.add(iAction);
        iAction = this.getAction("FoldingCollapseStrings");
        menuManager.add(iAction);
        iAction = this.getAction("FoldingRestore");
        menuManager.add(iAction);
    }

    public void dispose() {
        GamaPreferences.Modeling.EDITOR_DRAG_RESOURCES.removeChangeListener((IPreferenceChangeListener)this.dndChangedListener);
        GamlResourceServices.removeResourceListener((IGamlBuilderListener)this);
        super.dispose();
    }

    public GamlTemplateStore getTemplateStore() {
        return (GamlTemplateStore)this.templateStore;
    }

    public GamlEditTemplateDialogFactory getTemplateFactory() {
        return this.templateDialogFactory;
    }

    private void buildRightToolbar() {
        this.toolbar.wipe(16384, false);
        this.toolbar.button(IGamaColors.NEUTRAL, "Waiting...", GamaIcon.named((String)"overlays/status.clock").image(), null, 16384);
        this.toolbar.sep(4, 16384);
        this.findControl = new EditorToolbar(this).fill(this.toolbar.getToolbar(131072));
        this.fakeButton = FlatButton.button((Composite)this.toolbar.getToolbar(16384), (GamaColors.GamaUIColor)IGamaColors.OK, (String)"", (Image)images.get("batch"));
        this.fakeButton.setVisible(false);
        this.toolbar.requestLayout();
    }

    public boolean isLineNumberRulerVisible() {
        IPreferenceStore iPreferenceStore = this.getAdvancedPreferenceStore();
        return iPreferenceStore != null ? iPreferenceStore.getBoolean("lineNumberRuler") : false;
    }

    public boolean isRangeIndicatorEnabled() {
        return this.getInternalSourceViewer().isProjectionMode();
    }

    public final IPreferenceStore getAdvancedPreferenceStore() {
        return super.getPreferenceStore();
    }

    private void configureTabFolder(Composite composite) {
        Composite composite2 = composite;
        while (composite2 != null) {
            if (composite2 instanceof CTabFolder) break;
            composite2 = composite2.getParent();
        }
        if (composite2 != null) {
            CTabFolder cTabFolder = (CTabFolder)composite2;
            cTabFolder.setMaximizeVisible(true);
            cTabFolder.setMinimizeVisible(true);
            cTabFolder.setMinimumCharacters(10);
            cTabFolder.setMRUVisible(true);
            cTabFolder.setUnselectedCloseVisible(true);
            cTabFolder.setHighlightEnabled(true);
        }
    }

    public void createPartControl(Composite composite) {
        DEBUG.OUT((Object)("Creating part control of " + this.getPartName()));
        this.configureTabFolder(composite);
        this.toolbarParent = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite);
        GridLayoutFactory.fillDefaults().spacing(0, 0).extendedMargins(0, 5, 0, 0).applyTo(this.toolbarParent);
        Composite composite2 = new Composite(this.toolbarParent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new FillLayout());
        super.createPartControl(composite2);
        composite2.addControlListener(new ControlListener(){
            long lastEvent;

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                WorkbenchHelper.asyncRun(() -> {
                    long l = System.currentTimeMillis();
                    if (l - this.lastEvent > 500L) {
                        this.lastEvent = l;
                        GamlEditor.this.updateToolbar(GamlEditor.this.state, true);
                    }
                });
            }
        });
        this.toolbarParent.requestLayout();
    }

    public boolean isEditable() {
        return FLAGS.IS_READ_ONLY ? false : super.isEditable();
    }

    protected void initializeDirtyStateSupport() {
        if (this.getDocument() != null) {
            this.fileURI = ((XtextDocument)this.getDocument()).getResourceURI();
            GamlResourceServices.addResourceListener((URI)this.fileURI, (IGamlBuilderListener)this);
            super.initializeDirtyStateSupport();
            this.scheduleValidationJob();
        }
    }

    private void scheduleValidationJob() {
        MarkerIssueProcessor markerIssueProcessor = new MarkerIssueProcessor(this.getResource(), this.getInternalSourceViewer().getAnnotationModel(), this.markerCreator, this.markerTypeProvider);
        ValidationJob validationJob = new ValidationJob(this.validator, (IReadAccess)this.getDocument(), (IValidationIssueProcessor)markerIssueProcessor, CheckMode.FAST_ONLY, (IValidationIssueProcessor)markerIssueProcessor){
            private final /* synthetic */ IValidationIssueProcessor val$processor;
            {
                this.val$processor = iValidationIssueProcessor2;
                super(iResourceValidator, iReadAccess, iValidationIssueProcessor, checkMode);
            }

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                List list = (List)GamlEditor.this.getDocument().readOnly(xtextResource -> {
                    if (xtextResource.isValidationDisabled()) {
                        return Collections.emptyList();
                    }
                    return GamlEditor.this.validator.validate((Resource)xtextResource, this.getCheckMode(), null);
                });
                this.val$processor.processIssues(list, iProgressMonitor);
                return Status.OK_STATUS;
            }
        };
        validationJob.schedule();
    }

    public boolean isOverviewRulerVisible() {
        GamaSourceViewer gamaSourceViewer = this.getInternalSourceViewer();
        if (gamaSourceViewer == null) {
            return super.isOverviewRulerVisible();
        }
        return gamaSourceViewer.isOverviewVisible();
    }

    public void showOverviewRuler() {
        this.getInternalSourceViewer().showAnnotationsOverview(true);
    }

    public void hideOverviewRuler() {
        this.getInternalSourceViewer().showAnnotationsOverview(false);
    }

    public GamaSourceViewer getInternalSourceViewer() {
        return (GamaSourceViewer)super.getInternalSourceViewer();
    }

    protected void installFoldingSupport(ProjectionViewer projectionViewer) {
        super.installFoldingSupport(projectionViewer);
        if (!this.isRangeIndicatorEnabled()) {
            projectionViewer.doOperation(19);
        }
    }

    protected void handleCursorPositionChanged() {
        if (this.getSelectionProvider() == null || this.getInternalSourceViewer() == null || this.getInternalSourceViewer().getControl() == null || this.getInternalSourceViewer().getControl().isDisposed()) {
            return;
        }
        super.handleCursorPositionChanged();
        this.markInNavigationHistory();
    }

    private void updateToolbar(GamlEditorState gamlEditorState, boolean bl) {
        DEBUG.OUT((Object)("Updating toolbar for " + this.getTitle()));
        if (bl || !this.state.equals(gamlEditorState)) {
            WorkbenchHelper.runInUI((String)"Editor refresh", (int)50, iProgressMonitor -> {
                if (this.toolbar == null || this.toolbar.isDisposed()) {
                    return;
                }
                boolean bl = !GamlFileExtension.isExperiment((String)((IFile)this.getDocument().getAdapter(IFile.class)).getName()) && gamlEditorState.showExperiments;
                this.toolbar.wipe(16384, true);
                if (bl) {
                    this.toolbar.getToolbar(16384).button("editor/add.experiment", null, "Add an experiment to the model", (Selector)new CreateExperimentSelectionListener(this, (Control)this.toolbar.getToolbar(16384)));
                    this.toolbar.getToolbar(16384).space(8);
                }
                GamaColors.GamaUIColor gamaUIColor = this.state.getColor();
                String string = this.state.getStatus();
                Object object = null;
                String string2 = null;
                if ("No experiments defined".equals(string)) {
                    string = null;
                } else if (gamlEditorState.hasImportedErrors) {
                    object = new OpenImportedErrorSelectionListener(this, gamlEditorState, (Control)this.toolbar.getToolbar(16384));
                    string2 = "overlays/small.dropdown";
                } else if (string != null) {
                    object = new RevalidateModelSelectionListener(this);
                    string2 = "markers/marker.error";
                } else {
                    object = new OpenExperimentSelectionListener(this, gamlEditorState, this.runner);
                }
                if (string != null) {
                    this.toolbar.button(gamaUIColor, string, GamaIcon.named(string2).image(), (Selector)object, 16384);
                } else if (gamlEditorState.showExperiments) {
                    if (((Boolean)GamaPreferences.Modeling.EDITOR_EXPERIMENT_MENU.getValue()).booleanValue()) {
                        this.displayExperimentMenu(gamlEditorState, (Selector)object);
                    } else if (gamlEditorState.abbreviations.size() <= 1 || !((Boolean)GamaPreferences.Modeling.EDITOR_COLLAPSE_BUTTONS.getValue()).booleanValue()) {
                        this.displayExperimentButtons(gamlEditorState, (Selector)object);
                    } else {
                        int n = this.computeWidth(gamlEditorState);
                        if (n > this.toolbar.getSize().x - this.toolbar.getToolbar((int)131072).getSize().x) {
                            this.displayExperimentMenu(gamlEditorState, (Selector)object);
                        } else {
                            this.displayExperimentButtons(gamlEditorState, (Selector)object);
                        }
                    }
                }
                this.toolbar.requestLayout();
            });
        }
    }

    private int computeWidth(GamlEditorState gamlEditorState) {
        int n = 0;
        for (String string : gamlEditorState.abbreviations) {
            if (string == null) continue;
            this.fakeButton.setText(string);
            n += this.fakeButton.computeSize((int)-1, (int)12).x + 2 * buttonPadding;
        }
        this.fakeButton.setText("Add Experiment");
        return n += this.fakeButton.computeSize((int)-1, (int)12).x + 2 * buttonPadding;
    }

    private void displayExperimentButtons(GamlEditorState gamlEditorState, Selector selector) {
        int n = 0;
        for (String string : gamlEditorState.abbreviations) {
            String string2;
            if (string == null) {
                return;
            }
            String string3 = "batch".equals(string2 = gamlEditorState.types.get(n++)) ? "batch" : ("record".equals(string2) ? "record" : "regular");
            Image image = images.get(string3);
            ToolItem toolItem = this.toolbar.button(IGamaColors.OK, string, image, 16384);
            FlatButton flatButton = (FlatButton)toolItem.getControl();
            flatButton.setRightPadding(buttonPadding);
            flatButton.setToolTipText("Executes the " + string3 + " experiment " + string);
            flatButton.addSelectionListener((SelectionListener)selector);
            toolItem.setData("index", (Object)n);
            flatButton.setData("exp", (Object)string);
        }
    }

    private void displayExperimentMenu(final GamlEditorState gamlEditorState, final Selector selector) {
        ToolItem toolItem = this.toolbar.menu(IGamaColors.OK, "Run Experiment...", 16384);
        FlatButton flatButton = (FlatButton)toolItem.getControl();
        flatButton.setRightPadding(buttonPadding);
        ((FlatButton)toolItem.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){
            Menu menu;

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (this.menu == null) {
                    this.menu = new Menu((Decorations)GamlEditor.this.toolbar.getShell(), 8);
                    this.fillMenu();
                }
                Point point = GamlEditor.this.toolbar.toDisplay(new Point(selectionEvent.x, selectionEvent.y + GamlEditor.this.toolbar.getSize().y));
                this.menu.setLocation(point.x, point.y);
                this.menu.setVisible(true);
            }

            private void fillMenu() {
                int n = 0;
                for (String string : gamlEditorState.abbreviations) {
                    String string2;
                    if (string == null) {
                        return;
                    }
                    String string3 = "batch".equals(string2 = gamlEditorState.types.get(n++)) ? "batch" : ("record".equals(string2) ? "record" : "regular");
                    Image image = menu_images.get(string3);
                    GamaMenu.action((Menu)this.menu, (String)string, (Selector)selector, (Image)image).setData("exp", (Object)string);
                }
            }
        });
    }

    public void validationEnded(ModelDescription modelDescription, Iterable<? extends IDescription> iterable, ValidationContext validationContext) {
        Object object;
        this.getInternalSourceViewer().updateCodeMinings();
        if (((Boolean)GamaPreferences.Experimental.REQUIRED_PLUGINS.getValue()).booleanValue() && modelDescription != null && !validationContext.hasErrors()) {
            object = "@requires";
            GamlProperties gamlProperties = new GamlProperties();
            modelDescription.collectMetaInformation(gamlProperties);
            String string = (String)object + " " + String.valueOf(gamlProperties.get("plugins"));
            this.getInternalSourceViewer();
            IXtextDocument iXtextDocument = this.getDocument();
            WorkbenchHelper.asyncRun(() -> this.lambda$2(iXtextDocument, (String)object, string));
        }
        if (iterable == null && this.state != null) {
            this.updateToolbar(this.state, true);
        } else {
            object = new GamlEditorState(validationContext, iterable);
            this.updateToolbar((GamlEditorState)object, false);
            this.state = object;
        }
    }

    protected void installCodeMiningProviders() {
        ICodeMiningProvider[] iCodeMiningProviderArray = new ICodeMiningProvider[]{new GamlCodeMiningProvider()};
        ((GamaSourceViewer)this.getSourceViewer()).setCodeMiningProviders(iCodeMiningProviderArray);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.beforeSave();
        super.doSave(iProgressMonitor);
    }

    public void doSaveAs() {
        this.beforeSave();
        super.doSaveAs();
    }

    private void beforeSave() {
        if (!((Boolean)GamaPreferences.Modeling.EDITOR_CLEAN_UP.getValue()).booleanValue()) {
            return;
        }
        GamaSourceViewer gamaSourceViewer = this.getInternalSourceViewer();
        Point point = gamaSourceViewer.getSelectedRange();
        gamaSourceViewer.setSelectedRange(0, gamaSourceViewer.getDocument().getLength());
        if (gamaSourceViewer.canDoOperation(15)) {
            gamaSourceViewer.doOperation(15);
        }
        gamaSourceViewer.setSelectedRange(point.x, point.y);
    }

    private StyledText getStyledText() {
        return (StyledText)super.getAdapter(Control.class);
    }

    public void insertText(String string) {
        ITextSelection iTextSelection = (ITextSelection)this.getSelectionProvider().getSelection();
        int n = iTextSelection.getOffset();
        int n2 = iTextSelection.getLength();
        try {
            new ReplaceEdit(n, n2, string).apply((IDocument)this.getDocument());
        }
        catch (BadLocationException | MalformedTreeException throwable) {
            throwable.printStackTrace();
            return;
        }
        this.getSelectionProvider().setSelection((ISelection)new TextSelection((IDocument)this.getDocument(), n + string.length(), 0));
    }

    public String getSelectedText() {
        ITextSelection iTextSelection = (ITextSelection)this.getSelectionProvider().getSelection();
        int n = iTextSelection.getLength();
        if (n == 0) {
            return "";
        }
        IXtextDocument iXtextDocument = this.getDocument();
        try {
            return iXtextDocument.get(iTextSelection.getOffset(), n);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return "";
        }
    }

    public boolean openEditTemplateDialog(TemplatePersistenceData templatePersistenceData, boolean bl) {
        GamlEditTemplateDialog gamlEditTemplateDialog = this.getTemplateFactory().createDialog(templatePersistenceData, bl, this.getEditorSite().getShell());
        if (gamlEditTemplateDialog.open() == 0) {
            this.getTemplateStore().directAdd(gamlEditTemplateDialog.getData(), bl);
            return true;
        }
        return false;
    }

    public String getNewTemplateId(String string) {
        return this.getTemplateStore().getNewIdFromId(string);
    }

    public void applyTemplateAtTheEnd(Template template) {
        try {
            IXtextDocument iXtextDocument = this.getDocument();
            int n = iXtextDocument.getLineOffset(iXtextDocument.getNumberOfLines() - 1);
            iXtextDocument.replace(n, 0, "\n\n");
            Position position = new Position(n += 2, 0);
            XtextTemplateContextType xtextTemplateContextType = new XtextTemplateContextType();
            DocumentTemplateContext documentTemplateContext = new DocumentTemplateContext((TemplateContextType)xtextTemplateContextType, (IDocument)iXtextDocument, position);
            Region region = new Region(n, 0);
            TemplateProposal templateProposal = new TemplateProposal(template, (TemplateContext)documentTemplateContext, (IRegion)region, null);
            templateProposal.apply((ITextViewer)this.getInternalSourceViewer(), '\u0000', 0, n);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void applyTemplate(Template template) {
        XtextTemplateContextType xtextTemplateContextType = new XtextTemplateContextType();
        IXtextDocument iXtextDocument = this.getDocument();
        ITextSelection iTextSelection = (ITextSelection)this.getSelectionProvider().getSelection();
        int n = iTextSelection.getOffset();
        int n2 = iTextSelection.getLength();
        Position position = new Position(n, n2);
        DocumentTemplateContext documentTemplateContext = new DocumentTemplateContext((TemplateContextType)xtextTemplateContextType, (IDocument)iXtextDocument, position);
        Region region = new Region(n, n2);
        TemplateProposal templateProposal = new TemplateProposal(template, (TemplateContext)documentTemplateContext, (IRegion)region, null);
        templateProposal.apply((ITextViewer)this.getInternalSourceViewer(), '\u0000', 0, n);
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.toolbar = gamaToolbar2;
        this.buildRightToolbar();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        super.handlePreferenceStoreChanged(propertyChangeEvent);
        if ("AbstractTextEditor.Color.Background".equals(propertyChangeEvent.getProperty())) {
            this.getVerticalRuler().getControl().setBackground(GamaColors.get((Color)((Color)GamaPreferences.Modeling.EDITOR_BACKGROUND_COLOR.getValue())).color());
            Iterator iterator = ((CompositeRuler)this.getVerticalRuler()).getDecoratorIterator();
            while (iterator.hasNext()) {
                IVerticalRulerColumn iVerticalRulerColumn = (IVerticalRulerColumn)iterator.next();
                iVerticalRulerColumn.getControl().setBackground(GamaColors.get((Color)((Color)GamaPreferences.Modeling.EDITOR_BACKGROUND_COLOR.getValue())).color());
                iVerticalRulerColumn.redraw();
            }
        }
    }

    public void doSearch() {
        if (this.findControl.getFindControl().isFocusControl()) {
            this.findControl.findNext();
        } else {
            this.findControl.getFindControl().setFocus();
        }
    }

    protected void initializeDragAndDrop(ISourceViewer iSourceViewer) {
        GamaPreferences.Modeling.EDITOR_DRAG_RESOURCES.addChangeListener((IPreferenceChangeListener)this.dndChangedListener);
        super.initializeDragAndDrop(iSourceViewer);
    }

    protected void installTextDragAndDrop(ISourceViewer iSourceViewer) {
        this.dndHandler.install((Boolean)GamaPreferences.Modeling.EDITOR_DRAG_RESOURCES.getValue() == false);
    }

    protected void uninstallTextDragAndDrop(ISourceViewer iSourceViewer) {
        this.dndHandler.uninstall();
    }

    protected CompositeRuler createCompositeRuler() {
        return new CompositeRuler(6);
    }

    public URI getURI() {
        return this.fileURI;
    }

    public void switchToDiagram() {
        if (diagramOpener != null) {
            diagramOpener.open(this);
        }
    }

    public void switchToText() {
        if (diagramOpener != null) {
            diagramOpener.close(this);
        }
    }

    public static void setDiagramOpener(IDiagramOpener iDiagramOpener) {
        diagramOpener = iDiagramOpener;
    }

    public void zoom(int n) {
        Font font = this.getStyledText().getFont();
        Font font2 = n != 0 ? GamaFonts.withMagnification((Font)font, (int)n) : GamaFonts.getFont((GamaFont)((GamaFont)GamaPreferences.Modeling.EDITOR_BASE_FONT.getValue()));
        this.setFont(this.getSourceViewer(), font2);
    }

    public void zoomOut() {
        this.zoom(-1);
    }

    public void zoomFit() {
        this.zoom(0);
    }

    public void zoomIn() {
        this.zoom(1);
    }

    private void setFont(ISourceViewer iSourceViewer, Font font) {
        if (iSourceViewer.getDocument() != null) {
            IVerticalRulerExtension iVerticalRulerExtension;
            StyledText styledText;
            ISelectionProvider iSelectionProvider = iSourceViewer.getSelectionProvider();
            ISelection iSelection = iSelectionProvider.getSelection();
            int n = iSourceViewer.getTopIndex();
            StyledText styledText2 = styledText = iSourceViewer.getTextWidget();
            if (iSourceViewer instanceof ITextViewerExtension) {
                ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)iSourceViewer;
                styledText2 = iTextViewerExtension.getControl();
            }
            styledText2.setRedraw(false);
            styledText.setFont(font);
            if (this.getVerticalRuler() instanceof IVerticalRulerExtension) {
                iVerticalRulerExtension = (IVerticalRulerExtension)this.getVerticalRuler();
                iVerticalRulerExtension.setFont(font);
            }
            iSelectionProvider.setSelection(iSelection);
            iSourceViewer.setTopIndex(n);
            if (styledText2 instanceof Composite) {
                iVerticalRulerExtension = (Composite)styledText2;
                iVerticalRulerExtension.layout(true);
            }
            styledText2.setRedraw(true);
        } else {
            StyledText styledText = iSourceViewer.getTextWidget();
            styledText.setFont(font);
            IVerticalRuler iVerticalRuler = this.getVerticalRuler();
            if (iVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension iVerticalRulerExtension = (IVerticalRulerExtension)iVerticalRuler;
                iVerticalRulerExtension.setFont(font);
            }
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        IContributionItem[] iContributionItemArray = iMenuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem != null) {
                MenuManager menuManager;
                if (iContributionItem instanceof MenuManager) {
                    MenuManager menuManager2 = (MenuManager)iContributionItem;
                    DEBUG.OUT((Object)(" --> \"" + menuManager2.getMenuText() + "\""));
                }
                if (iContributionItem instanceof MenuManager && this.toRemove.contains((menuManager = (MenuManager)iContributionItem).getMenuText()) || iContributionItem.getId() != null && this.toRemove.contains(iContributionItem.getId())) {
                    iMenuManager.remove(iContributionItem);
                } else {
                    DEBUG.OUT((Object)("Item " + String.valueOf(iContributionItem)));
                    CleanupHelper.RearrangeMenus.changeIcon((IMenuManager)iMenuManager, (IContributionItem)iContributionItem, (String)iContributionItem.getId());
                }
            }
            ++n2;
        }
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new InternalMenuManager(menu -> new TemplateReferenceMenu().installSubMenuIn((Menu)menu)));
        iMenuManager.add((IContributionItem)new InternalMenuManager(menu -> new BuiltinReferenceMenu().installSubMenuIn((Menu)menu)));
        iMenuManager.add((IContributionItem)new InternalMenuManager(menu -> new OperatorsReferenceMenu().installSubMenuIn((Menu)menu)));
        iMenuManager.add((IContributionItem)new InternalMenuManager(menu -> new ColorReferenceMenu().installSubMenuIn((Menu)menu)));
    }

    static /* synthetic */ IResourceValidator access$2(GamlEditor gamlEditor) {
        return gamlEditor.validator;
    }

    private /* synthetic */ void lambda$2(IXtextDocument iXtextDocument, String string, String string2) {
        try {
            int n = iXtextDocument.search(0, string, true, true, false);
            if (n > -1) {
                int n2 = iXtextDocument.getLineInformationOfOffset(n).getLength();
                if (!string2.equals(iXtextDocument.get(n, n2))) {
                    new ReplaceEdit(n, n2, string2).apply((IDocument)iXtextDocument);
                }
            } else {
                new InsertEdit(0, Strings.LN + string2 + Strings.LN + Strings.LN).apply((IDocument)this.getDocument());
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public static class GamaSourceViewerConfiguration
    extends XtextSourceViewerConfiguration {
        public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
            return super.getTextHover(iSourceViewer, string);
        }

        public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
            Object[] objectArray = super.getAutoEditStrategies(iSourceViewer, string);
            if (!((Boolean)GamaPreferences.Modeling.CORE_SURROUND_SELECTED.getValue()).booleanValue()) {
                return objectArray;
            }
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAutoEditStrategy iAutoEditStrategy = objectArray2[n2];
                if (iAutoEditStrategy instanceof SurroundWithBracketsStrategy) {
                    return objectArray;
                }
                ++n2;
            }
            return (IAutoEditStrategy[])ArrayUtils.insert((int)0, (Object[])objectArray, (Object[])new IAutoEditStrategy[]{new SurroundWithBracketsStrategy(iSourceViewer)});
        }
    }

    public class GamlCodeMiningProvider
    extends AnnotationCodeMiningProvider
    implements ICodeMiningProvider {
        static CompletableFuture<List<? extends ICodeMining>> EMPTY = CompletableFuture.completedFuture(Collections.EMPTY_LIST);

        GamlCodeMiningProvider() {
            this.setContext((IAdaptable)GamlEditor.this);
        }

        public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer iTextViewer, IProgressMonitor iProgressMonitor) {
            if (!((Boolean)GamaPreferences.Modeling.EDITOR_MINING.getValue()).booleanValue()) {
                return EMPTY;
            }
            return super.provideCodeMinings(iTextViewer, iProgressMonitor);
        }
    }

    class InternalMenuManager
    extends MenuManager {
        final Consumer<Menu> fill;

        InternalMenuManager(Consumer<Menu> consumer) {
            this.fill = consumer;
            this.setRemoveAllWhenShown(true);
            this.setVisible(true);
        }

        public void fill(Menu menu, int n) {
            this.fill.accept(menu);
        }
    }
}

