/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.metadata;

import gama.core.outputs.display.AbstractDisplayGraphics;
import gama.dev.DEBUG;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ColorMap;

public class ImageDataLoader {
    private static final TIFFImageReaderSpi READER_SPI = new TIFFImageReaderSpi();
    public static final int IMAGE_ASC = 8;
    public static final int IMAGE_PGM = 9;

    public static ImageData getImageData(IFile iFile) {
        ImageData imageData;
        block20: {
            imageData = null;
            String string = iFile.getFileExtension();
            try {
                iFile.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                System.err.println("Impossible to load the metadata of " + String.valueOf(iFile.getFullPath()));
                coreException.printStackTrace();
            }
            if (string != null) {
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (InputStream inputStream = iFile.getContents(true);){
                        if ("asc".equals(string)) {
                            imageData = ImageDataLoader.readASC(inputStream);
                            break block20;
                        }
                        if ("pgm".equals(string)) {
                            imageData = ImageDataLoader.readPGM(inputStream);
                            break block20;
                        }
                        if (string.contains("tif")) {
                            imageData = ImageDataLoader.readTiff(iFile, inputStream);
                            break block20;
                        }
                        try {
                            imageData = new ImageData(inputStream);
                        }
                        catch (SWTException sWTException) {
                            if ("png".equals(string) || "jpg".equals(string)) {
                                BufferedImage bufferedImage = AbstractDisplayGraphics.toCompatibleImage((BufferedImage)ImageIO.read(new File(iFile.getLocation().toFile().getAbsolutePath())));
                                imageData = ImageDataLoader.convertToSWT(bufferedImage);
                                bufferedImage.flush();
                                imageData.type = "png".equals(string) ? 5 : 4;
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Impossible to load the metadata of " + String.valueOf(iFile.getFullPath()));
                    exception.printStackTrace();
                }
            }
        }
        return imageData;
    }

    private static ImageData readTiff(IFile iFile, InputStream inputStream) throws IOException {
        ImageData imageData;
        block26: {
            imageData = null;
            try {
                Object object;
                imageData = new ImageData(inputStream);
                PaletteData paletteData = imageData.palette;
                if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
                    imageData = null;
                }
                if (imageData == null) {
                    object = ImageIO.read(inputStream);
                    imageData = ImageDataLoader.convertToSWT((BufferedImage)object);
                }
                if (imageData != null) break block26;
                object = null;
                Object var5_12 = null;
                try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(new File(iFile.getLocation().toFile().getAbsolutePath()));){
                    ImageReader imageReader = READER_SPI.createReaderInstance();
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = AbstractDisplayGraphics.toCompatibleImage((BufferedImage)imageReader.read(0));
                    imageData = ImageDataLoader.convertToSWT(bufferedImage);
                    bufferedImage.flush();
                    imageData.type = 6;
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (Exception exception) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    imageData = ImageDataLoader.convertToSWT(bufferedImage);
                    if (imageData != null) break block26;
                    Throwable throwable = null;
                    Object var5_14 = null;
                    try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(new File(iFile.getLocation().toFile().getAbsolutePath()));){
                        ImageReader imageReader = READER_SPI.createReaderInstance();
                        imageReader.setInput(imageInputStream);
                        BufferedImage bufferedImage2 = AbstractDisplayGraphics.toCompatibleImage((BufferedImage)imageReader.read(0));
                        imageData = ImageDataLoader.convertToSWT(bufferedImage2);
                        bufferedImage2.flush();
                        imageData.type = 6;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception2) {
                    try {
                        GeoTiffReader geoTiffReader = new GeoTiffReader((Object)iFile.getLocation().toFile().getAbsolutePath());
                        GridCoverage2D gridCoverage2D = geoTiffReader.read(null);
                        geoTiffReader.dispose();
                        BufferedImage bufferedImage = new BufferedImage(gridCoverage2D.getGridGeometry().getGridRange2D().width, gridCoverage2D.getGridGeometry().getGridRange2D().height, 6);
                        MapContent mapContent = new MapContent();
                        mapContent.getViewport().setCoordinateReferenceSystem(gridCoverage2D.getCoordinateReferenceSystem());
                        GridCoverageLayer gridCoverageLayer = new GridCoverageLayer(gridCoverage2D, ImageDataLoader.createStyle(1, -0.4, 0.2));
                        mapContent.addLayer((Layer)gridCoverageLayer);
                        imageData = ImageDataLoader.convertToSWT(bufferedImage);
                        bufferedImage.flush();
                        mapContent.dispose();
                        imageData.type = 6;
                    }
                    catch (Exception exception3) {
                        BufferedImage bufferedImage = AbstractDisplayGraphics.toCompatibleImage((BufferedImage)ImageIO.read(new File(iFile.getLocation().toFile().getAbsolutePath())));
                        imageData = ImageDataLoader.convertToSWT(bufferedImage);
                        bufferedImage.flush();
                        imageData.type = 6;
                    }
                }
            }
        }
        return imageData;
    }

    private static Style createStyle(int n, double d, double d2) {
        FilterFactory2 filterFactory2 = CommonFactoryFinder.getFilterFactory2();
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        RasterSymbolizer rasterSymbolizer = styleFactory.getDefaultRasterSymbolizer();
        org.geotools.styling.ColorMap colorMap = styleFactory.createColorMap();
        ColorMapEntry colorMapEntry = styleFactory.createColorMapEntry();
        colorMapEntry.setColor((Expression)filterFactory2.literal((Object)"#ff0000"));
        colorMapEntry.setQuantity((Expression)filterFactory2.literal(d));
        ColorMapEntry colorMapEntry2 = styleFactory.createColorMapEntry();
        colorMapEntry2.setColor((Expression)filterFactory2.literal((Object)"#0000ff"));
        colorMapEntry2.setQuantity((Expression)filterFactory2.literal(d2));
        colorMap.addColorMapEntry(colorMapEntry);
        colorMap.addColorMapEntry(colorMapEntry2);
        rasterSymbolizer.setColorMap((ColorMap)colorMap);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSymbolizer});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageData readPGM(InputStream inputStream) {
        int[][] nArray;
        int n;
        Scanner scanner;
        PaletteData paletteData;
        try {
            Throwable throwable = null;
            paletteData = null;
            try {
                scanner = new Scanner(inputStream);
                try {
                    int n2;
                    String string = scanner.nextLine();
                    if (!"p2".equalsIgnoreCase(string)) {
                        DEBUG.ERR((Object)"Not a PGM");
                        scanner.close();
                        return null;
                    }
                    n = scanner.nextInt();
                    int n3 = scanner.nextInt();
                    scanner.nextInt();
                    int n4 = Integer.MIN_VALUE;
                    nArray = new int[n3][n];
                    int n5 = 0;
                    block8: while (true) {
                        if (n5 >= n3) {
                            n5 = 0;
                            break;
                        }
                        n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                ++n5;
                                continue block8;
                            }
                            int n6 = scanner.nextInt();
                            if (n6 > n4) {
                                n4 = n6;
                            }
                            nArray[n5][n2] = n6 * 255;
                            ++n2;
                        }
                        break;
                    }
                    block10: while (n5 < n3) {
                        n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                ++n5;
                                continue block10;
                            }
                            nArray[n5][n2] = (int)((double)nArray[n5][n2] / (double)n4);
                            ++n2;
                        }
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)exception.toString());
            return null;
        }
        paletteData = new PaletteData(0xFF0000, 65280, 255);
        scanner = new ImageData(nArray[0].length, nArray.length, 24, paletteData);
        int n7 = 0;
        block12: while (true) {
            if (n7 >= nArray.length) {
                Scanner scanner2 = scanner;
                ((ImageData)scanner2).type = 9;
                return scanner2;
            }
            n = 0;
            while (true) {
                if (n >= nArray[n7].length) {
                    ++n7;
                    continue block12;
                }
                int n8 = nArray[n7][n];
                scanner.setPixel(n, n7, n8 << 16 | n8 << 8 | n8);
                ++n;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageData readASC(InputStream inputStream) {
        int[][] nArray;
        int n;
        int n2;
        Scanner scanner;
        PaletteData paletteData;
        try {
            Throwable throwable = null;
            paletteData = null;
            try {
                scanner = new Scanner(inputStream);
                try {
                    if (!scanner.hasNext("ncols")) {
                        DEBUG.ERR((Object)"Not an ASC");
                        scanner.close();
                        return null;
                    }
                    scanner.useLocale(Locale.US);
                    n2 = 0;
                    n = 0;
                    double d = 0.0;
                    scanner.next();
                    n2 = scanner.nextInt();
                    scanner.next();
                    n = scanner.nextInt();
                    scanner.nextLine();
                    scanner.nextLine();
                    scanner.nextLine();
                    String string = scanner.nextLine();
                    if (string.startsWith("dx") || string.startsWith("dy")) {
                        scanner.nextLine();
                    }
                    if (scanner.hasNext("NODATA_value")) {
                        scanner.next();
                        d = scanner.nextDouble();
                    }
                    int n3 = 0;
                    int n4 = Integer.MAX_VALUE;
                    nArray = new int[n][n2];
                    int n5 = 0;
                    while (n5 < n) {
                        int n6 = 0;
                        while (n6 < n2) {
                            double d2 = scanner.nextDouble();
                            if (d2 == d) {
                                d2 = 0.0;
                            }
                            if (d2 > (double)n3) {
                                n3 = (int)d2;
                            } else if (d2 < (double)n4) {
                                n4 = (int)d2;
                            }
                            nArray[n5][n6] = (int)d2;
                            ++n6;
                        }
                        ++n5;
                    }
                    n5 = n3 - n4;
                    double d3 = 1.0;
                    d3 = n5 < 255 ? 255.0 / (double)n5 : (double)n5 / 255.0;
                    int n7 = 0;
                    while (n7 < n) {
                        int n8 = 0;
                        while (n8 < n2) {
                            nArray[n7][n8] = (int)((double)(nArray[n7][n8] - n4) * d3);
                            ++n8;
                        }
                        ++n7;
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)exception.toString());
            return null;
        }
        paletteData = new PaletteData(0xFF0000, 65280, 255);
        scanner = new ImageData(nArray[0].length, nArray.length, 24, paletteData);
        n2 = 0;
        while (n2 < nArray.length) {
            n = 0;
            while (n < nArray[n2].length) {
                int n9 = nArray[n2][n];
                scanner.setPixel(n, n2, n9 << 16 | n9 << 8 | n9);
                ++n;
            }
            ++n2;
        }
        Scanner scanner2 = scanner;
        ((ImageData)scanner2).type = 8;
        return scanner2;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData paletteData = new PaletteData(directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), directColorModel.getPixelSize(), paletteData);
            int n = 0;
            while (n < imageData.height) {
                int n2 = 0;
                while (n2 < imageData.width) {
                    int n3 = bufferedImage.getRGB(n2, n);
                    int n4 = paletteData.getPixel(new RGB(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF));
                    imageData.setPixel(n2, n, n4);
                    if (directColorModel.hasAlpha()) {
                        imageData.setAlpha(n2, n, n3 >> 24 & 0xFF);
                    }
                    ++n2;
                }
                ++n;
            }
            return imageData;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            int n = indexColorModel.getMapSize();
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            RGB[] rGBArray = new RGB[n];
            int n5 = 0;
            while (n5 < rGBArray.length) {
                rGBArray[n5] = new RGB(byArray[n5] & 0xFF, byArray2[n5] & 0xFF, byArray3[n5] & 0xFF);
                ++n5;
            }
            PaletteData paletteData = new PaletteData(rGBArray);
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), paletteData);
            imageData.transparentPixel = indexColorModel.getTransparentPixel();
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[1];
            int n6 = 0;
            while (n6 < imageData.height) {
                int n7 = 0;
                while (n7 < imageData.width) {
                    writableRaster.getPixel(n7, n6, nArray);
                    imageData.setPixel(n7, n6, nArray[0]);
                    ++n7;
                }
                ++n6;
            }
            return imageData;
        }
        if (bufferedImage.getColorModel() instanceof ComponentColorModel) {
            ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
            if (componentColorModel.getPixelSize() > 32) {
                BufferedImage bufferedImage2 = AbstractDisplayGraphics.toCompatibleImage((BufferedImage)bufferedImage);
                return ImageDataLoader.convertToSWT(bufferedImage2);
            }
            PaletteData paletteData = new PaletteData(255, 65280, 0xFF0000);
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), componentColorModel.getPixelSize(), paletteData);
            imageData.transparentPixel = -1;
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = componentColorModel.getComponentSize();
            if (nArray.length == 1) {
                int n;
                int n8;
                int n9 = Integer.MIN_VALUE;
                int n10 = Integer.MAX_VALUE;
                int n11 = 0;
                while (n11 < imageData.height) {
                    n8 = 0;
                    while (n8 < imageData.width) {
                        writableRaster.getPixel(n8, n11, nArray);
                        n = nArray[0];
                        if (n > n9) {
                            n9 = n;
                        }
                        if (n < n10) {
                            n10 = n;
                        }
                        ++n8;
                    }
                    ++n11;
                }
                n11 = 0;
                while (n11 < imageData.height) {
                    n8 = 0;
                    while (n8 < imageData.width) {
                        writableRaster.getPixel(n8, n11, nArray);
                        n = (int)(n9 == n10 ? 0.0 : (double)(nArray[0] - n10) / (0.0 + (double)n9 - (double)n10) * 255.0);
                        int n12 = paletteData.getPixel(new RGB(n, n, n));
                        imageData.setPixel(n8, n11, n12);
                        ++n8;
                    }
                    ++n11;
                }
            } else {
                int n = 0;
                while (n < imageData.height) {
                    int n13 = 0;
                    while (n13 < imageData.width) {
                        writableRaster.getPixel(n13, n, nArray);
                        int n14 = paletteData.getPixel(new RGB(nArray[0], nArray[1], nArray[2]));
                        imageData.setPixel(n13, n, n14);
                        ++n13;
                    }
                    ++n;
                }
            }
            return imageData;
        }
        return null;
    }
}

