/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.view.actions.CloseResourceAction;
import gama.ui.navigator.view.actions.OpenFileAction;
import gama.ui.navigator.view.contents.WrappedFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenFileAction openFileAction;
    private ICommonViewerWorkbenchSite viewSite = null;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        if (iCommonActionExtensionSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)iCommonActionExtensionSite.getViewSite();
            this.openFileAction = new OpenFileAction(this.viewSite.getPage());
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (!this.contribute || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.openFileAction.selectionChanged(iStructuredSelection);
        if (this.openFileAction.isEnabled()) {
            iMenuManager.insertAfter("group.open", (IAction)this.openFileAction);
        }
        this.addOpenWithMenu(iMenuManager);
    }

    public void fillActionBars(IActionBars iActionBars) {
        if (!this.contribute) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof WrappedFile) {
            this.openFileAction.selectionChanged(iStructuredSelection);
            iActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openFileAction);
        }
    }

    private void addOpenWithMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (iStructuredSelection == null || iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        IAdaptable iAdaptable = (IAdaptable)CloseResourceAction.getAdapter(object, IResource.class);
        if (iAdaptable == null) {
            iAdaptable = (IAdaptable)CloseResourceAction.getAdapter(object, ResourceMapping.class);
        } else if (((IResource)iAdaptable).getType() != 1) {
            iAdaptable = null;
        }
        if (iAdaptable != null) {
            MenuManager menuManager = new MenuManager(WorkbenchNavigatorMessages.OpenActionProvider_OpenWithMenu_label, "group.openWith");
            menuManager.add((IContributionItem)new GroupMarker("group.top"));
            menuManager.add((IContributionItem)new OpenWithMenu(this.viewSite.getPage(), iAdaptable));
            menuManager.add((IContributionItem)new GroupMarker("additions"));
            if (menuManager.getItems().length > 2 && menuManager.isEnabled()) {
                iMenuManager.appendToGroup("group.openWith", (IContributionItem)menuManager);
            }
        }
    }
}

