/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.viewers.csv;

import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gama.ui.viewers.csv.CSVContentProvider;
import gama.ui.viewers.csv.CSVEditorCellModifier;
import gama.ui.viewers.csv.CSVLabelProvider;
import gama.ui.viewers.csv.CSVTableSorter;
import gama.ui.viewers.csv.DeleteColumnPage;
import gama.ui.viewers.csv.InsertColumnPage;
import gama.ui.viewers.csv.model.CSVModel;
import gama.ui.viewers.csv.model.CSVRow;
import gama.ui.viewers.csv.model.ICsvFileModelListener;
import gama.ui.viewers.csv.text.CSVTableFilter;
import gama.ui.viewers.csv.text.CSVTextEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageCSVEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IToolbarDecoratedView.Sizable {
    private boolean isPageModified;
    public static final int indexSRC = 1;
    public static final int indexTBL = 0;
    protected CSVTextEditor editor;
    protected TableViewer tableViewer;
    final CSVTableSorter tableSorter;
    final CSVTableFilter tableFilter;
    CSVModel model;
    private final ICsvFileModelListener csvFileListener = (cSVRow, n) -> this.tableModified();

    public MultiPageCSVEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.tableFilter = new CSVTableFilter();
        this.tableSorter = new CSVTableSorter();
    }

    public Control getSizableFontControl() {
        if (this.tableViewer == null) {
            return null;
        }
        return this.tableViewer.getTable();
    }

    protected void createPages() {
        try {
            this.model = new CSVModel(MultiPageCSVEditor.getFileFor(this.getEditorInput()));
            this.createTablePage();
            this.createSourcePage();
            this.updateTitle();
            this.populateTablePage();
            this.setActivePage(0);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    private static IFile getFileFor(IEditorInput iEditorInput) {
        if (iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        if (iEditorInput instanceof IStorageEditorInput) {
            try {
                IStorage iStorage = ((IStorageEditorInput)iEditorInput).getStorage();
                if (iStorage instanceof IFile) {
                    return (IFile)iStorage;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private void createSourcePage() {
        try {
            this.editor = new CSVTextEditor(this.model.getCustomDelimiter());
            this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(1, "Text");
        }
        catch (PartInitException partInitException) {}
    }

    private void createTablePage() {
        Composite composite = this.getContainer();
        Composite composite2 = new Composite(composite, 0);
        Composite composite3 = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite2);
        this.tableViewer = new TableViewer(composite3, 68354);
        this.tableViewer.setUseHashlookup(true);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setComparator((ViewerComparator)this.tableSorter);
        this.tableViewer.addFilter((ViewerFilter)this.tableFilter);
        this.addPage((Control)composite2);
        this.setPageText(0, "Table");
    }

    private void updateTitle() {
        IEditorInput iEditorInput = this.getEditorInput();
        this.setPartName(iEditorInput.getName());
        this.setTitleToolTip(iEditorInput.getToolTipText());
    }

    private void populateTablePage() {
        this.tableViewer.setContentProvider((IContentProvider)new CSVContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.getTable().getDisplay().asyncExec(this::updateTableFromTextEditor);
    }

    public void tableModified() {
        this.tableViewer.refresh();
        boolean bl = this.isPageModified;
        this.isPageModified = true;
        if (!bl) {
            this.firePropertyChange(257);
            this.editor.validateEditorInputState();
        }
    }

    void updateTableFromTextEditor() {
        TableColumn[] tableColumnArray;
        this.model.removeModelListener(this.csvFileListener);
        this.model.setInput(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get());
        TableColumn[] tableColumnArray2 = tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray2[n2];
            tableColumn.dispose();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.model.getHeader().size()) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 16384);
            n = n3;
            tableViewerColumn.getColumn().setText(this.model.getHeader().get(n3));
            tableViewerColumn.getColumn().setWidth(100);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.setLabelProvider((CellLabelProvider)new CSVLabelProvider());
            this.addMenuItemToColumn(tableViewerColumn.getColumn(), n);
            ++n3;
        }
        this.tableViewer.setInput((Object)this.model);
        this.model.addModelListener(this.csvFileListener);
        this.defineCellEditing();
    }

    void defineCellEditing() {
        String[] stringArray = new String[this.model.getColumnCount()];
        CellEditor[] cellEditorArray = new CellEditor[this.model.getColumnCount()];
        int n = 0;
        while (n < this.model.getColumnCount()) {
            stringArray[n] = Integer.toString(n);
            cellEditorArray[n] = new TextCellEditor((Composite)this.tableViewer.getTable());
            ++n;
        }
        this.tableViewer.setColumnProperties(stringArray);
        this.tableViewer.setCellEditors(cellEditorArray);
        this.tableViewer.setCellModifier((ICellModifier)new CSVEditorCellModifier());
    }

    int findColumnForName(String string) {
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = 0;
        while (n < tableColumnArray.length) {
            TableColumn tableColumn = tableColumnArray[n];
            if (string.equalsIgnoreCase(tableColumn.getText())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void addMenuItemToColumn(final TableColumn tableColumn, final int n) {
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n2 = MultiPageCSVEditor.this.tableViewer.getTable().getSortDirection();
                switch (n2) {
                    case 128: {
                        n2 = 1024;
                        break;
                    }
                    case 1024: {
                        n2 = 0;
                        break;
                    }
                    case 0: {
                        n2 = 128;
                    }
                }
                MultiPageCSVEditor.this.tableSorter.setColumn(n, n2);
                MultiPageCSVEditor.this.tableViewer.getTable().setSortDirection(n2);
                if (n2 == 0) {
                    MultiPageCSVEditor.this.tableViewer.getTable().setSortColumn(null);
                } else {
                    MultiPageCSVEditor.this.tableViewer.getTable().setSortColumn(tableColumn);
                }
                MultiPageCSVEditor.this.tableViewer.refresh();
            }
        });
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.getActivePage() == 0 && this.isPageModified) {
            this.updateTextEditorFromTable();
        } else {
            this.updateTableFromTextEditor();
        }
        this.isPageModified = false;
        this.editor.doSave(iProgressMonitor);
        this.model.saveMetaData();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        if (this.getActivePage() == 0 && this.isPageModified) {
            this.updateTextEditorFromTable();
        } else {
            this.updateTableFromTextEditor();
        }
        this.isPageModified = false;
        this.editor.doSaveAs();
        this.setInput(this.editor.getEditorInput());
        this.updateTitle();
    }

    protected void handlePropertyChange(int n) {
        if (n == 257) {
            this.isPageModified = this.isDirty();
        }
        super.handlePropertyChange(n);
    }

    public boolean isDirty() {
        return this.isPageModified || super.isDirty();
    }

    protected void pageChange(int n) {
        switch (n) {
            case 1: {
                if (!this.isDirty()) break;
                this.updateTextEditorFromTable();
                break;
            }
            case 0: {
                if (!this.isDirty()) break;
                this.updateTableFromTextEditor();
            }
        }
        this.isPageModified = false;
        super.pageChange(n);
    }

    private void updateTextEditorFromTable() {
        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(((CSVModel)this.tableViewer.getInput()).getTextRepresentation());
    }

    public void setFocus() {
        switch (this.getActivePage()) {
            case 1: {
                this.editor.setFocus();
                break;
            }
            case 0: {
                this.tableViewer.getTable().setFocus();
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 2 || iResourceChangeEvent.getType() == 4) {
            WorkbenchHelper.asyncRun(() -> {
                IWorkbenchPage[] iWorkbenchPageArray;
                IWorkbenchPage[] iWorkbenchPageArray2 = iWorkbenchPageArray = this.getSite().getWorkbenchWindow().getPages();
                int n = iWorkbenchPageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray2[n2];
                    if (((FileEditorInput)this.editor.getEditorInput()).getFile().getProject().equals((Object)iResourceChangeEvent.getResource())) {
                        IEditorPart iEditorPart = iWorkbenchPage.findEditor(this.editor.getEditorInput());
                        iWorkbenchPage.closeEditor(iEditorPart, true);
                    }
                    ++n2;
                }
            });
        } else {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta().findMember(MultiPageCSVEditor.getFileFor(this.getEditorInput()).getFullPath());
            if (iResourceDelta != null) {
                int n;
                if (iResourceDelta.getKind() == 2) {
                    Runnable runnable = () -> {
                        boolean bl = this.getSite().getPage().closeEditor((IEditorPart)this, false);
                    };
                    this.getSite().getShell().getDisplay().asyncExec(runnable);
                } else if (iResourceDelta.getKind() == 4 && (((n = iResourceDelta.getFlags()) & 0x100) != 0 || (n & 0x200000) != 0)) {
                    WorkbenchHelper.asyncRun(this::updateTableFromTextEditor);
                }
            }
        }
    }

    void refreshWithDelimiter(Character c) {
        if (c != null) {
            this.model.setCustomDelimiter(c.charValue());
            this.editor.setDelimiter(c.charValue());
        }
        this.updateTableFromTextEditor();
        this.updateTextEditorFromTable();
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        final Text text = new Text((Composite)gamaToolbar2.getToolbar(16384), 2688);
        gamaToolbar2.control((Control)text, 150, 16384);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                MultiPageCSVEditor.this.tableFilter.setSearchText(text.getText());
                String string = text.getText();
                int n = 0;
                while (n < MultiPageCSVEditor.this.tableViewer.getColumnProperties().length) {
                    CellLabelProvider cellLabelProvider = MultiPageCSVEditor.this.tableViewer.getLabelProvider(n);
                    if (cellLabelProvider != null) {
                        ((CSVLabelProvider)cellLabelProvider).setSearchText(string);
                    }
                    ++n;
                }
                MultiPageCSVEditor.this.tableViewer.refresh();
            }
        });
        gamaToolbar2.menu("viewers/set.delimiter", "Determine which character should be used as delimiter of fields", "Determine which character should be used as delimiter of fields", selectionEvent -> {
            GamaMenu gamaMenu = new GamaMenu(){

                protected void fillMenu() {
                    this.action(", (comma)", (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            MultiPageCSVEditor.this.refreshWithDelimiter(Character.valueOf(','));
                        }
                    }, null);
                    this.action("; (semicolon)", (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            MultiPageCSVEditor.this.refreshWithDelimiter(Character.valueOf(';'));
                        }
                    }, null);
                    this.action("  (space)", (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            MultiPageCSVEditor.this.refreshWithDelimiter(Character.valueOf(' '));
                        }
                    }, null);
                    this.action("  (tabulation)", (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            MultiPageCSVEditor.this.refreshWithDelimiter(Character.valueOf('\t'));
                        }
                    }, null);
                    this.action(": (colon)", (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            MultiPageCSVEditor.this.refreshWithDelimiter(Character.valueOf(':'));
                        }
                    }, null);
                    this.action("| (pipe)", (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            MultiPageCSVEditor.this.refreshWithDelimiter(Character.valueOf('|'));
                        }
                    }, null);
                }
            };
            gamaMenu.open((Control)gamaToolbar2.getToolbar(131072), selectionEvent);
        }, 131072);
        ToolItem toolItem = gamaToolbar2.check("viewers/toggle.header", "First line is header", "First line is header", selectionEvent -> {
            ToolItem toolItem = (ToolItem)selectionEvent.widget;
            this.model.setFirstLineHeader(toolItem.getSelection());
            this.refreshWithDelimiter(null);
        }, 131072);
        toolItem.setSelection(this.model.isFirstLineHeader());
        gamaToolbar2.sep(4, 131072);
        gamaToolbar2.button("viewers/add.row", "Add row", "Insert a new row before the currently selected one or at the end of the file if none is selected", selectionEvent -> {
            CSVRow cSVRow = (CSVRow)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            if (cSVRow != null) {
                this.model.addRowAfterElement(cSVRow);
            } else {
                this.model.addRow();
            }
            this.tableModified();
        }, 131072);
        gamaToolbar2.button("viewers/delete.row", "Delete row", "Delete currently selected rows", selectionEvent -> {
            CSVRow cSVRow = (CSVRow)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            while (cSVRow != null) {
                cSVRow = (CSVRow)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
                if (cSVRow == null) continue;
                this.model.removeRow(cSVRow);
                this.tableModified();
            }
        }, 131072);
        gamaToolbar2.sep(4, 131072);
        if (this.model.isFirstLineHeader()) {
            gamaToolbar2.button("viewers/add.column", "Add column", "Add new column", selectionEvent -> {
                InsertColumnPage insertColumnPage = new InsertColumnPage(this.getSite().getShell(), this.model.getArrayHeader());
                if (insertColumnPage.open() == 0) {
                    String string = insertColumnPage.getColumnNewName();
                    this.model.addColumn(string);
                    this.tableViewer.setInput((Object)this.model);
                    TableColumn tableColumn = new TableColumn(this.tableViewer.getTable(), 16384);
                    tableColumn.setText(string);
                    tableColumn.setWidth(100);
                    tableColumn.setResizable(true);
                    tableColumn.setMoveable(true);
                    this.addMenuItemToColumn(tableColumn, this.model.getColumnCount() - 1);
                    this.defineCellEditing();
                    this.tableModified();
                }
            }, 131072);
        }
        if (this.model.isFirstLineHeader()) {
            gamaToolbar2.button("viewers/delete.column", "Delete column", "Delete one or several column(s)", selectionEvent -> {
                DeleteColumnPage deleteColumnPage = new DeleteColumnPage(this.getSite().getShell(), this.model.getArrayHeader());
                if (deleteColumnPage.open() == 0) {
                    String[] stringArray;
                    String[] stringArray2 = stringArray = deleteColumnPage.getColumnSelected();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray2[n2];
                        int n3 = this.findColumnForName(string);
                        this.tableViewer.getTable().getColumn(n3).dispose();
                        this.model.removeColumn(string);
                        ++n2;
                    }
                    this.tableModified();
                }
            }, 131072);
        }
        gamaToolbar2.sep(4, 131072);
        gamaToolbar2.button("generic/menu.saveas", "Save as...", "Save as...", selectionEvent -> this.doSaveAs(), 131072);
    }
}

