/*
 * Decompiled with CFR 0.152.
 */
package core.configuration.dictionary;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import core.configuration.dictionary.IGenstarDictionary;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.EmergentAttribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.record.RecordAttribute;
import core.metamodel.entity.IEntity;
import core.metamodel.value.IValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonTypeName(value="DICTIONARY")
public class AttributeDictionary
implements IGenstarDictionary<Attribute<? extends IValue>> {
    private Set<Attribute<? extends IValue>> attributes;
    private Map<String, Attribute<? extends IValue>> name2attribute;
    private Set<RecordAttribute<Attribute<? extends IValue>, Attribute<? extends IValue>>> records;
    private EmergentAttribute<? extends IValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> sizeAttribute;
    private String weightAttribute;
    private String identifierAttribute;
    private int level;

    public AttributeDictionary() {
        this.attributes = new LinkedHashSet<Attribute<? extends IValue>>();
        this.records = new HashSet<RecordAttribute<Attribute<? extends IValue>, Attribute<? extends IValue>>>();
        this.name2attribute = new HashMap<String, Attribute<? extends IValue>>();
    }

    public AttributeDictionary(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        this(iGenstarDictionary.getAttributes(), iGenstarDictionary.getRecords(), iGenstarDictionary.getSizeAttribute(), "", "", 0);
    }

    public AttributeDictionary(Collection<Attribute<? extends IValue>> collection) {
        this(collection, Collections.emptySet(), null, "", "", 0);
    }

    @JsonCreator
    public AttributeDictionary(@JsonProperty(value="ATTRIBUTES") Collection<Attribute<? extends IValue>> collection, @JsonProperty(value="RECORDS") Collection<RecordAttribute<Attribute<? extends IValue>, Attribute<? extends IValue>>> collection2, @JsonProperty(value="SIZE ATTRIBUTE") EmergentAttribute<? extends IValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> emergentAttribute, @JsonProperty(value="WEIGHT ATTRIBUTE NAME") String string, @JsonProperty(value="SERIAL ATTRIBUTE NAME") String string2, @JsonProperty(value="LAYER LEVEL") int n) {
        if (collection2 == null) {
            collection2 = Collections.emptyList();
        }
        this.attributes = new LinkedHashSet<Attribute<? extends IValue>>(collection);
        this.records = new HashSet<RecordAttribute<Attribute<? extends IValue>, Attribute<? extends IValue>>>(collection2);
        this.sizeAttribute = emergentAttribute;
        this.name2attribute = collection.stream().collect(Collectors.toMap(IAttribute::getAttributeName, Function.identity()));
        this.name2attribute.put("Entity size", emergentAttribute);
    }

    public AttributeDictionary addAttributes(Attribute<? extends IValue> ... attributeArray) {
        this.attributes.addAll(Arrays.asList(attributeArray));
        this.name2attribute.putAll(Arrays.asList(attributeArray).stream().collect(Collectors.toMap(IAttribute::getAttributeName, Function.identity())));
        return this;
    }

    public AttributeDictionary addAttributes(Collection<Attribute<? extends IValue>> collection) {
        this.attributes.addAll(collection);
        this.name2attribute.putAll(collection.stream().collect(Collectors.toMap(IAttribute::getAttributeName, Function.identity())));
        return this;
    }

    @Override
    public IGenstarDictionary<Attribute<? extends IValue>> addRecords(RecordAttribute<Attribute<? extends IValue>, Attribute<? extends IValue>> ... recordAttributeArray) {
        this.records.addAll(Arrays.asList(recordAttributeArray));
        return this;
    }

    @Override
    public Collection<RecordAttribute<Attribute<? extends IValue>, Attribute<? extends IValue>>> getRecords() {
        return Collections.unmodifiableSet(this.records);
    }

    @Override
    public String getWeightAttributeName() {
        return this.weightAttribute;
    }

    @Override
    public void setWeightAttributeName(String string) {
        this.weightAttribute = string;
    }

    @Override
    public String getIdentifierAttributeName() {
        return this.identifierAttribute;
    }

    @Override
    public void setIdentifierAttributeName(String string) {
        this.identifierAttribute = string;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int n) {
        this.level = n;
    }

    public void setSizeAttribute(EmergentAttribute<? extends IValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> emergentAttribute) {
        this.sizeAttribute = emergentAttribute;
        this.name2attribute.put("Entity size", emergentAttribute);
    }

    @Override
    public EmergentAttribute<? extends IValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> getSizeAttribute() {
        return this.sizeAttribute;
    }

    @Override
    public Collection<Attribute<? extends IValue>> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    @Override
    public Attribute<? extends IValue> getAttribute(String string) {
        Attribute<? extends IValue> attribute = this.name2attribute.get(string);
        if (attribute == null) {
            throw new NullPointerException("This dictionary contains no reference to the attribute with name " + string);
        }
        return attribute;
    }

    @Override
    public IValue getValue(String string) {
        Optional<Attribute> optional = this.attributes.stream().filter(attribute -> attribute.getValueSpace().contains(string)).findFirst();
        if (optional.isPresent()) {
            return optional.get().getValueSpace().getValue(string);
        }
        throw new NullPointerException("This dictionary contains no reference to the value " + string);
    }

    @Override
    public boolean containsAttribute(String string) {
        return this.name2attribute.containsKey(string);
    }

    @Override
    public boolean containsRecord(String string) {
        return this.records.stream().anyMatch(recordAttribute -> recordAttribute.getAttributeName().equals(string));
    }

    @Override
    public boolean containsValue(String string) {
        for (Attribute<? extends IValue> attribute : this.attributes) {
            if (!attribute.getValueSpace().contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IAttribute<? extends IValue>> getAttributeAndRecord() {
        return Stream.concat(this.attributes.stream(), this.records.stream()).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public IGenstarDictionary<Attribute<? extends IValue>> merge(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        AttributeDictionary attributeDictionary = new AttributeDictionary(this);
        attributeDictionary.addAttributes(iGenstarDictionary.getAttributes());
        return attributeDictionary;
    }

    @Override
    public int size() {
        return this.attributes.size();
    }
}

