/*
 * Decompiled with CFR 0.152.
 */
package core.configuration.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import core.configuration.GenstarConfigurationFile;
import core.configuration.dictionary.IGenstarDictionary;
import core.metamodel.io.GSSurveyWrapper;
import java.io.IOException;
import java.util.stream.Collectors;

public class GenstarConfigurationFileSerializer
extends StdSerializer<GenstarConfigurationFile> {
    private static final long serialVersionUID = 1L;

    protected GenstarConfigurationFileSerializer() {
        this(null);
    }

    protected GenstarConfigurationFileSerializer(Class<GenstarConfigurationFile> clazz) {
        super(clazz);
    }

    public void serialize(GenstarConfigurationFile genstarConfigurationFile, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("CONFIGURATION FILE");
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("MAIN DIRECTORY", genstarConfigurationFile.getBaseDirectory().toString());
        jsonGenerator.writeArrayFieldStart("INPUT FILES");
        for (GSSurveyWrapper object : genstarConfigurationFile.getWrappers().keySet()) {
            jsonGenerator.writeString("LAYER LEVEL : " + genstarConfigurationFile.getWrappers().get(object).stream().map(n -> n.toString()).collect(Collectors.joining(";")));
            jsonGenerator.writeObject((Object)object);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeArrayFieldStart("DICTIONARIES");
        for (IGenstarDictionary iGenstarDictionary : genstarConfigurationFile.getDictionaries()) {
            jsonGenerator.writeObject((Object)iGenstarDictionary);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

