/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute;

import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.EmergentAttribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.MappedAttribute;
import core.metamodel.attribute.emergent.AggregateValueFunction;
import core.metamodel.attribute.emergent.CompositeValueFunction;
import core.metamodel.attribute.emergent.CountValueFunction;
import core.metamodel.attribute.emergent.EntityValueFunction;
import core.metamodel.attribute.emergent.aggregator.IAggregatorValueFunction;
import core.metamodel.attribute.emergent.filter.GSMatchFilter;
import core.metamodel.attribute.emergent.filter.GSMatchSelection;
import core.metamodel.attribute.emergent.filter.GSNoFilter;
import core.metamodel.attribute.emergent.filter.IGSEntitySelector;
import core.metamodel.attribute.emergent.filter.predicate.GSMatchPredicate;
import core.metamodel.attribute.mapper.AggregateMapper;
import core.metamodel.attribute.mapper.RecordMapper;
import core.metamodel.attribute.mapper.UndirectedMapper;
import core.metamodel.attribute.mapper.value.NumericValueMapper;
import core.metamodel.attribute.record.RecordAttribute;
import core.metamodel.entity.IEntity;
import core.metamodel.entity.matcher.AttributeVectorMatcher;
import core.metamodel.entity.matcher.MatchType;
import core.metamodel.entity.matcher.TagMatcher;
import core.metamodel.entity.tag.EntityTag;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.binary.BinarySpace;
import core.metamodel.value.binary.BooleanValue;
import core.metamodel.value.categoric.NominalSpace;
import core.metamodel.value.categoric.NominalValue;
import core.metamodel.value.categoric.OrderedSpace;
import core.metamodel.value.categoric.OrderedValue;
import core.metamodel.value.categoric.template.GSCategoricTemplate;
import core.metamodel.value.numeric.ContinuousSpace;
import core.metamodel.value.numeric.ContinuousValue;
import core.metamodel.value.numeric.IntegerSpace;
import core.metamodel.value.numeric.IntegerValue;
import core.metamodel.value.numeric.RangeSpace;
import core.metamodel.value.numeric.RangeValue;
import core.metamodel.value.numeric.template.GSRangeTemplate;
import core.util.data.GSDataParser;
import core.util.data.GSEnumDataType;
import core.util.exception.GSIllegalRangedData;
import core.util.exception.GenstarException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AttributeFactory {
    private static AttributeFactory gaf = new AttributeFactory();
    public static Map<String, IAttribute<? extends IValue>> NIUs = new HashMap<String, IAttribute<? extends IValue>>();
    public static Map<String, EmergentAttribute<IntegerValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?>> SIZE_ATT = new HashMap();

    private AttributeFactory() {
    }

    public static AttributeFactory getFactory() {
        return gaf;
    }

    public static <V extends IValue> Attribute<V> createNIU(Class<V> clazz) {
        String string = String.valueOf(clazz.getSimpleName()) + "Not in universe";
        if (NIUs.containsKey(string)) {
            return (Attribute)NIUs.get(string);
        }
        if (GSEnumDataType.Integer.getGenstarType().equals(clazz)) {
            Attribute<IntegerValue> attribute = new Attribute<IntegerValue>(string);
            attribute.setValueSpace(new IntegerSpace(attribute));
            return NIUs.put(string, attribute);
        }
        if (GSEnumDataType.Continue.getGenstarType().equals(clazz)) {
            if (NIUs.containsKey(string)) {
                return (Attribute)NIUs.get(string);
            }
            return NIUs.put(string, new Attribute(string));
        }
        if (!(GSEnumDataType.Order.getGenstarType().equals(clazz) || GSEnumDataType.Nominal.getGenstarType().equals(clazz) || GSEnumDataType.Boolean.getGenstarType().equals(clazz) || GSEnumDataType.Range.getGenstarType().equals(clazz))) {
            throw new GenstarException(String.valueOf(clazz.getCanonicalName()) + " has not any " + GSEnumDataType.class.getCanonicalName() + " equivalent");
        }
        if (NIUs.containsKey(string)) {
            return (Attribute)NIUs.get(string);
        }
        return NIUs.put(string, new Attribute(string));
    }

    public Attribute<? extends IValue> createAttribute(String string, GSEnumDataType gSEnumDataType) throws GSIllegalRangedData {
        return switch (gSEnumDataType) {
            case GSEnumDataType.Integer -> this.createIntegerAttribute(string);
            case GSEnumDataType.Continue -> this.createContinueAttribute(string);
            case GSEnumDataType.Order -> this.createOrderedAttribute(string, new GSCategoricTemplate());
            case GSEnumDataType.Nominal -> this.createNominalAttribute(string, new GSCategoricTemplate());
            case GSEnumDataType.Range -> throw new IllegalArgumentException("Cannot create range without values to setup template");
            case GSEnumDataType.Boolean -> this.createBooleanAttribute(string);
            default -> throw new GenstarException("Creation attribute failure");
        };
    }

    public Attribute<? extends IValue> createAttribute(String string, GSEnumDataType gSEnumDataType, List<String> list, List<Object> list2) throws GSIllegalRangedData {
        if (list2 == null) {
            return this.createAttribute(string, gSEnumDataType, list);
        }
        assert (list.size() == list2.size());
        Attribute<? extends IValue> attribute = null;
        try {
            attribute = this.createAttribute(string, gSEnumDataType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            attribute = this.createRangeAttribute(string, new GSDataParser().getRangeTemplate(list));
        }
        IValueSpace<? extends IValue> iValueSpace = attribute.getValueSpace();
        int n = 0;
        while (n < list.size()) {
            IValue iValue = iValueSpace.addValue(list.get(n));
            iValue.setActualValue(list2.get(n));
            ++n;
        }
        return attribute;
    }

    public Attribute<? extends IValue> createAttribute(String string2, GSEnumDataType gSEnumDataType, List<String> list) throws GSIllegalRangedData {
        Attribute<? extends IValue> attribute = null;
        try {
            attribute = this.createAttribute(string2, gSEnumDataType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            attribute = this.createRangeAttribute(string2, new GSDataParser().getRangeTemplate(list));
        }
        IValueSpace<? extends IValue> iValueSpace = attribute.getValueSpace();
        list.stream().forEach(string -> {
            Object v = iValueSpace.addValue((String)string);
        });
        return attribute;
    }

    public <V extends IValue> Attribute<V> createAttribute(String string2, List<String> list, Class<V> clazz) throws GSIllegalRangedData {
        Attribute<IValue> attribute = null;
        if (GSEnumDataType.Integer.getGenstarType().equals(clazz)) {
            attribute = this.createIntegerAttribute(string2);
        } else if (GSEnumDataType.Continue.getGenstarType().equals(clazz)) {
            attribute = this.createContinueAttribute(string2);
        } else if (GSEnumDataType.Order.getGenstarType().equals(clazz)) {
            attribute = this.createOrderedAttribute(string2, new GSCategoricTemplate());
        } else if (GSEnumDataType.Nominal.getGenstarType().equals(clazz)) {
            attribute = this.createNominalAttribute(string2, new GSCategoricTemplate());
        } else if (GSEnumDataType.Boolean.getGenstarType().equals(clazz)) {
            attribute = this.createBooleanAttribute(string2);
        } else if (GSEnumDataType.Range.getGenstarType().equals(clazz)) {
            attribute = this.createRangeAttribute(string2, list);
        } else {
            throw new GenstarException(String.valueOf(clazz.getCanonicalName()) + " has not any " + GSEnumDataType.class.getCanonicalName() + " equivalent");
        }
        IValueSpace<IntegerValue> iValueSpace = attribute.getValueSpace();
        list.stream().forEach(string -> {
            Object v = iValueSpace.addValue((String)string);
        });
        return attribute;
    }

    public Attribute<? extends IValue> createAttribute(String string, GSEnumDataType gSEnumDataType, List<String> list, Map<String, String> map) throws GSIllegalRangedData {
        return switch (gSEnumDataType) {
            case GSEnumDataType.Order -> this.createOrderedAttribute(string, new GSCategoricTemplate(), list, map);
            case GSEnumDataType.Nominal -> this.createNominalAttribute(string, new GSCategoricTemplate(), map);
            case GSEnumDataType.Range -> this.createRangeAttribute(string, map);
            case GSEnumDataType.Boolean -> this.createBooleanAttribute(string, map);
            default -> throw new IllegalArgumentException("Cannot create record attribute for " + (Object)((Object)gSEnumDataType) + " type of value attribute");
        };
    }

    public <V extends IValue> MappedAttribute<? extends IValue, V> createSTSMappedAttribute(String string, GSEnumDataType gSEnumDataType, Attribute<V> attribute, Map<Collection<String>, Collection<String>> map) throws GSIllegalRangedData {
        return switch (gSEnumDataType) {
            case GSEnumDataType.Integer -> this.createIntegerAttribute(string, attribute, map);
            case GSEnumDataType.Continue -> this.createContinueAttribute(string, attribute, map);
            case GSEnumDataType.Order -> this.createOrderedAttribute(string, attribute, map.entrySet().stream().collect(Collectors.toMap(entry -> new ArrayList((Collection)entry.getKey()), Map.Entry::getValue, (collection, collection2) -> collection, LinkedHashMap::new)));
            case GSEnumDataType.Nominal -> this.createNominalAttribute(string, new GSCategoricTemplate(), attribute, map);
            case GSEnumDataType.Range -> this.createRangeAttribute(string, new GSDataParser().getRangeTemplate(map.keySet().stream().flatMap(Collection::stream).toList()), attribute, map);
            case GSEnumDataType.Boolean -> this.createBooleanAttribute(string, attribute, map);
            default -> throw new GenstarException("Cannot instanciate " + (Object)((Object)gSEnumDataType) + " data type mapped attribute");
        };
    }

    public <V extends IValue> MappedAttribute<? extends IValue, V> createSTSMappedAttribute(String string, GSEnumDataType gSEnumDataType, Attribute<V> attribute, Map<Collection<String>, Collection<String>> map, Map<String, String> map2) throws GSIllegalRangedData {
        MappedAttribute<IValue, V> mappedAttribute = this.createSTSMappedAttribute(string, gSEnumDataType, attribute, map);
        for (String string2 : map2.keySet()) {
            mappedAttribute.addRecords(map2.get(string2), string2);
        }
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<? extends IValue, V> createSTOMappedAttribute(String string3, GSEnumDataType gSEnumDataType, Attribute<V> attribute, Map<String, String> map) throws GSIllegalRangedData {
        return switch (gSEnumDataType) {
            case GSEnumDataType.Integer -> this.createIntegerRecordAttribute(string3, attribute, map);
            case GSEnumDataType.Continue -> this.createContinueRecordAttribute(string3, attribute, map);
            case GSEnumDataType.Order -> this.createOrderedRecordAttribute(string3, new GSCategoricTemplate(), attribute, map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (string, string2) -> string, LinkedHashMap::new)));
            case GSEnumDataType.Nominal -> this.createNominalRecordAttribute(string3, attribute, map);
            case GSEnumDataType.Range -> this.createRangeRecordAttribute(string3, attribute, map);
            case GSEnumDataType.Boolean -> this.createBooleanRecordAttribute(string3, attribute, map);
            default -> throw new GenstarException("Cannot instanciate " + (Object)((Object)gSEnumDataType) + " data type mapped attribute");
        };
    }

    public RecordAttribute<Attribute<? extends IValue>, Attribute<? extends IValue>> createRecordAttribute(String string, GSEnumDataType gSEnumDataType, Attribute<? extends IValue> attribute) throws GSIllegalRangedData {
        return switch (gSEnumDataType) {
            case GSEnumDataType.Integer -> new RecordAttribute<Attribute<? extends IValue>, Attribute<? extends IValue>>(string, this.createIntegerAttribute(String.valueOf(string) + "_rec"), attribute);
            case GSEnumDataType.Continue -> new RecordAttribute<Attribute<? extends IValue>, Attribute<ContinuousValue>>(string, this.createContinueAttribute(String.valueOf(string) + "_rec"), attribute);
            default -> throw new IllegalArgumentException("Cannot create " + (Object)((Object)gSEnumDataType) + " record attribute - suppose to be " + (Object)((Object)GSEnumDataType.Integer) + " or " + (Object)((Object)GSEnumDataType.Continue));
        };
    }

    public Attribute<IntegerValue> createIntegerAttribute(String string) {
        Attribute<IntegerValue> attribute = new Attribute<IntegerValue>(string);
        attribute.setValueSpace(new IntegerSpace(attribute));
        return attribute;
    }

    public <V extends IValue> MappedAttribute<IntegerValue, V> createIntegerAttribute(String string, Attribute<V> attribute, Map<Collection<String>, Collection<String>> map) {
        UndirectedMapper undirectedMapper = new UndirectedMapper();
        MappedAttribute mappedAttribute = new MappedAttribute(string, attribute, undirectedMapper);
        mappedAttribute.setValueSpace(new IntegerSpace(mappedAttribute));
        undirectedMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(collection -> collection.stream().map(string -> (IntegerValue)mappedAttribute.getValueSpace().addValue((String)string)).collect(Collectors.toSet()), collection -> ((Collection)map.get(collection)).stream().map(string -> attribute.getValueSpace().getValue((String)string)).collect(Collectors.toSet()))));
        undirectedMapper.setRelatedAttribute(mappedAttribute);
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<IntegerValue, V> createIntegerRecordAttribute(String string, Attribute<V> attribute, Map<String, String> map) {
        MappedAttribute<IntegerValue, IntegerValue> mappedAttribute = new MappedAttribute<IntegerValue, IntegerValue>(string, attribute, new RecordMapper());
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        mappedAttribute.setValueSpace(new IntegerSpace(mappedAttribute));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            IntegerValue integerValue = (IntegerValue)mappedAttribute.getValueSpace().addValue(entry.getKey());
            V v = attribute.getValueSpace().getValue(entry.getValue());
            mappedAttribute.addMappedValue(integerValue, (IntegerValue)v);
        }
        return mappedAttribute;
    }

    public Attribute<ContinuousValue> createContinueAttribute(String string) {
        Attribute<ContinuousValue> attribute = new Attribute<ContinuousValue>(string);
        attribute.setValueSpace(new ContinuousSpace(attribute));
        return attribute;
    }

    public <V extends IValue> MappedAttribute<ContinuousValue, V> createContinueAttribute(String string, Attribute<V> attribute, Map<Collection<String>, Collection<String>> map) {
        UndirectedMapper undirectedMapper = new UndirectedMapper();
        MappedAttribute mappedAttribute = new MappedAttribute(string, attribute, undirectedMapper);
        mappedAttribute.setValueSpace(new ContinuousSpace(mappedAttribute));
        undirectedMapper.setRelatedAttribute(mappedAttribute);
        undirectedMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(collection -> collection.stream().map(string -> (ContinuousValue)mappedAttribute.getValueSpace().addValue((String)string)).collect(Collectors.toSet()), collection -> ((Collection)map.get(collection)).stream().map(string -> attribute.getValueSpace().getValue((String)string)).collect(Collectors.toSet()))));
        return mappedAttribute;
    }

    public MappedAttribute<ContinuousValue, ContinuousValue> createContinuedAgregatedAttribute(String string3, Attribute<ContinuousValue> attribute, Map<String, Set<String>> map) {
        AggregateMapper<ContinuousValue> aggregateMapper = new AggregateMapper<ContinuousValue>();
        MappedAttribute<ContinuousValue, ContinuousValue> mappedAttribute = new MappedAttribute<ContinuousValue, ContinuousValue>(string3, attribute, aggregateMapper);
        mappedAttribute.setValueSpace(new ContinuousSpace(mappedAttribute));
        aggregateMapper.setRelatedAttribute(mappedAttribute);
        aggregateMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(string -> (ContinuousValue)mappedAttribute.getValueSpace().addValue((String)string), string2 -> ((Set)map.get(string2)).stream().map(string -> (ContinuousValue)attribute.getValueSpace().getValue((String)string)).collect(Collectors.toSet()))));
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<ContinuousValue, V> createContinueRecordAttribute(String string2, Attribute<V> attribute, Map<String, String> map) {
        MappedAttribute mappedAttribute = new MappedAttribute(string2, attribute, new RecordMapper());
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        mappedAttribute.setValueSpace(new ContinuousSpace(mappedAttribute));
        map.keySet().stream().forEach(string -> {
            boolean bl = mappedAttribute.addMappedValue((ContinuousValue)mappedAttribute.getValueSpace().addValue((String)string), (ContinuousValue)attribute.getValueSpace().getValue((String)map.get(string)));
        });
        return mappedAttribute;
    }

    public Attribute<BooleanValue> createBooleanAttribute(String string) {
        Attribute<BooleanValue> attribute = new Attribute<BooleanValue>(string);
        attribute.setValueSpace(new BinarySpace(attribute));
        return attribute;
    }

    public Attribute<BooleanValue> createBooleanAttribute(String string, Map<String, String> map) {
        Attribute<BooleanValue> attribute = this.createBooleanAttribute(string);
        for (String string2 : map.keySet()) {
            attribute.addRecords(map.get(string2), string2);
        }
        return attribute;
    }

    public <V extends IValue> MappedAttribute<BooleanValue, V> createBooleanAttribute(String string, Attribute<V> attribute, Map<Collection<String>, Collection<String>> map) {
        UndirectedMapper undirectedMapper = new UndirectedMapper();
        MappedAttribute mappedAttribute = new MappedAttribute(string, attribute, undirectedMapper);
        mappedAttribute.setValueSpace(new BinarySpace(mappedAttribute));
        undirectedMapper.setRelatedAttribute(mappedAttribute);
        undirectedMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(collection -> collection.stream().map(string -> (BooleanValue)mappedAttribute.getValueSpace().addValue((String)string)).collect(Collectors.toSet()), collection -> ((Collection)map.get(collection)).stream().map(string -> attribute.getValueSpace().getValue((String)string)).collect(Collectors.toSet()))));
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<BooleanValue, V> createBooleanAttribute(String string, Attribute<V> attribute, Map<Collection<String>, Collection<String>> map, Map<String, String> map2) {
        MappedAttribute<BooleanValue, V> mappedAttribute = this.createBooleanAttribute(string, attribute, map);
        for (String string2 : map2.keySet()) {
            mappedAttribute.addRecords(map2.get(string2), string2);
        }
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<BooleanValue, V> createBooleanRecordAttribute(String string2, Attribute<V> attribute, Map<String, String> map) {
        MappedAttribute mappedAttribute = new MappedAttribute(string2, attribute, new RecordMapper());
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        mappedAttribute.setValueSpace(new BinarySpace(mappedAttribute));
        map.keySet().stream().forEach(string -> {
            boolean bl = mappedAttribute.addMappedValue((BooleanValue)mappedAttribute.getValueSpace().addValue((String)string), (BooleanValue)attribute.getValueSpace().getValue((String)map.get(string)));
        });
        return mappedAttribute;
    }

    public Attribute<OrderedValue> createOrderedAttribute(String string, GSCategoricTemplate gSCategoricTemplate) {
        Attribute<OrderedValue> attribute = new Attribute<OrderedValue>(string);
        attribute.setValueSpace(new OrderedSpace(attribute, gSCategoricTemplate));
        return attribute;
    }

    public Attribute<OrderedValue> createOrderedAttribute(String string2, GSCategoricTemplate gSCategoricTemplate, List<String> list) {
        Attribute<OrderedValue> attribute = new Attribute<OrderedValue>(string2);
        attribute.setValueSpace(new OrderedSpace(attribute, gSCategoricTemplate));
        list.stream().forEach(string -> {
            Object v = attribute.getValueSpace().addValue((String)string);
        });
        return attribute;
    }

    public Attribute<OrderedValue> createOrderedAttribute(String string, GSCategoricTemplate gSCategoricTemplate, List<String> list, Map<String, String> map) {
        Attribute<OrderedValue> attribute = this.createOrderedAttribute(string, gSCategoricTemplate, list);
        for (String string2 : map.keySet()) {
            attribute.addRecords(map.get(string2), string2);
        }
        return attribute;
    }

    public <V extends IValue> MappedAttribute<OrderedValue, V> createOrderedAttribute(String string2, GSCategoricTemplate gSCategoricTemplate, Attribute<V> attribute, LinkedHashMap<List<String>, Collection<String>> linkedHashMap) {
        UndirectedMapper undirectedMapper = new UndirectedMapper();
        MappedAttribute mappedAttribute = new MappedAttribute(string2, attribute, undirectedMapper);
        mappedAttribute.setValueSpace(new OrderedSpace(mappedAttribute, gSCategoricTemplate));
        undirectedMapper.setRelatedAttribute(mappedAttribute);
        LinkedHashMap<Collection<List<OrderedValue>>, Collection<List<IValue>>> linkedHashMap2 = new LinkedHashMap<Collection<List<OrderedValue>>, Collection<List<IValue>>>();
        for (Map.Entry<List<String>, Collection<String>> entry : linkedHashMap.entrySet()) {
            List<OrderedValue> list = entry.getKey().stream().map(string -> (OrderedValue)mappedAttribute.getValueSpace().addValue((String)string)).toList();
            List<IValue> list2 = entry.getValue().stream().map(string -> attribute.getValueSpace().getValue((String)string)).toList();
            linkedHashMap2.put(list, list2);
        }
        undirectedMapper.setMapper(linkedHashMap2);
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<OrderedValue, V> createOrderedAttribute(String string, Attribute<V> attribute, LinkedHashMap<List<String>, Collection<String>> linkedHashMap) {
        return this.createOrderedAttribute(string, new GSCategoricTemplate(), attribute, linkedHashMap);
    }

    public MappedAttribute<OrderedValue, OrderedValue> createOrderedAggregatedAttribute(String string3, GSCategoricTemplate gSCategoricTemplate, Attribute<OrderedValue> attribute, LinkedHashMap<String, List<String>> linkedHashMap) {
        AggregateMapper<OrderedValue> aggregateMapper = new AggregateMapper<OrderedValue>();
        MappedAttribute<OrderedValue, OrderedValue> mappedAttribute = new MappedAttribute<OrderedValue, OrderedValue>(string3, attribute, aggregateMapper);
        mappedAttribute.setValueSpace(new OrderedSpace(mappedAttribute, gSCategoricTemplate));
        aggregateMapper.setRelatedAttribute(mappedAttribute);
        aggregateMapper.setMapper(linkedHashMap.keySet().stream().collect(Collectors.toMap(string -> (OrderedValue)mappedAttribute.getValueSpace().addValue((String)string), string2 -> ((List)linkedHashMap.get(string2)).stream().map(string -> (OrderedValue)attribute.getValueSpace().getValue((String)string)).toList())));
        return mappedAttribute;
    }

    public MappedAttribute<OrderedValue, OrderedValue> createOrderedAggregatedAttribute(String string, Attribute<OrderedValue> attribute, LinkedHashMap<String, List<String>> linkedHashMap) {
        return this.createOrderedAggregatedAttribute(string, new GSCategoricTemplate(), attribute, linkedHashMap);
    }

    public MappedAttribute<OrderedValue, OrderedValue> createOrderedAggregatedAttribute(String string, Attribute<OrderedValue> attribute, LinkedHashMap<String, List<String>> linkedHashMap, Map<String, String> map) {
        MappedAttribute<OrderedValue, OrderedValue> mappedAttribute = this.createOrderedAggregatedAttribute(string, new GSCategoricTemplate(), attribute, linkedHashMap);
        for (String string2 : map.keySet()) {
            mappedAttribute.addRecords(map.get(string2), string2);
        }
        return mappedAttribute;
    }

    public MappedAttribute<IValue, OrderedValue> createOrderedToNumericAttribute(String string, Attribute<OrderedValue> attribute, LinkedHashMap<String, List<Number>> linkedHashMap) {
        NumericValueMapper numericValueMapper = new NumericValueMapper();
        MappedAttribute<IValue, OrderedValue> mappedAttribute = new MappedAttribute<IValue, OrderedValue>(string, attribute, numericValueMapper);
        for (String string2 : linkedHashMap.keySet()) {
            OrderedValue orderedValue = attribute.getValueSpace().getValue(string2);
            List<Number> list = linkedHashMap.get(string2);
            if (list.size() == 1) {
                numericValueMapper.add(orderedValue, list.get(0));
                continue;
            }
            if (list.get(0) == null) {
                numericValueMapper.add(orderedValue, list.get(1), RangeValue.RangeBound.LOWER);
                continue;
            }
            if (list.get(1) == null) {
                numericValueMapper.add(orderedValue, list.get(0), RangeValue.RangeBound.UPPER);
                continue;
            }
            numericValueMapper.add(orderedValue, list.get(0), list.get(1));
        }
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<OrderedValue, V> createOrderedRecordAttribute(String string2, GSCategoricTemplate gSCategoricTemplate, Attribute<V> attribute, LinkedHashMap<String, String> linkedHashMap) {
        MappedAttribute mappedAttribute = new MappedAttribute(string2, attribute, new RecordMapper());
        mappedAttribute.setValueSpace(new OrderedSpace(mappedAttribute, gSCategoricTemplate));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        linkedHashMap.keySet().stream().forEach(string -> {
            boolean bl = mappedAttribute.addMappedValue((OrderedValue)mappedAttribute.getValueSpace().getValue((String)string), (OrderedValue)attribute.getValueSpace().getValue((String)linkedHashMap.get(string)));
        });
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<OrderedValue, V> createOrderedRecordAttribute(String string, Attribute<V> attribute, LinkedHashMap<String, String> linkedHashMap) {
        return this.createOrderedRecordAttribute(string, new GSCategoricTemplate(), attribute, linkedHashMap);
    }

    public Attribute<NominalValue> createNominalAttribute(String string, GSCategoricTemplate gSCategoricTemplate) {
        Attribute<NominalValue> attribute = new Attribute<NominalValue>(string);
        attribute.setValueSpace(new NominalSpace(attribute, gSCategoricTemplate));
        return attribute;
    }

    public Attribute<NominalValue> createNominalAttribute(String string2, GSCategoricTemplate gSCategoricTemplate, Map<String, String> map) {
        Attribute<NominalValue> attribute = this.createNominalAttribute(string2, new GSCategoricTemplate());
        map.values().stream().forEach(string -> {
            Object v = attribute.getValueSpace().addValue((String)string);
        });
        for (String string3 : map.keySet()) {
            attribute.addRecords(map.get(string3), string3);
        }
        return attribute;
    }

    public <V extends IValue> MappedAttribute<NominalValue, V> createNominalAttribute(String string, GSCategoricTemplate gSCategoricTemplate, Attribute<V> attribute, Map<Collection<String>, Collection<String>> map) {
        UndirectedMapper undirectedMapper = new UndirectedMapper();
        MappedAttribute mappedAttribute = new MappedAttribute(string, attribute, undirectedMapper);
        mappedAttribute.setValueSpace(new NominalSpace(mappedAttribute, gSCategoricTemplate));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        undirectedMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(collection -> collection.stream().map(string -> (NominalValue)mappedAttribute.getValueSpace().addValue((String)string)).toList(), collection -> ((Collection)map.get(collection)).stream().map(string -> attribute.getValueSpace().getValue((String)string)).toList())));
        return mappedAttribute;
    }

    public MappedAttribute<NominalValue, NominalValue> createNominalAggregatedAttribute(String string3, GSCategoricTemplate gSCategoricTemplate, Attribute<NominalValue> attribute, Map<String, Collection<String>> map) {
        AggregateMapper<NominalValue> aggregateMapper = new AggregateMapper<NominalValue>();
        MappedAttribute<NominalValue, NominalValue> mappedAttribute = new MappedAttribute<NominalValue, NominalValue>(string3, attribute, aggregateMapper);
        mappedAttribute.setValueSpace(new NominalSpace(mappedAttribute, gSCategoricTemplate));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        aggregateMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(string -> (NominalValue)mappedAttribute.getValueSpace().addValue((String)string), string2 -> ((Collection)map.get(string2)).stream().map(string -> (NominalValue)attribute.getValueSpace().getValue((String)string)).toList())));
        return mappedAttribute;
    }

    public MappedAttribute<NominalValue, NominalValue> createNominalAggregatedAttribute(String string, Attribute<NominalValue> attribute, Map<String, Collection<String>> map) {
        return this.createNominalAggregatedAttribute(string, new GSCategoricTemplate(), attribute, map);
    }

    public MappedAttribute<NominalValue, NominalValue> createNominalAggregatedAttribute(String string, Attribute<NominalValue> attribute, Map<String, Collection<String>> map, Map<String, String> map2) {
        MappedAttribute<NominalValue, NominalValue> mappedAttribute = this.createNominalAggregatedAttribute(string, new GSCategoricTemplate(), attribute, map);
        for (String string2 : map2.keySet()) {
            mappedAttribute.addRecords(map2.get(string2), string2);
        }
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<NominalValue, V> createNominalRecordAttribute(String string2, GSCategoricTemplate gSCategoricTemplate, Attribute<V> attribute, Map<String, String> map) {
        MappedAttribute mappedAttribute = new MappedAttribute(string2, attribute, new RecordMapper());
        mappedAttribute.setValueSpace(new NominalSpace(mappedAttribute, gSCategoricTemplate));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        map.keySet().stream().forEach(string -> {
            boolean bl = mappedAttribute.addMappedValue((NominalValue)mappedAttribute.getValueSpace().addValue((String)string), (NominalValue)attribute.getValueSpace().getValue((String)map.get(string)));
        });
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<NominalValue, V> createNominalRecordAttribute(String string, Attribute<V> attribute, Map<String, String> map) {
        return this.createNominalRecordAttribute(string, new GSCategoricTemplate(), attribute, map);
    }

    public Attribute<RangeValue> createRangeAttribute(String string, GSRangeTemplate gSRangeTemplate) {
        Attribute<RangeValue> attribute = new Attribute<RangeValue>(string);
        attribute.setValueSpace(new RangeSpace(attribute, gSRangeTemplate));
        return attribute;
    }

    public Attribute<RangeValue> createRangeAttribute(String string, GSRangeTemplate gSRangeTemplate, Number number, Number number2) {
        Attribute<RangeValue> attribute = new Attribute<RangeValue>(string);
        attribute.setValueSpace(new RangeSpace(attribute, gSRangeTemplate, number, number2));
        return attribute;
    }

    public Attribute<RangeValue> createRangeAttribute(String string2, List<String> list) throws GSIllegalRangedData {
        Attribute<RangeValue> attribute = this.createRangeAttribute(string2, new GSDataParser().getRangeTemplate(list));
        list.stream().forEach(string -> {
            Object v = attribute.getValueSpace().addValue((String)string);
        });
        ((RangeSpace)attribute.getValueSpace()).consolidateRanges();
        return attribute;
    }

    public Attribute<RangeValue> createRangeAttribute(String string2, List<String> list, Number number, Number number2) throws GSIllegalRangedData {
        Attribute<RangeValue> attribute = this.createRangeAttribute(string2, new GSDataParser().getRangeTemplate(list), number, number2);
        list.stream().forEach(string -> {
            Object v = attribute.getValueSpace().addValue((String)string);
        });
        ((RangeSpace)attribute.getValueSpace()).consolidateRanges();
        return attribute;
    }

    public Attribute<RangeValue> createRangeAttribute(String string, Map<String, String> map) throws GSIllegalRangedData {
        Attribute<RangeValue> attribute = this.createRangeAttribute(string, new ArrayList<String>(map.values()));
        for (String string2 : map.keySet()) {
            attribute.addRecords(map.get(string2), string2);
        }
        return attribute;
    }

    public <V extends IValue> MappedAttribute<RangeValue, V> createRangeAttribute(String string, GSRangeTemplate gSRangeTemplate, Attribute<V> attribute, Map<Collection<String>, Collection<String>> map) {
        UndirectedMapper undirectedMapper = new UndirectedMapper();
        MappedAttribute mappedAttribute = new MappedAttribute(string, attribute, undirectedMapper);
        mappedAttribute.setValueSpace(new RangeSpace(mappedAttribute, gSRangeTemplate));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        undirectedMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(collection -> collection.stream().map(string -> (RangeValue)mappedAttribute.getValueSpace().addValue((String)string)).toList(), collection -> ((Collection)map.get(collection)).stream().map(string -> attribute.getValueSpace().getValue((String)string)).toList())));
        return mappedAttribute;
    }

    public MappedAttribute<RangeValue, RangeValue> createRangeAggregatedAttribute(String string3, GSRangeTemplate gSRangeTemplate, Attribute<RangeValue> attribute, Map<String, Collection<String>> map) {
        AggregateMapper<RangeValue> aggregateMapper = new AggregateMapper<RangeValue>();
        MappedAttribute<RangeValue, RangeValue> mappedAttribute = new MappedAttribute<RangeValue, RangeValue>(string3, attribute, aggregateMapper);
        RangeSpace rangeSpace = (RangeSpace)attribute.getValueSpace();
        mappedAttribute.setValueSpace(new RangeSpace(mappedAttribute, gSRangeTemplate, rangeSpace.getMin(), rangeSpace.getMax()));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        aggregateMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(string -> (RangeValue)mappedAttribute.getValueSpace().addValue((String)string), string2 -> ((Collection)map.get(string2)).stream().map(string -> (RangeValue)attribute.getValueSpace().getValue((String)string)).toList())));
        return mappedAttribute;
    }

    public MappedAttribute<RangeValue, RangeValue> createRangeAggregatedAttribute(String string, GSRangeTemplate gSRangeTemplate, Attribute<RangeValue> attribute, Map<String, Collection<String>> map, Map<String, String> map2) {
        MappedAttribute<RangeValue, RangeValue> mappedAttribute = this.createRangeAggregatedAttribute(string, gSRangeTemplate, attribute, map);
        for (String string2 : map2.keySet()) {
            mappedAttribute.addRecords(map2.get(string2), string2);
        }
        return mappedAttribute;
    }

    public MappedAttribute<RangeValue, RangeValue> createRangeAggregatedAttribute(String string, Attribute<RangeValue> attribute, Map<String, Collection<String>> map) throws GSIllegalRangedData {
        return this.createRangeAggregatedAttribute(string, new GSDataParser().getRangeTemplate(new ArrayList<String>(map.keySet())), attribute, map);
    }

    public MappedAttribute<RangeValue, RangeValue> createRangeAggregatedAttribute(String string, Attribute<RangeValue> attribute, Map<String, Collection<String>> map, Map<String, String> map2) throws GSIllegalRangedData {
        MappedAttribute<RangeValue, RangeValue> mappedAttribute = this.createRangeAggregatedAttribute(string, attribute, map);
        for (String string2 : map2.keySet()) {
            mappedAttribute.addRecords(map2.get(string2), string2);
        }
        return mappedAttribute;
    }

    public <V extends IValue> MappedAttribute<RangeValue, V> createRangeAggregatedRecordAttribute(String string3, Attribute<V> attribute, Map<String, Collection<String>> map) throws GSIllegalRangedData {
        UndirectedMapper undirectedMapper = new UndirectedMapper();
        MappedAttribute mappedAttribute = new MappedAttribute(string3, attribute, undirectedMapper);
        mappedAttribute.setValueSpace(new RangeSpace(mappedAttribute, new GSDataParser().getRangeTemplate(new ArrayList<String>(map.keySet()))));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        undirectedMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(string -> Arrays.asList((RangeValue)mappedAttribute.getValueSpace().addValue((String)string)), string2 -> ((Collection)map.get(string2)).stream().map(string -> attribute.getValueSpace().getValue((String)string)).toList())));
        return mappedAttribute;
    }

    public MappedAttribute<RangeValue, IntegerValue> createRangeToIntegerAggregateAttribute(String string3, Attribute<IntegerValue> attribute, Map<String, Collection<String>> map) throws GSIllegalRangedData {
        UndirectedMapper undirectedMapper = new UndirectedMapper();
        MappedAttribute<RangeValue, IntegerValue> mappedAttribute = new MappedAttribute<RangeValue, IntegerValue>(string3, attribute, undirectedMapper);
        IntegerSpace integerSpace = (IntegerSpace)attribute.getValueSpace();
        mappedAttribute.setValueSpace(new RangeSpace(mappedAttribute, new GSDataParser().getRangeTemplate(new ArrayList<String>(map.keySet())), (Number)integerSpace.getMin(), (Number)integerSpace.getMax()));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        undirectedMapper.setMapper(map.keySet().stream().collect(Collectors.toMap(string -> Arrays.asList((RangeValue)mappedAttribute.getValueSpace().addValue((String)string)), string2 -> ((Collection)map.get(string2)).stream().map(string -> (IntegerValue)attribute.getValueSpace().getValue((String)string)).toList())));
        return mappedAttribute;
    }

    public EmergentAttribute<IntegerValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> createSizeAttribute(String string) {
        if (!SIZE_ATT.containsKey(string)) {
            EmergentAttribute<IntegerValue, Object, Object> emergentAttribute = new EmergentAttribute<IntegerValue, Object, Object>(string);
            emergentAttribute.setValueSpace(new IntegerSpace(emergentAttribute));
            emergentAttribute.setFunction(new CountValueFunction(emergentAttribute));
            emergentAttribute.setTransposer(new GSNoFilter());
            SIZE_ATT.put(string, emergentAttribute);
        }
        return SIZE_ATT.get(string);
    }

    public EmergentAttribute<OrderedValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> createCountAttribute(String string, List<String> list, Map<Integer, String> map) {
        return this.createCountAttribute(string, list, map, new GSNoFilter());
    }

    public EmergentAttribute<OrderedValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, IValue> createCountAttribute(String string, List<String> list, Map<Integer, String> map, IValue ... iValueArray) {
        return this.createCountAttribute(string, list, map, new GSMatchFilter<IValue>(new AttributeVectorMatcher(iValueArray), MatchType.getDefault()));
    }

    public EmergentAttribute<OrderedValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, EntityTag> createCountAttribute(String string, List<String> list, Map<Integer, String> map, EntityTag ... entityTagArray) {
        return this.createCountAttribute(string, list, map, new GSMatchFilter<EntityTag>(new TagMatcher(entityTagArray), MatchType.getDefault()));
    }

    public <T, U> EmergentAttribute<OrderedValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, T> createCountAttribute(String string2, List<String> list, Map<Integer, String> map, IGSEntitySelector<Collection<IEntity<? extends IAttribute<? extends IValue>>>, T> iGSEntitySelector) {
        EmergentAttribute emergentAttribute = new EmergentAttribute(string2);
        emergentAttribute.setValueSpace(new OrderedSpace(emergentAttribute, new GSCategoricTemplate()));
        list.forEach(string -> {
            Object v = emergentAttribute.getValueSpace().addValue((String)string);
        });
        Map map2 = map.keySet().stream().collect(Collectors.toMap(Function.identity(), n -> (OrderedValue)emergentAttribute.getValueSpace().getValue((String)map.get(n))));
        emergentAttribute.setFunction(new CountValueFunction(emergentAttribute, map2));
        emergentAttribute.setTransposer(iGSEntitySelector);
        return emergentAttribute;
    }

    public <V extends IValue> EmergentAttribute<V, IEntity<? extends IAttribute<? extends IValue>>, EntityTag> createValueOfAttribute(String string, Attribute<V> attribute, EntityTag ... entityTagArray) {
        return this.createValueOfAttribute(string, attribute, new GSMatchSelection<EntityTag>(new TagMatcher(entityTagArray), MatchType.getDefault()));
    }

    public <V extends IValue> EmergentAttribute<V, IEntity<? extends IAttribute<? extends IValue>>, IValue> createValueOfAttribute(String string, Attribute<V> attribute, IValue ... iValueArray) {
        return this.createValueOfAttribute(string, attribute, new GSMatchSelection<IValue>(new AttributeVectorMatcher(iValueArray), MatchType.getDefault()));
    }

    public <V extends IValue, T> EmergentAttribute<V, IEntity<? extends IAttribute<? extends IValue>>, T> createValueOfAttribute(String string, Attribute<V> attribute, IGSEntitySelector<IEntity<? extends IAttribute<? extends IValue>>, T> iGSEntitySelector) {
        EmergentAttribute<V, Object, T> emergentAttribute = new EmergentAttribute<V, Object, T>(string);
        emergentAttribute.setValueSpace(attribute.getValueSpace());
        emergentAttribute.setFunction(new EntityValueFunction(attribute));
        emergentAttribute.setTransposer(iGSEntitySelector);
        return emergentAttribute;
    }

    public <V extends IValue, T> EmergentAttribute<V, IEntity<? extends IAttribute<? extends IValue>>, T> createValueOfAttribute(String string2, Attribute<V> attribute, List<String> list, Map<String, String> map, IGSEntitySelector<IEntity<? extends IAttribute<? extends IValue>>, T> iGSEntitySelector) {
        if (list.isEmpty() || map.isEmpty()) {
            return this.createValueOfAttribute(string2, attribute, iGSEntitySelector);
        }
        EmergentAttribute emergentAttribute = new EmergentAttribute(string2);
        if (map.keySet().stream().anyMatch(string -> !attribute.getValueSpace().contains((String)string))) {
            throw new IllegalArgumentException("Trying to setup a irregular mapping: key(s) is (are) missing: " + map.keySet().stream().filter(string -> !attribute.getValueSpace().contains((String)string)).collect(Collectors.joining(";")));
        }
        emergentAttribute.setValueSpace(attribute.getValueSpace().clone(emergentAttribute));
        list.forEach(string -> {
            Object v = emergentAttribute.getValueSpace().addValue((String)string);
        });
        Map<IValue, IValue> map2 = map.keySet().stream().collect(Collectors.toMap(string -> attribute.getValueSpace().getValue((String)string), string -> emergentAttribute.getValueSpace().getValue((String)map.get(string))));
        emergentAttribute.setFunction(new EntityValueFunction(emergentAttribute, attribute, map2));
        emergentAttribute.setTransposer(iGSEntitySelector);
        return emergentAttribute;
    }

    public <V extends IValue> EmergentAttribute<V, Collection<IEntity<? extends IAttribute<? extends IValue>>>, IValue> createAggregatedValueOfAttribute(String string, Attribute<V> attribute, IValue ... iValueArray) {
        return this.createAggregatedValueOfAttribute(string, attribute, IAggregatorValueFunction.getDefaultAggregator(attribute.getValueSpace().getTypeClass()), new GSMatchFilter<IValue>(new AttributeVectorMatcher(iValueArray), MatchType.getDefault()));
    }

    public <V extends IValue> EmergentAttribute<V, Collection<IEntity<? extends IAttribute<? extends IValue>>>, EntityTag> createAggregatedValueOfAttribute(String string, Attribute<V> attribute, EntityTag ... entityTagArray) {
        return this.createAggregatedValueOfAttribute(string, attribute, IAggregatorValueFunction.getDefaultAggregator(attribute.getValueSpace().getTypeClass()), new GSMatchFilter<EntityTag>(new TagMatcher(entityTagArray), MatchType.getDefault()));
    }

    public <V extends IValue, T> EmergentAttribute<V, Collection<IEntity<? extends IAttribute<? extends IValue>>>, T> createAggregatedValueOfAttribute(String string, Attribute<V> attribute, IAggregatorValueFunction<V> iAggregatorValueFunction, IGSEntitySelector<Collection<IEntity<? extends IAttribute<? extends IValue>>>, T> iGSEntitySelector) {
        EmergentAttribute<V, Collection<IEntity<? extends IAttribute<? extends IValue>>>, T> emergentAttribute = new EmergentAttribute<V, Collection<IEntity<? extends IAttribute<? extends IValue>>>, T>(string);
        emergentAttribute.setValueSpace(attribute.getValueSpace().clone(emergentAttribute));
        emergentAttribute.setFunction(new AggregateValueFunction<V>(iAggregatorValueFunction, attribute));
        emergentAttribute.setTransposer(iGSEntitySelector);
        return emergentAttribute;
    }

    public EmergentAttribute<? extends IValue, ?, ?> createTransposedValuesAttribute(String string, Collection<String> collection, GSEnumDataType gSEnumDataType, Map<Collection<GSMatchPredicate<?, ?>>, String> map) {
        return switch (gSEnumDataType) {
            case GSEnumDataType.Boolean -> this.createEmergentBoolean(string, collection, map);
            case GSEnumDataType.Continue -> this.createEmergentContinue(string, collection, map);
            case GSEnumDataType.Integer -> this.createEmergentInteger(string, collection, map);
            case GSEnumDataType.Nominal -> this.createEmergentNominal(string, collection, map);
            case GSEnumDataType.Order -> this.createEmergentOrder(string, collection, map);
            case GSEnumDataType.Range -> this.createEmergentRange(string, collection, map);
            default -> throw new GenstarException("Creation attribute failure");
        };
    }

    private EmergentAttribute<? extends IValue, ?, ?> createEmergentRange(String string, Collection<String> collection, Map<Collection<GSMatchPredicate<?, ?>>, String> map) {
        EmergentAttribute emergentAttribute = new EmergentAttribute(string);
        RangeSpace rangeSpace = null;
        try {
            rangeSpace = new RangeSpace(emergentAttribute, new GSDataParser().getRangeTemplate(new ArrayList<String>(collection)));
        }
        catch (GSIllegalRangedData gSIllegalRangedData) {
            gSIllegalRangedData.printStackTrace();
        }
        if (rangeSpace != null) {
            emergentAttribute.setValueSpace(rangeSpace);
            for (String string2 : collection) {
                rangeSpace.addValue(string2);
            }
            CompositeValueFunction compositeValueFunction = new CompositeValueFunction(emergentAttribute);
            map.entrySet().stream().forEach(entry -> ((Collection)entry.getKey()).stream().forEach(gSMatchPredicate -> compositeValueFunction.addPredicate((GSMatchPredicate<?, ?>)gSMatchPredicate, (RangeValue)emergentAttribute.getValueSpace().getValue((String)entry.getValue()))));
        }
        return emergentAttribute;
    }

    private EmergentAttribute<? extends IValue, ?, ?> createEmergentOrder(String string2, Collection<String> collection, Map<Collection<GSMatchPredicate<?, ?>>, String> map) {
        EmergentAttribute emergentAttribute = new EmergentAttribute(string2);
        OrderedSpace orderedSpace = new OrderedSpace(emergentAttribute, new GSCategoricTemplate());
        emergentAttribute.setValueSpace(orderedSpace);
        collection.stream().forEach(string -> {
            Object v = orderedSpace.addValue((String)string);
        });
        CompositeValueFunction compositeValueFunction = new CompositeValueFunction(emergentAttribute);
        map.entrySet().stream().forEach(entry -> ((Collection)entry.getKey()).stream().forEach(gSMatchPredicate -> compositeValueFunction.addPredicate((GSMatchPredicate<?, ?>)gSMatchPredicate, (OrderedValue)emergentAttribute.getValueSpace().getValue((String)entry.getValue()))));
        return emergentAttribute;
    }

    private EmergentAttribute<? extends IValue, ?, ?> createEmergentNominal(String string2, Collection<String> collection, Map<Collection<GSMatchPredicate<?, ?>>, String> map) {
        EmergentAttribute emergentAttribute = new EmergentAttribute(string2);
        NominalSpace nominalSpace = new NominalSpace(emergentAttribute, new GSCategoricTemplate());
        emergentAttribute.setValueSpace(nominalSpace);
        collection.stream().forEach(string -> {
            Object v = nominalSpace.addValue((String)string);
        });
        CompositeValueFunction compositeValueFunction = new CompositeValueFunction(emergentAttribute);
        map.entrySet().stream().forEach(entry -> ((Collection)entry.getKey()).stream().forEach(gSMatchPredicate -> compositeValueFunction.addPredicate((GSMatchPredicate<?, ?>)gSMatchPredicate, (NominalValue)emergentAttribute.getValueSpace().getValue((String)entry.getValue()))));
        return emergentAttribute;
    }

    private EmergentAttribute<? extends IValue, ?, ?> createEmergentInteger(String string2, Collection<String> collection, Map<Collection<GSMatchPredicate<?, ?>>, String> map) {
        EmergentAttribute emergentAttribute = new EmergentAttribute(string2);
        IntegerSpace integerSpace = new IntegerSpace(emergentAttribute);
        emergentAttribute.setValueSpace(integerSpace);
        collection.stream().forEach(string -> {
            Object v = integerSpace.addValue((String)string);
        });
        CompositeValueFunction compositeValueFunction = new CompositeValueFunction(emergentAttribute);
        map.entrySet().stream().forEach(entry -> ((Collection)entry.getKey()).stream().forEach(gSMatchPredicate -> compositeValueFunction.addPredicate((GSMatchPredicate<?, ?>)gSMatchPredicate, (IntegerValue)emergentAttribute.getValueSpace().getValue((String)entry.getValue()))));
        return emergentAttribute;
    }

    private EmergentAttribute<? extends IValue, ?, ?> createEmergentContinue(String string2, Collection<String> collection, Map<Collection<GSMatchPredicate<?, ?>>, String> map) {
        EmergentAttribute emergentAttribute = new EmergentAttribute(string2);
        ContinuousSpace continuousSpace = new ContinuousSpace(emergentAttribute);
        emergentAttribute.setValueSpace(continuousSpace);
        collection.stream().forEach(string -> {
            Object v = continuousSpace.addValue((String)string);
        });
        CompositeValueFunction compositeValueFunction = new CompositeValueFunction(emergentAttribute);
        map.entrySet().stream().forEach(entry -> ((Collection)entry.getKey()).stream().forEach(gSMatchPredicate -> compositeValueFunction.addPredicate((GSMatchPredicate<?, ?>)gSMatchPredicate, (ContinuousValue)emergentAttribute.getValueSpace().getValue((String)entry.getValue()))));
        return emergentAttribute;
    }

    private EmergentAttribute<? extends IValue, ?, ?> createEmergentBoolean(String string2, Collection<String> collection, Map<Collection<GSMatchPredicate<?, ?>>, String> map) {
        EmergentAttribute emergentAttribute = new EmergentAttribute(string2);
        BinarySpace binarySpace = new BinarySpace(emergentAttribute);
        emergentAttribute.setValueSpace(binarySpace);
        collection.stream().forEach(string -> {
            Object v = binarySpace.addValue((String)string);
        });
        CompositeValueFunction compositeValueFunction = new CompositeValueFunction(emergentAttribute);
        map.entrySet().stream().forEach(entry -> ((Collection)entry.getKey()).stream().forEach(gSMatchPredicate -> compositeValueFunction.addPredicate((GSMatchPredicate<?, ?>)gSMatchPredicate, (BooleanValue)emergentAttribute.getValueSpace().getValue((String)entry.getValue()))));
        return emergentAttribute;
    }

    public <V extends IValue> MappedAttribute<RangeValue, V> createRangeRecordAttribute(String string2, Attribute<V> attribute, Map<String, String> map) throws GSIllegalRangedData {
        MappedAttribute mappedAttribute = new MappedAttribute(string2, attribute, new RecordMapper());
        mappedAttribute.setValueSpace(new RangeSpace(mappedAttribute, new GSDataParser().getRangeTemplate(new ArrayList<String>(map.keySet()))));
        mappedAttribute.getAttributeMapper().setRelatedAttribute(mappedAttribute);
        map.keySet().stream().forEach(string -> {
            boolean bl = mappedAttribute.addMappedValue((RangeValue)mappedAttribute.getValueSpace().addValue((String)string), (RangeValue)attribute.getValueSpace().getValue((String)map.get(string)));
        });
        return mappedAttribute;
    }

    public <V extends IValue> void setReferent(MappedAttribute<? extends IValue, V> mappedAttribute, Attribute<V> attribute) {
        mappedAttribute.setReferentAttribute(attribute);
    }
}

