/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.configuration.jackson.attribute.AttributeDeserializer;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.EmergentAttribute;
import core.metamodel.attribute.MappedAttribute;
import core.metamodel.attribute.mapper.value.EncodedValueMapper;
import core.metamodel.attribute.record.RecordAttribute;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Attribute.class), @JsonSubTypes.Type(value=MappedAttribute.class), @JsonSubTypes.Type(value=RecordAttribute.class), @JsonSubTypes.Type(value=EmergentAttribute.class)})
@JsonDeserialize(using=AttributeDeserializer.class)
@JsonPropertyOrder(value={"NAME", "VALUE SPACE"})
public interface IAttribute<V extends IValue> {
    public static final String VALUE_SPACE = "VALUE SPACE";
    public static final String ENCODED_MAPPER = "CODE MAPPER";
    public static final String NAME = "NAME";

    @JsonProperty(value="NAME")
    public String getAttributeName();

    public String getDescription();

    @JsonProperty(value="VALUE SPACE")
    @JsonManagedReference(value="REFERENCE ATTRIBUTE")
    public IValueSpace<V> getValueSpace();

    public void setValueSpace(IValueSpace<V> var1);

    @JsonProperty(value="ENCODED VALUES")
    public EncodedValueMapper<V> getEncodedValueMapper();

    @JsonProperty(value="ENCODED VALUES")
    public void setEncodedValueMapper(EncodedValueMapper<V> var1);

    @JsonIgnore
    default public int getHashCode() {
        int n = 1;
        n = 31 * n + this.getAttributeName().hashCode();
        n = 31 * n + this.getValueSpace().getHashCode();
        return n;
    }

    default public boolean isEqual(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IAttribute iAttribute = (IAttribute)object;
        return !(this.getValueSpace() == null ? iAttribute.getValueSpace() != null : !this.getAttributeName().equals(iAttribute.getAttributeName()));
    }
}

