/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.emergent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.emergent.IGSValueFunction;
import core.metamodel.entity.IEntity;
import core.metamodel.value.IValue;
import core.util.data.GSDataParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

@JsonTypeName(value="EMERGENT COUNT FUNCTION")
public class CountValueFunction<E extends IEntity<? extends IAttribute<? extends IValue>>, V extends IValue>
implements IGSValueFunction<Collection<E>, V> {
    public static final String SELF = "EMERGENT COUNT FUNCTION";
    private Map<Integer, V> mapping;
    private Attribute<V> referent;

    public CountValueFunction(Attribute<V> attribute, Map<Integer, V> map) {
        this.referent = attribute;
        this.mapping = this.checkMapping(map);
    }

    public CountValueFunction(Attribute<V> attribute) {
        this.referent = attribute;
    }

    @Override
    public V apply(Collection<E> collection) {
        int n = collection.size();
        if (this.mapping == null) {
            return this.referent.getValueSpace().getValue(Integer.toString(n));
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mapping.keySet());
        Collections.sort(arrayList);
        return (V)((Integer)arrayList.get(0) <= n ? (IValue)this.mapping.get(arrayList.get(0)) : ((Integer)arrayList.get(arrayList.size() - 1) >= n ? (IValue)this.mapping.get(arrayList.get(arrayList.size() - 1)) : (IValue)this.mapping.get(arrayList.stream().filter(n2 -> n2 == n).findFirst().get())));
    }

    @Override
    public Collection<Map<IAttribute<? extends IValue>, IValue>> reverse(Map<IAttribute<? extends IValue>, IValue> map) {
        return null;
    }

    @Override
    public Attribute<V> getReferent() {
        return this.referent;
    }

    @Override
    public void setReferent(Attribute<V> attribute) {
        this.referent = attribute;
    }

    @JsonProperty(value="VALUE MAPPING")
    public Map<Integer, V> getMapping() {
        return Collections.unmodifiableMap(this.mapping);
    }

    @JsonProperty(value="VALUE MAPPING")
    public void setMapping(Map<Integer, V> map) {
        this.mapping = this.checkMapping(map);
    }

    private Map<Integer, V> checkMapping(Map<?, V> map) {
        GSDataParser gSDataParser = new GSDataParser();
        if (map.values().stream().anyMatch(iValue -> !this.referent.getValueSpace().contains((IValue)iValue))) {
            throw new IllegalArgumentException("Trying to setup mapping with inconsistent value mapping :" + map.values().stream().filter(iValue -> !this.referent.getValueSpace().contains((IValue)iValue)).map(IValue::getStringValue).collect(Collectors.joining(";")));
        }
        if (map.keySet().stream().anyMatch(object -> !(object instanceof Integer))) {
            throw new IllegalArgumentException("Trying to setup count mapping with not integer key :" + map.keySet().stream().filter(object -> !gSDataParser.getValueType(object.toString()).isNumericValue()).map(object -> object.toString()).collect(Collectors.joining(";")));
        }
        return map.keySet().stream().collect(Collectors.toMap(object -> Integer.valueOf(object.toString()), object -> (IValue)map.get(object)));
    }
}

