/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.emergent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.emergent.IGSValueFunction;
import core.metamodel.entity.IEntity;
import core.metamodel.value.IValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonTypeName(value="ENTITY ATTRIBUTE VALUE FUNCTION")
public class EntityValueFunction<E extends IEntity<? extends IAttribute<? extends IValue>>, V extends IValue>
implements IGSValueFunction<E, V> {
    public static final String SELF = "ENTITY ATTRIBUTE VALUE FUNCTION";
    private Map<V, V> mapping;
    private Attribute<V> superReferent;
    private Attribute<V> subReferent;

    public EntityValueFunction(Attribute<V> attribute, Attribute<V> attribute2, Map<V, V> map) {
        this.superReferent = attribute;
        this.subReferent = attribute2;
        this.mapping = this.checkMapping(map);
    }

    public EntityValueFunction(Attribute<V> attribute) {
        this.mapping = attribute.getValueSpace().getValues().stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
        this.superReferent = attribute;
        this.subReferent = attribute;
    }

    @Override
    public V apply(E e) {
        return (V)((IValue)this.mapping.get(e.getValueForAttribute(this.subReferent.getAttributeName())));
    }

    @Override
    public Collection<Map<IAttribute<? extends IValue>, IValue>> reverse(Map<IAttribute<? extends IValue>, IValue> map) {
        return null;
    }

    @Override
    public Attribute<V> getReferent() {
        return this.superReferent;
    }

    @Override
    public void setReferent(Attribute<V> attribute) {
        this.superReferent = attribute;
    }

    @JsonProperty(value="VALUE MAPPING")
    public Map<V, V> getMapping() {
        return Collections.unmodifiableMap(this.mapping);
    }

    @JsonProperty(value="VALUE MAPPING")
    public void setMapping(Map<V, V> map) {
        this.mapping = this.checkMapping(map);
    }

    private Map<V, V> checkMapping(Map<V, V> map) {
        if (map.keySet().stream().anyMatch(iValue -> !this.subReferent.getValueSpace().contains((IValue)iValue)) || map.values().stream().anyMatch(iValue -> !this.superReferent.getValueSpace().contains((IValue)iValue))) {
            throw new IllegalArgumentException("Trying to setup mapper with inconsistent mapping : {subEntity = " + map.keySet().stream().filter(iValue -> !this.subReferent.getValueSpace().contains((IValue)iValue)).map(IValue::getStringValue).collect(Collectors.joining(";")) + "} | {superEntity = " + map.values().stream().filter(iValue -> !this.superReferent.getValueSpace().contains((IValue)iValue)).map(IValue::getStringValue).collect(Collectors.joining(";")) + "}");
        }
        return map;
    }
}

