/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.mapper;

import core.metamodel.attribute.MappedAttribute;
import core.metamodel.attribute.mapper.IAttributeMapper;
import core.metamodel.value.IValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class UndirectedMapper<K extends IValue, V extends IValue>
implements IAttributeMapper<K, V> {
    private Map<Collection<K>, Collection<V>> map = new LinkedHashMap<Collection<K>, Collection<V>>();
    private MappedAttribute<K, V> relatedAttribute;

    @Override
    public boolean add(K k, V v) {
        if (this.map.keySet().stream().anyMatch(collection -> collection.contains(k))) {
            return this.map.get(this.map.keySet().stream().filter(collection -> collection.contains(k)).findFirst().get()).add(v);
        }
        if (this.map.values().stream().anyMatch(collection -> collection.contains(v))) {
            return this.map.keySet().stream().filter(collection -> this.map.get(collection).contains(v)).findFirst().get().add(k);
        }
        if (this.getRelatedAttribute().getValueSpace().contains((IValue)k) && this.getRelatedAttribute().getReferentAttribute().getValueSpace().getValues().contains(v)) {
            this.map.put(new ArrayList<IValue>(Arrays.asList(k)), new ArrayList<IValue>(Arrays.asList(v)));
            return true;
        }
        return false;
    }

    @Override
    public Collection<? extends IValue> getMappedValues(IValue iValue) {
        if (!this.map.values().stream().flatMap(Collection::stream).anyMatch(iValue2 -> iValue2.equals(iValue)) && !this.map.keySet().stream().flatMap(Collection::stream).anyMatch(iValue2 -> iValue2.equals(iValue))) {
            throw new NullPointerException("Value " + iValue + " is not linked to this mapped attribute (" + this.getRelatedAttribute() + ")");
        }
        return this.map.entrySet().stream().filter(entry -> ((Collection)entry.getKey()).contains(iValue)).count() != 0L ? this.map.entrySet().stream().filter(entry -> ((Collection)entry.getKey()).contains(iValue)).flatMap(entry -> ((Collection)entry.getValue()).stream()).toList() : this.map.entrySet().stream().filter(entry -> ((Collection)entry.getValue()).contains(iValue)).flatMap(entry -> ((Collection)entry.getKey()).stream()).toList();
    }

    @Override
    public void setRelatedAttribute(MappedAttribute<K, V> mappedAttribute) {
        this.relatedAttribute = mappedAttribute;
    }

    @Override
    public MappedAttribute<K, V> getRelatedAttribute() {
        return this.relatedAttribute;
    }

    @Override
    public Map<Collection<K>, Collection<V>> getRawMapper() {
        return Collections.unmodifiableMap(this.map);
    }

    public Map<Collection<K>, Collection<V>> getMapper() {
        return Collections.unmodifiableMap(this.map);
    }

    public void setMapper(Map<Collection<K>, Collection<V>> map) {
        this.map = map;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.map == null ? 0 : this.map.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UndirectedMapper undirectedMapper = (UndirectedMapper)object;
        return !(this.map == null ? undirectedMapper.map != null : !this.map.equals(undirectedMapper.map));
    }
}

