/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.mapper.value;

import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.AttributeFactory;
import core.metamodel.attribute.MappedAttribute;
import core.metamodel.attribute.mapper.IAttributeMapper;
import core.metamodel.value.IValue;
import core.metamodel.value.categoric.OrderedValue;
import core.metamodel.value.numeric.ContinuousValue;
import core.metamodel.value.numeric.IntegerValue;
import core.metamodel.value.numeric.RangeSpace;
import core.metamodel.value.numeric.RangeValue;
import core.util.data.GSDataParser;
import core.util.data.GSEnumDataType;
import core.util.random.GenstarRandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NumericValueMapper<K extends IValue>
implements IAttributeMapper<K, OrderedValue> {
    private Map<IValue, OrderedValue> innerMapper = new HashMap<IValue, OrderedValue>();
    private boolean upToDate = false;
    private Map<K, OrderedValue> mapper = new HashMap<K, OrderedValue>();
    private MappedAttribute<K, OrderedValue> relatedAttribute;
    private static Attribute<ContinuousValue> CA = AttributeFactory.createNIU(ContinuousValue.class);
    private static Attribute<IntegerValue> IA = AttributeFactory.createNIU(IntegerValue.class);
    private static Attribute<RangeValue> RA = AttributeFactory.createNIU(RangeValue.class);
    private static GSDataParser GSDP = new GSDataParser();

    public void add(OrderedValue orderedValue, Number number, Number number2) {
        this.innerMapper.put(RA.getValueSpace().proposeValue(String.valueOf(number.toString()) + " : " + number2.toString()), orderedValue);
        this.upToDate = false;
    }

    public void add(OrderedValue orderedValue, Number number, RangeValue.RangeBound rangeBound) {
        String string = rangeBound.equals((Object)RangeValue.RangeBound.UPPER) ? String.valueOf(number.toString()) + " : " + ((RangeSpace)RA.getValueSpace()).getMax() : ((RangeSpace)RA.getValueSpace()).getMin() + " : " + number.toString();
        this.innerMapper.put(RA.getValueSpace().proposeValue(string), orderedValue);
        this.upToDate = false;
    }

    public void add(OrderedValue orderedValue, Number number) {
        GSEnumDataType gSEnumDataType = GSDP.getValueType(number.toString());
        switch (gSEnumDataType) {
            case Integer: {
                this.innerMapper.put(IA.getValueSpace().proposeValue(number.toString()), orderedValue);
                break;
            }
            case Continue: {
                this.innerMapper.put(CA.getValueSpace().proposeValue(number.toString()), orderedValue);
                break;
            }
            default: {
                throw new IllegalArgumentException(number + " cannot be transpose to any numerical value");
            }
        }
        this.upToDate = false;
    }

    @Override
    public boolean add(IValue iValue, OrderedValue orderedValue) {
        if (Stream.of(GSEnumDataType.Continue, GSEnumDataType.Integer, GSEnumDataType.Range).noneMatch(gSEnumDataType -> gSEnumDataType.equals((Object)orderedValue.getValueSpace().getType()))) {
            return false;
        }
        this.innerMapper.put(iValue, orderedValue);
        this.upToDate = false;
        return true;
    }

    public K getValue(OrderedValue orderedValue) {
        Optional<Map.Entry> optional;
        if (!this.upToDate) {
            this.transposeInnerMapper();
        }
        if ((optional = this.mapper.entrySet().stream().filter(entry -> ((OrderedValue)entry.getValue()).equals(orderedValue)).findFirst()).isPresent()) {
            return (K)((IValue)optional.get().getKey());
        }
        throw new NullPointerException("There is no " + orderedValue + " value within this mapped attribute (" + this + ")");
    }

    public Number getNumericValue(OrderedValue orderedValue) {
        K k = this.getValue(orderedValue);
        switch (k.getValueSpace().getType()) {
            case Integer: {
                return Integer.valueOf(k.getStringValue());
            }
            case Continue: {
                return Double.valueOf(k.getStringValue());
            }
            case Range: {
                double d = this.getStandardRange();
                RangeValue rangeValue = (RangeValue)k;
                Number number = rangeValue.getBottomBound();
                Number number2 = rangeValue.getTopBound();
                if (number.intValue() == Integer.MIN_VALUE || number.doubleValue() == Double.MIN_VALUE) {
                    number = number2.doubleValue() - d;
                }
                if (number2.intValue() == Integer.MAX_VALUE || number2.doubleValue() == Double.MAX_VALUE) {
                    number2 = number.doubleValue() + d;
                }
                return GenstarRandomUtils.rnd(number, number2);
            }
        }
        throw new IllegalArgumentException("Cannot get numerical value of " + k);
    }

    public OrderedValue getNominal(Number number) {
        Optional<IValue> optional = this.innerMapper.keySet().stream().filter(iValue -> this.validate(number, (IValue)iValue)).findFirst();
        if (optional.isPresent()) {
            return this.innerMapper.get(optional.get());
        }
        throw new NoSuchElementException("There is no relevant numeric value mapper to " + number);
    }

    public boolean contains(Number number) {
        return this.innerMapper.values().stream().anyMatch(orderedValue -> this.validate(number, (IValue)orderedValue));
    }

    @Override
    public Collection<? extends IValue> getMappedValues(IValue iValue) {
        IValue iValue2 = null;
        if (this.innerMapper.containsKey(iValue)) {
            iValue2 = this.innerMapper.get(iValue);
        } else if (this.innerMapper.values().stream().anyMatch(orderedValue -> orderedValue.getStringValue().equals(iValue.getStringValue()))) {
            iValue2 = (IValue)this.innerMapper.entrySet().stream().filter(entry -> ((OrderedValue)entry.getValue()).getStringValue().equals(iValue.getStringValue())).findFirst().get().getKey();
        }
        if (iValue2 == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(iValue2);
    }

    @Override
    public void setRelatedAttribute(MappedAttribute<K, OrderedValue> mappedAttribute) {
        this.relatedAttribute = mappedAttribute;
    }

    @Override
    public MappedAttribute<K, OrderedValue> getRelatedAttribute() {
        return this.relatedAttribute;
    }

    @Override
    public Map<Collection<K>, Collection<OrderedValue>> getRawMapper() {
        if (!this.upToDate) {
            this.transposeInnerMapper();
        }
        return this.mapper.entrySet().stream().collect(Collectors.toMap(entry -> Collections.singleton((IValue)entry.getKey()), entry -> Collections.singleton((OrderedValue)entry.getValue())));
    }

    private boolean validate(Number number, IValue iValue) {
        switch (iValue.getValueSpace().getType()) {
            case Continue: {
                return number.doubleValue() == Double.valueOf(iValue.getStringValue()).doubleValue();
            }
            case Integer: {
                return number.intValue() == Integer.valueOf(iValue.getStringValue()).intValue();
            }
            case Range: {
                RangeValue rangeValue = (RangeValue)iValue;
                return number.doubleValue() >= rangeValue.getBottomBound().doubleValue() && number.doubleValue() <= rangeValue.getTopBound().doubleValue();
            }
        }
        throw new IllegalArgumentException((Object)((Object)iValue.getValueSpace().getType()) + " is not an acceptable value type for Numeric Value Mapper");
    }

    private double getStandardRange() {
        GSDataParser gSDataParser = new GSDataParser();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (IValue object2 : this.innerMapper.keySet()) {
            switch (object2.getType()) {
                case Range: {
                    RangeValue d = (RangeValue)object2;
                    arrayList.add(d.getBottomBound().doubleValue());
                    arrayList.add(d.getTopBound().doubleValue());
                    break;
                }
                default: {
                    arrayList.add(gSDataParser.getDouble(object2.getStringValue()));
                }
            }
        }
        Collections.sort(arrayList);
        HashMap<Double, Integer> hashMap = new HashMap<Double, Integer>();
        int n2 = 1;
        while (n2 < arrayList.size()) {
            double d = (Double)arrayList.get(n2) - (Double)arrayList.get(n2 - 1);
            if (hashMap.containsKey(d)) {
                hashMap.put(d, (Integer)hashMap.get(d) + 1);
            } else {
                hashMap.put(d, 1);
            }
            ++n2;
        }
        double d = hashMap.entrySet().stream().mapToDouble(entry -> (Double)entry.getKey() * Math.pow(((Integer)entry.getValue()).intValue(), 1.5)).sum();
        double d2 = hashMap.values().stream().mapToDouble(n -> Math.pow(n.intValue(), 1.5)).sum();
        return d / d2;
    }

    private void transposeInnerMapper() {
        HashMap<IValue, OrderedValue> hashMap = new HashMap<IValue, OrderedValue>();
        GSEnumDataType gSEnumDataType = (GSEnumDataType)((Object)this.innerMapper.keySet().stream().map(IValue::getType).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Comparator.comparing(Map.Entry::getValue)).get().getKey());
        switch (gSEnumDataType) {
            case Continue: {
                for (Map.Entry<IValue, OrderedValue> entry : this.innerMapper.entrySet()) {
                    hashMap.put(CA.getValueSpace().proposeValue(entry.getKey().getStringValue()), entry.getValue());
                }
                break;
            }
            case Range: {
                for (Map.Entry<IValue, OrderedValue> entry : this.innerMapper.entrySet()) {
                    hashMap.put(RA.getValueSpace().proposeValue(entry.getKey().getStringValue()), entry.getValue());
                }
                break;
            }
            default: {
                for (Map.Entry<IValue, OrderedValue> entry : this.innerMapper.entrySet()) {
                    hashMap.put(IA.getValueSpace().proposeValue(entry.getKey().getStringValue()), entry.getValue());
                }
            }
        }
        this.mapper = hashMap;
        this.upToDate = true;
    }
}

