/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import core.configuration.jackson.attribute.RecordAttributeSerializer;
import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.mapper.value.EncodedValueMapper;
import core.metamodel.attribute.record.RecordValueSpace;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.categoric.NominalValue;
import core.metamodel.value.categoric.template.GSCategoricTemplate;

@JsonTypeName(value="RECORD ATTRIBUTE")
@JsonSerialize(using=RecordAttributeSerializer.class)
public class RecordAttribute<R extends IAttribute<? extends IValue>, P extends IAttribute<? extends IValue>>
implements IAttribute<NominalValue> {
    public static final String SELF = "RECORD ATTRIBUTE";
    public static final String PROXY_TYPE = "PROXY ATTRIBUTE TYPE";
    private final P proxy;
    @JsonProperty(value="REFERENT ATTRIBUTE")
    private final R referent;
    @JsonIgnore
    private RecordValueSpace valuesSpace = null;
    private final String name;

    public RecordAttribute(String string, P p, R r) {
        this.name = string;
        this.proxy = p;
        this.referent = r;
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.getAttributeName()) + " >> " + this.referent.getAttributeName();
    }

    public RecordValueSpace getValueSpace() {
        if (this.valuesSpace == null) {
            this.valuesSpace = new RecordValueSpace(this, new GSCategoricTemplate(), this.getAttributeName());
        }
        return this.valuesSpace;
    }

    @Override
    public void setValueSpace(IValueSpace<NominalValue> iValueSpace) {
    }

    @Override
    public EncodedValueMapper<NominalValue> getEncodedValueMapper() {
        return null;
    }

    @Override
    public void setEncodedValueMapper(EncodedValueMapper<NominalValue> encodedValueMapper) {
    }

    public R getReferentAttribute() {
        return this.referent;
    }

    public P getProxyAttribute() {
        return this.proxy;
    }
}

