/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.entity;

import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.EmergentAttribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.IEntity;
import core.metamodel.entity.tag.EntityTag;
import core.metamodel.value.IValue;
import core.metamodel.value.numeric.IntegerSpace;
import core.metamodel.value.numeric.IntegerValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ADemoEntity
implements IEntity<Attribute<? extends IValue>> {
    private String id = null;
    protected Map<Attribute<? extends IValue>, IValue> attributes;
    private String type;
    private IEntity<? extends IAttribute<? extends IValue>> parent = null;
    private Set<IEntity<? extends IAttribute<? extends IValue>>> children = null;
    private EmergentAttribute<? extends IValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> sizeAttribute;
    private Set<EntityTag> tags;
    private double weight = 1.0;

    protected ADemoEntity(Map<Attribute<? extends IValue>, IValue> map) {
        this.attributes = map;
    }

    protected ADemoEntity() {
        this.attributes = new HashMap<Attribute<? extends IValue>, IValue>();
    }

    protected ADemoEntity(ADemoEntity aDemoEntity) {
        this.attributes = new HashMap<Attribute<? extends IValue>, IValue>(aDemoEntity.getAttributeMap());
        this.type = aDemoEntity.type;
    }

    protected ADemoEntity(Collection<Attribute<IValue>> collection) {
        this.attributes = collection.stream().collect(Collectors.toMap(Function.identity(), attribute -> null));
    }

    public abstract ADemoEntity clone();

    @Override
    public final void _setEntityId(String string) throws IllegalStateException {
        if (this.id != null) {
            throw new IllegalArgumentException("cannot change the identifier of an agent; this agent already had id " + this.id + " but we were asked " + "to change it for " + string);
        }
        this.id = string;
    }

    @Override
    public final String getEntityId() throws IllegalStateException {
        if (this.id == null) {
            throw new IllegalStateException("no id is defined yet for agent " + this.toString());
        }
        return this.id;
    }

    @Override
    public final boolean _hasEntityId() {
        return this.id != null;
    }

    public void setAttributeValue(Attribute<? extends IValue> attribute, IValue iValue) {
        this.attributes.put(attribute, iValue);
    }

    public void setAttributeValue(String string, IValue iValue) {
        if (this.attributes.isEmpty()) {
            throw new IllegalArgumentException("there is no attribute defined for this entity");
        }
        Optional<Attribute> optional = this.attributes.keySet().stream().filter(attribute -> attribute.getAttributeName().equals(string)).findAny();
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("there is no attribute named " + string + " defined for this entity");
        }
        this.attributes.put(optional.get(), iValue);
    }

    @Override
    public boolean hasAttribute(Attribute<? extends IValue> attribute) {
        return this.attributes.containsKey(attribute);
    }

    @Override
    public IValue getValueForAttribute(Attribute<? extends IValue> attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public IValue getValueForAttribute(String string) {
        for (Map.Entry<Attribute<? extends IValue>, IValue> entry : this.attributes.entrySet()) {
            if (!entry.getKey().getAttributeName().equals(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Map<Attribute<? extends IValue>, IValue> getAttributeMap() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Collection<Attribute<? extends IValue>> getAttributes() {
        return this.attributes.keySet();
    }

    @Override
    public Collection<IValue> getValues() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public String toString() {
        return "Entity [" + this.id + "] " + this.attributes.entrySet().stream().map(entry -> String.valueOf(((Attribute)entry.getKey()).getAttributeName()) + ":" + ((IValue)entry.getValue()).getStringValue()).collect(Collectors.joining(",\t"));
    }

    @Override
    public final boolean hasEntityType() {
        return this.type != null;
    }

    @Override
    public final String getEntityType() {
        return this.type;
    }

    @Override
    public void setEntityType(String string) {
        this.type = string;
    }

    @Override
    public final boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public final IEntity<? extends IAttribute<? extends IValue>> getParent() {
        return this.parent;
    }

    @Override
    public final void setParent(IEntity<? extends IAttribute<? extends IValue>> iEntity) {
        this.parent = iEntity;
    }

    @Override
    public final boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public final Set<IEntity<? extends IAttribute<? extends IValue>>> getChildren() {
        if (this.children == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.children);
    }

    @Override
    public final void addChild(IEntity<? extends IAttribute<? extends IValue>> iEntity) {
        if (this.children == null) {
            this.children = new HashSet<IEntity<? extends IAttribute<? extends IValue>>>();
        }
        this.children.add(iEntity);
    }

    @Override
    public final void addChildren(Collection<IEntity<? extends IAttribute<? extends IValue>>> collection) {
        if (this.children == null) {
            this.children = new HashSet<IEntity<? extends IAttribute<? extends IValue>>>();
        }
        this.children.addAll(collection);
    }

    @Override
    public IValue getCountChildren() {
        return this.sizeAttribute == null ? new IntegerSpace(null).proposeValue(Integer.toString(this.getChildren().size())) : this.sizeAttribute.getEmergentValue(this);
    }

    public void setCountAttribute(EmergentAttribute<IntegerValue, Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> emergentAttribute) {
        this.sizeAttribute = emergentAttribute;
    }

    @Override
    public boolean hasTags(EntityTag ... entityTagArray) {
        List<EntityTag> list = Arrays.asList(entityTagArray);
        return this.tags.stream().allMatch(list::contains);
    }

    @Override
    public Collection<EntityTag> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double d) {
        this.weight = d;
    }
}

