/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.entity.comparator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import core.configuration.jackson.entity.EntityComparatorSerializer;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.IEntity;
import core.metamodel.entity.comparator.IDComparator;
import core.metamodel.entity.comparator.function.IComparatorFunction;
import core.metamodel.value.IValue;
import core.util.data.GSEnumDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonSerialize(using=EntityComparatorSerializer.class)
public class ImplicitEntityComparator
implements Comparator<IEntity<? extends IAttribute<? extends IValue>>> {
    public static final String ATTRIBUTES_REF = "LISTED ATTRIBUTES";
    public static final String COMP_FUNCTIONS = "CUSTOM COMPARATOR FUNCTIONS";
    @JsonIgnore
    private final IDComparator defaultComparator;
    private final EnumMap<GSEnumDataType, IComparatorFunction<? extends IValue>> functions;
    private final List<IAttribute<? extends IValue>> attributes;
    private final Map<String, Integer> reversMap;

    public ImplicitEntityComparator(List<IAttribute<? extends IValue>> list) {
        this.attributes = list;
        this.reversMap = this.attributes.isEmpty() ? new HashMap<String, Integer>() : this.attributes.stream().collect(Collectors.toMap(IAttribute::getAttributeName, iAttribute -> 1));
        this.defaultComparator = IDComparator.getInstance();
        this.functions = new EnumMap(Stream.of(GSEnumDataType.values()).collect(Collectors.toMap(Function.identity(), IComparatorFunction::getDefaultFunction)));
    }

    @SafeVarargs
    public ImplicitEntityComparator(IAttribute<? extends IValue> ... iAttributeArray) {
        this(new ArrayList<IAttribute<? extends IValue>>(Arrays.asList(iAttributeArray)));
    }

    @Override
    public int compare(IEntity<? extends IAttribute<? extends IValue>> iEntity, IEntity<? extends IAttribute<? extends IValue>> iEntity2) {
        int n;
        int n2 = 0;
        do {
            IAttribute<? extends IValue> iAttribute = this.attributes.get(n2++);
            n = this.compare(iEntity, iEntity2, iAttribute) * this.reversMap.get(iAttribute.getAttributeName());
        } while (n2 < this.attributes.size());
        return n == 0 ? this.defaultComparator.compare(iEntity, iEntity2) : n;
    }

    public List<IAttribute<? extends IValue>> getAttributes() {
        return this.attributes;
    }

    public ImplicitEntityComparator addAttributes(IAttribute<? extends IValue> ... iAttributeArray) {
        List<IAttribute<? extends IValue>> list = Arrays.asList(iAttributeArray);
        this.attributes.addAll(list);
        list.forEach(iAttribute -> {
            Integer n = this.reversMap.put(iAttribute.getAttributeName(), 1);
        });
        return this;
    }

    public ImplicitEntityComparator setAttribute(IAttribute<? extends IValue> iAttribute, boolean bl) {
        this.attributes.add(iAttribute);
        this.reversMap.put(iAttribute.getAttributeName(), bl ? -1 : 1);
        return this;
    }

    public boolean isReverseAttribute(IAttribute<? extends IValue> iAttribute) {
        if (!this.reversMap.containsKey(iAttribute.getAttributeName())) {
            throw new IllegalArgumentException("This comparator have no reference to the attribute " + iAttribute.getAttributeName());
        }
        return this.reversMap.get(iAttribute.getAttributeName()) == -1;
    }

    public IComparatorFunction<? extends IValue> getComparatorFunction(GSEnumDataType gSEnumDataType) {
        return this.functions.get((Object)gSEnumDataType);
    }

    public ImplicitEntityComparator setComparatorFunction(IComparatorFunction<? extends IValue> iComparatorFunction) {
        this.functions.put(iComparatorFunction.getType(), iComparatorFunction);
        return this;
    }

    private int compare(IEntity<? extends IAttribute<? extends IValue>> iEntity, IEntity<? extends IAttribute<? extends IValue>> iEntity2, IAttribute<? extends IValue> iAttribute) {
        GSEnumDataType gSEnumDataType = iAttribute.getValueSpace().getType();
        if (!this.functions.containsKey((Object)gSEnumDataType)) {
            throw new IllegalArgumentException("Unknown attribute value type: " + (Object)((Object)gSEnumDataType));
        }
        return this.functions.get((Object)gSEnumDataType).compare(iEntity.getValueForAttribute(iAttribute.getAttributeName()), iEntity2.getValueForAttribute(iAttribute.getAttributeName()), iAttribute.getValueSpace().getEmptyValue());
    }
}

