/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.entity.matcher;

import com.fasterxml.jackson.annotation.JsonTypeName;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.IEntity;
import core.metamodel.entity.matcher.IGSEntityMatcher;
import core.metamodel.entity.matcher.MatchType;
import core.metamodel.value.IValue;
import core.util.GSDisplayUtil;
import core.util.exception.GenstarException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonTypeName(value="VECTOR VALUE MATCHER")
public class AttributeVectorMatcher
implements IGSEntityMatcher<IValue> {
    public static final String SELF = "VECTOR VALUE MATCHER";
    public static final String ATT_SEPRATOR = " : ";
    public static final CharSequence VAL_SEPRATOR = ",";
    Map<IAttribute<? extends IValue>, Set<IValue>> vector;

    public AttributeVectorMatcher() {
        this.vector = new HashMap<IAttribute<? extends IValue>, Set<IValue>>();
    }

    public AttributeVectorMatcher(IEntity<Attribute<? extends IValue>> iEntity) {
        this.vector = iEntity.getAttributeMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashSet<IValue>(Arrays.asList((IValue)entry.getValue()))));
    }

    public AttributeVectorMatcher(Map<IAttribute<? extends IValue>, Set<IValue>> map) {
        this.vector = map;
    }

    public AttributeVectorMatcher(IValue ... iValueArray) {
        this();
        this.addMatchToVector(iValueArray);
    }

    @Override
    public boolean valueMatch(IValue iValue) {
        return this.getVector().contains(iValue);
    }

    @Override
    public boolean valuesMatch(Collection<? extends IValue> collection) {
        return this.getVector().containsAll(collection);
    }

    @Override
    public boolean entityMatch(IEntity<? extends IAttribute<? extends IValue>> iEntity, MatchType matchType) {
        return switch (matchType) {
            case MatchType.ALL -> this.valuesMatch((Collection<? extends IValue>)iEntity.getValues());
            case MatchType.ANY -> iEntity.getValues().stream().anyMatch(this::valueMatch);
            case MatchType.NONE -> iEntity.getValues().stream().noneMatch(this::valueMatch);
            default -> throw new GenstarException();
        };
    }

    @Override
    public int getHammingDistance(IEntity<? extends IAttribute<? extends IValue>> iEntity) {
        return (int)iEntity.getAttributes().stream().filter(iAttribute -> this.vector.containsKey(iAttribute) && this.vector.get(iAttribute).contains(iEntity.getValueForAttribute(iAttribute.getAttributeName()))).count();
    }

    public void addMatchToVector(IValue ... iValueArray) {
        this.vector.putAll(Stream.of(iValueArray).collect(Collectors.groupingBy(iValue -> iValue.getValueSpace().getAttribute(), Collectors.toSet())));
    }

    public String toString() {
        return GSDisplayUtil.prettyPrint(this.vector.values(), ";");
    }

    @Override
    public void setVector(Collection<IValue> collection) {
        this.addMatchToVector(collection.toArray(new IValue[collection.size()]));
    }

    @Override
    public Collection<IValue> getVector() {
        return this.vector.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Map<IAttribute<? extends IValue>, Set<IValue>> getMapVector() {
        return Collections.unmodifiableMap(this.vector);
    }
}

