/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.io;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import core.configuration.jackson.GSSurveyWrapperSerializer;
import core.metamodel.io.GSSurveyType;
import java.nio.file.Path;

@JsonSerialize(using=GSSurveyWrapperSerializer.class)
public class GSSurveyWrapper {
    public static final String RELATIVE_PATH = "RELATIVE PATH";
    public static final String SURVEY_TYPE = "SURVEY TYPE";
    public static final String SHEET_NB = "SHEET NB";
    public static final String CSV_SEPARATOR = "SEPARATOR";
    public static final String FIRST_ROW_INDEX = "FRI";
    public static final String FIRST_COLUMN_INDEX = "FCI";
    public static final String STORE_IN_MEMORY = "STORE DATA";
    private Path relativePath;
    private GSSurveyType surveyType;
    private int sheetNb = 0;
    private char csvSeparator = (char)44;
    private int firstRowIndex = 1;
    private int firstColumnIndex = 1;
    private boolean storedInMemory = true;

    protected GSSurveyWrapper() {
    }

    public GSSurveyWrapper(Path path, GSSurveyType gSSurveyType) {
        this.setRelativePath(path);
        this.setSurveyType(gSSurveyType);
    }

    public GSSurveyWrapper(Path path, GSSurveyType gSSurveyType, int n, int n2, int n3) {
        this(path, true, gSSurveyType, n, n2, n3);
    }

    public GSSurveyWrapper(Path path, boolean bl, GSSurveyType gSSurveyType, int n, int n2, int n3) {
        this(path, gSSurveyType);
        this.setSheetNumber(n);
        this.setStoredInMemory(bl);
        this.setFirstRowIndex(n2);
        this.setFirstColumnIndex(n3);
    }

    public GSSurveyWrapper(Path path, GSSurveyType gSSurveyType, char c, int n, int n2) {
        this(path, true, gSSurveyType, c, n, n2);
    }

    public GSSurveyWrapper(Path path, boolean bl, GSSurveyType gSSurveyType, char c, int n, int n2) {
        this(path, gSSurveyType);
        this.setStoredInMemory(bl);
        this.setCsvSeparator(c);
        this.setStoredInMemory(bl);
        this.setFirstColumnIndex(n2);
        this.setFirstRowIndex(n);
    }

    @JsonProperty(value="RELATIVE PATH")
    public Path getRelativePath() {
        return this.relativePath;
    }

    @JsonProperty(value="RELATIVE PATH")
    public void setRelativePath(Path path) {
        this.relativePath = path;
    }

    @JsonProperty(value="SURVEY TYPE")
    public GSSurveyType getSurveyType() {
        return this.surveyType;
    }

    @JsonProperty(value="SURVEY TYPE")
    public void setSurveyType(GSSurveyType gSSurveyType) {
        this.surveyType = gSSurveyType;
    }

    @JsonProperty(value="SHEET NB")
    public int getSheetNumber() {
        return this.sheetNb;
    }

    @JsonProperty(value="SHEET NB")
    public void setSheetNumber(int n) {
        this.sheetNb = n;
    }

    @JsonProperty(value="SEPARATOR")
    public char getCsvSeparator() {
        return this.csvSeparator;
    }

    @JsonProperty(value="SEPARATOR")
    public void setCsvSeparator(char c) {
        this.csvSeparator = c;
    }

    @JsonProperty(value="FRI")
    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    @JsonProperty(value="FRI")
    public void setFirstRowIndex(int n) {
        this.firstRowIndex = n;
    }

    @JsonProperty(value="FCI")
    public int getFirstColumnIndex() {
        return this.firstColumnIndex;
    }

    @JsonProperty(value="FCI")
    public void setFirstColumnIndex(int n) {
        this.firstColumnIndex = n;
    }

    @JsonProperty(value="STORE DATA")
    public boolean getStoredInMemory() {
        return this.storedInMemory;
    }

    @JsonProperty(value="STORE DATA")
    public void setStoredInMemory(boolean bl) {
        this.storedInMemory = bl;
    }

    public String toString() {
        return "wrapper to survey " + this.relativePath;
    }
}

