/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import core.metamodel.attribute.IAttribute;
import core.metamodel.value.IValue;
import core.metamodel.value.binary.BinarySpace;
import core.metamodel.value.categoric.NominalSpace;
import core.metamodel.value.categoric.OrderedSpace;
import core.metamodel.value.numeric.ContinuousSpace;
import core.metamodel.value.numeric.IntegerSpace;
import core.metamodel.value.numeric.RangeSpace;
import core.util.data.GSEnumDataType;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@JsonSubTypes(value={@JsonSubTypes.Type(value=BinarySpace.class), @JsonSubTypes.Type(value=NominalSpace.class), @JsonSubTypes.Type(value=OrderedSpace.class), @JsonSubTypes.Type(value=ContinuousSpace.class), @JsonSubTypes.Type(value=IntegerSpace.class), @JsonSubTypes.Type(value=RangeSpace.class)})
@JsonPropertyOrder(value={"TYPE", "VALUES"})
public interface IValueSpace<V extends IValue> {
    public static final String REF_ATT = "REFERENCE ATTRIBUTE";
    public static final String EMPTY_LABEL = "EMPTY VALUE";
    public static final String TYPE_LABEL = "TYPE";
    public static final String VALUES_LABEL = "VALUES";

    public V proposeValue(String var1);

    public V getInstanceValue(String var1);

    public V addValue(String var1) throws IllegalArgumentException;

    public V getValue(String var1) throws NullPointerException;

    @JsonProperty(value="VALUES")
    public Set<V> getValues();

    public boolean contains(IValue var1);

    public boolean contains(String var1);

    public boolean containsAllLabels(Collection<String> var1);

    @JsonProperty(value="EMPTY VALUE")
    public V getEmptyValue();

    public void setEmptyValue(String var1);

    public void addExceludedValue(String var1);

    @JsonProperty(value="TYPE")
    public GSEnumDataType getType();

    @JsonIgnore
    public Class<V> getTypeClass();

    public boolean isValidCandidate(String var1);

    @JsonProperty(value="REFERENCE ATTRIBUTE")
    @JsonBackReference(value="REFERENCE ATTRIBUTE")
    public IAttribute<V> getAttribute();

    public IValueSpace<V> clone(IAttribute<V> var1);

    default public String toPrettyString() {
        return "[" + this.getType().toString() + "]";
    }

    @JsonIgnore
    default public int getHashCode() {
        int n = 1;
        n = 31 * n + (this.getAttribute() == null ? 0 : this.getAttribute().getAttributeName().hashCode());
        return 31 * n + this.getType().hashCode();
    }

    default public boolean isEqual(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IValueSpace iValueSpace = (IValueSpace)object;
        if (this.getAttribute() == null ? iValueSpace.getAttribute() != null : !this.getAttribute().getAttributeName().equals(iValueSpace.getAttribute().getAttributeName())) {
            return false;
        }
        return Objects.equals((Object)this.getType(), (Object)iValueSpace.getType());
    }
}

