/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.binary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.binary.BinarySpace;
import core.util.data.GSEnumDataType;

public class BooleanValue
implements IValue {
    private Boolean value;
    private BinarySpace bs;

    protected BooleanValue(BinarySpace binarySpace, Boolean bl) {
        this.bs = binarySpace;
        this.value = bl;
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Boolean;
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.value);
    }

    @JsonIgnore
    public Boolean getActualValue() {
        return this.value;
    }

    public IValueSpace<BooleanValue> getValueSpace() {
        return this.bs;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEquals(object);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public <T> void setActualValue(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("cannot change the actual value of a Boolean attribute");
    }
}

