/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.numeric;

import com.fasterxml.jackson.annotation.JsonProperty;
import core.metamodel.attribute.IAttribute;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.numeric.ContinuousValue;
import core.util.data.GSDataParser;
import core.util.data.GSEnumDataType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class ContinuousSpace
implements IValueSpace<ContinuousValue> {
    private static GSDataParser gsdp = new GSDataParser();
    private ContinuousValue emptyValue;
    private final TreeMap<Double, ContinuousValue> values;
    private final Set<String> excludedValues;
    private double min;
    private double max;
    private final IAttribute<ContinuousValue> attribute;

    public ContinuousSpace(IAttribute<ContinuousValue> iAttribute) {
        this(iAttribute, -1.7976931348623157E308, (Double)Double.MAX_VALUE);
    }

    public ContinuousSpace(IAttribute<ContinuousValue> iAttribute, Double d, Double d2) {
        this.attribute = iAttribute;
        this.min = d;
        this.max = d2;
        this.emptyValue = new ContinuousValue(this, Double.NaN);
        this.values = new TreeMap();
        this.excludedValues = new HashSet<String>();
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Continue;
    }

    @Override
    public Class<ContinuousValue> getTypeClass() {
        return ContinuousValue.class;
    }

    @Override
    public ContinuousValue getInstanceValue(String string) {
        double d = gsdp.getDouble(string);
        if (d < this.min || d > this.max) {
            throw new IllegalArgumentException("Proposed value " + d + " is " + (d < this.min ? "below" : "beyond") + " given bound (" + (d < this.min ? this.min : this.max) + ")");
        }
        return new ContinuousValue(this, d);
    }

    @Override
    public ContinuousValue proposeValue(String string) {
        return new ContinuousValue(this, gsdp.getDouble(string));
    }

    @Override
    public ContinuousValue addValue(String string) {
        if (this.excludedValues.contains(string)) {
            return this.getEmptyValue();
        }
        ContinuousValue continuousValue = this.getValue(string);
        if (string == null) {
            continuousValue = this.getInstanceValue(string);
            this.values.put(continuousValue.getActualValue(), continuousValue);
        }
        return continuousValue;
    }

    @Override
    public ContinuousValue getValue(String string) throws NullPointerException {
        return this.values.get(gsdp.getDouble(string));
    }

    @Override
    public Set<ContinuousValue> getValues() {
        return new HashSet<ContinuousValue>(this.values.values());
    }

    @Override
    public boolean contains(IValue iValue) {
        if (!iValue.getClass().equals(ContinuousValue.class)) {
            return false;
        }
        return this.values.containsValue(iValue);
    }

    @Override
    public ContinuousValue getEmptyValue() {
        return this.emptyValue;
    }

    @Override
    public void setEmptyValue(String string) {
        try {
            this.emptyValue = this.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.emptyValue = new ContinuousValue(this, gsdp.getDouble(string));
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void addExceludedValue(String string) {
        this.excludedValues.add(string);
    }

    @Override
    public boolean isValidCandidate(String string) {
        return gsdp.getValueType(string).isNumericValue() && gsdp.getDouble(string) >= this.min && gsdp.getDouble(string) <= this.max;
    }

    @Override
    public IAttribute<ContinuousValue> getAttribute() {
        return this.attribute;
    }

    @JsonProperty(value="max")
    public double getMax() {
        return this.max;
    }

    public void setMax(double d) {
        this.max = d;
    }

    @JsonProperty(value="min")
    public double getMin() {
        return this.min;
    }

    public void setMin(double d) {
        this.min = d;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEqual(object);
    }

    public String toString() {
        return this.toPrettyString();
    }

    @Override
    public boolean contains(String string) {
        return this.values.values().stream().anyMatch(continuousValue -> continuousValue.getStringValue().equals(string));
    }

    @Override
    public boolean containsAllLabels(Collection<String> collection) {
        return this.values.values().stream().allMatch(continuousValue -> collection.contains(continuousValue.getStringValue()));
    }

    @Override
    public IValueSpace<ContinuousValue> clone(IAttribute<ContinuousValue> iAttribute) {
        return new ContinuousSpace(iAttribute, this.getMin(), this.getMax());
    }
}

