/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.numeric;

import com.fasterxml.jackson.annotation.JsonProperty;
import core.metamodel.attribute.IAttribute;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.numeric.IntegerValue;
import core.util.data.GSDataParser;
import core.util.data.GSEnumDataType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class IntegerSpace
implements IValueSpace<IntegerValue> {
    private static GSDataParser gsdp = new GSDataParser();
    private IntegerValue emptyValue;
    private final TreeMap<Integer, IntegerValue> values = new TreeMap();
    private final Set<String> excludedValues = new HashSet<String>();
    private int min;
    private int max;
    private final IAttribute<IntegerValue> attribute;

    public IntegerSpace(IAttribute<IntegerValue> iAttribute) {
        this(iAttribute, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerSpace(IAttribute<IntegerValue> iAttribute, Integer n, Integer n2) {
        this.emptyValue = new IntegerValue(this);
        this.attribute = iAttribute;
        this.min = n;
        this.max = n2;
    }

    @Override
    public IntegerValue getInstanceValue(String string) {
        int n = gsdp.parseNumbers(string).intValue();
        if (n < this.min || n > this.max) {
            throw new IllegalArgumentException("Proposed value " + string + " is " + (n < this.min ? "below" : "beyond") + " given bound (" + (n < this.min ? this.min : this.max) + ")");
        }
        return new IntegerValue(this, n);
    }

    @Override
    public IntegerValue proposeValue(String string) {
        return new IntegerValue(this, gsdp.parseNumbers(string).intValue());
    }

    @Override
    public IntegerValue addValue(String string) {
        if (this.excludedValues.contains(string)) {
            return this.getEmptyValue();
        }
        IntegerValue integerValue = this.getValue(string);
        if (integerValue == null) {
            integerValue = this.getInstanceValue(string);
            this.values.put(integerValue.getActualValue(), integerValue);
        }
        return integerValue;
    }

    @Override
    public IntegerValue getValue(String string) throws NullPointerException {
        return this.values.get(gsdp.parseNumbers(string).intValue());
    }

    @Override
    public Set<IntegerValue> getValues() {
        return new HashSet<IntegerValue>(this.values.values());
    }

    @Override
    public boolean contains(IValue iValue) {
        if (!iValue.getClass().equals(IntegerValue.class)) {
            return false;
        }
        return this.values.containsValue(iValue);
    }

    @Override
    public IntegerValue getEmptyValue() {
        return this.emptyValue;
    }

    @Override
    public void setEmptyValue(String string) {
        try {
            this.emptyValue = this.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            try {
                this.emptyValue = new IntegerValue(this, gsdp.getDouble(string).intValue());
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void addExceludedValue(String string) {
        this.excludedValues.add(string);
    }

    @Override
    public boolean isValidCandidate(String string) {
        return gsdp.getValueType(string).isNumericValue() && gsdp.parseNumbers(string).intValue() >= this.min && gsdp.parseNumbers(string).intValue() <= this.max;
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Integer;
    }

    @Override
    public Class<IntegerValue> getTypeClass() {
        return IntegerValue.class;
    }

    @Override
    public IAttribute<IntegerValue> getAttribute() {
        return this.attribute;
    }

    @JsonProperty(value="max")
    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    @JsonProperty(value="min")
    public int getMin() {
        return this.min;
    }

    public void setMin(int n) {
        this.min = n;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEqual(object);
    }

    public String toString() {
        return this.toPrettyString();
    }

    @Override
    public boolean contains(String string) {
        return this.values.values().stream().anyMatch(integerValue -> integerValue.getStringValue().equals(string));
    }

    @Override
    public boolean containsAllLabels(Collection<String> collection) {
        return this.values.values().stream().allMatch(integerValue -> collection.contains(integerValue.getStringValue()));
    }

    @Override
    public IValueSpace<IntegerValue> clone(IAttribute<IntegerValue> iAttribute) {
        return new IntegerSpace(iAttribute, this.getMin(), this.getMax());
    }
}

