/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.numeric;

import core.metamodel.attribute.IAttribute;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.numeric.RangeValue;
import core.metamodel.value.numeric.template.GSRangeTemplate;
import core.util.data.GSDataParser;
import core.util.data.GSEnumDataType;
import core.util.exception.GSIllegalRangedData;
import core.util.random.GenstarRandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RangeSpace
implements IValueSpace<RangeValue> {
    private static GSDataParser gsdp = new GSDataParser();
    private IAttribute<RangeValue> attribute;
    private GSRangeTemplate rt;
    private Number min;
    private Number max;
    private List<RangeValue> values;
    private RangeValue emptyValue;
    private Set<String> excludedValues;
    private Map<String, RangeValue> textual2valueCached = new HashMap<String, RangeValue>();

    public RangeSpace(IAttribute<RangeValue> iAttribute, GSRangeTemplate gSRangeTemplate) {
        this(iAttribute, gSRangeTemplate, gSRangeTemplate.getTheoreticalMin(), gSRangeTemplate.getTheoreticalMax());
    }

    public RangeSpace(IAttribute<RangeValue> iAttribute, List<String> list, Number number, Number number2) throws GSIllegalRangedData {
        this(iAttribute, gsdp.getRangeTemplate(list, "#", GSDataParser.NumMatcher.getDefault()), number, number2);
    }

    public RangeSpace(IAttribute<RangeValue> iAttribute, GSRangeTemplate gSRangeTemplate, Number number, Number number2) {
        this.attribute = iAttribute;
        this.rt = gSRangeTemplate;
        this.min = number;
        this.max = number2;
        this.values = new ArrayList<RangeValue>();
        this.excludedValues = new HashSet<String>();
        this.emptyValue = new RangeValue(this, (Number)Double.NaN, Double.NaN);
    }

    public GSRangeTemplate getRangeTemplate() {
        return this.rt;
    }

    @Override
    public RangeValue getInstanceValue(String string) {
        if (!this.rt.isValideRangeCandidate(string)) {
            throw new IllegalArgumentException("The string value " + string + " does not fit defined " + "range " + this.rt);
        }
        List<Number> list = null;
        list = gsdp.getNumbers(string, this.rt.getNumberMatcher());
        if (list.stream().anyMatch(number -> number.doubleValue() < this.min.doubleValue()) || list.stream().anyMatch(number -> number.doubleValue() > this.max.doubleValue())) {
            throw new IllegalArgumentException("Proposed values " + string + " are " + (list.stream().anyMatch(number -> number.doubleValue() < this.min.doubleValue()) ? "below" : "beyond") + " given bound (" + (list.stream().anyMatch(number -> number.doubleValue() < this.min.doubleValue()) ? (Number)this.min : (Number)this.max) + ")");
        }
        return list.size() == 1 ? (this.rt.getBottomTemplate(list.get(0)).equals(string) ? new RangeValue(this, list.get(0), RangeValue.RangeBound.LOWER) : new RangeValue(this, list.get(0), RangeValue.RangeBound.UPPER)) : new RangeValue(this, list.get(0), list.get(1));
    }

    @Override
    public RangeValue proposeValue(String string) {
        return this.getInstanceValue(string);
    }

    @Override
    public RangeValue addValue(String string) throws IllegalArgumentException {
        if (this.excludedValues.contains(string)) {
            return this.getEmptyValue();
        }
        RangeValue rangeValue = null;
        try {
            rangeValue = this.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            rangeValue = this.getInstanceValue(string);
            this.values.add(rangeValue);
            this.textual2valueCached.put(rangeValue.getStringValue(), rangeValue);
        }
        return rangeValue;
    }

    @Override
    public RangeValue getValue(String string) throws NullPointerException {
        RangeValue rangeValue2 = this.textual2valueCached.get(string);
        if (rangeValue2 != null) {
            return rangeValue2;
        }
        Optional<RangeValue> optional = this.values.stream().filter(rangeValue -> rangeValue.getStringValue().equals(string)).findAny();
        if (optional.isPresent()) {
            rangeValue2 = optional.get();
            this.textual2valueCached.put(string, rangeValue2);
            return rangeValue2;
        }
        optional = this.values.stream().filter(rangeValue -> rangeValue.getActualValue().toString().equals(string)).findAny();
        if (optional.isPresent()) {
            rangeValue2 = optional.get();
            this.textual2valueCached.put(string, rangeValue2);
            return rangeValue2;
        }
        throw new NullPointerException("The string value \"" + string + "\" is not contained " + "in the value space " + this.toPrettyString());
    }

    @Override
    public Set<RangeValue> getValues() {
        return new HashSet<RangeValue>(this.values);
    }

    @Override
    public boolean contains(IValue iValue) {
        if (!iValue.getClass().equals(RangeValue.class)) {
            return false;
        }
        return this.values.contains(iValue);
    }

    @Override
    public boolean contains(String string) {
        return this.textual2valueCached.get(string) != null;
    }

    @Override
    public boolean containsAllLabels(Collection<String> collection) {
        return this.values.stream().allMatch(rangeValue -> collection.contains(rangeValue.getStringValue()));
    }

    @Override
    public RangeValue getEmptyValue() {
        return this.emptyValue;
    }

    @Override
    public void setEmptyValue(String string) {
        if (this.rt.isValideRangeCandidate(string)) {
            try {
                this.getValue(string);
            }
            catch (Exception exception) {
                List<Double> list = null;
                try {
                    list = gsdp.getRangedDoubleData(string, this.rt.getNumberMatcher());
                }
                catch (GSIllegalRangedData gSIllegalRangedData) {
                    throw new IllegalArgumentException("SHOULD NOT HAPPEN");
                }
                this.emptyValue = list.size() == 1 ? (this.rt.getBottomTemplate(list.get(0)).equals(string) ? new RangeValue(this, (Number)list.get(0), RangeValue.RangeBound.LOWER) : new RangeValue(this, (Number)list.get(0), RangeValue.RangeBound.UPPER)) : new RangeValue(this, (Number)list.get(0), list.get(1));
            }
        }
    }

    @Override
    public void addExceludedValue(String string) {
        this.excludedValues.add(string);
    }

    @Override
    public boolean isValidCandidate(String string) {
        return this.rt.isValideRangeCandidate(string);
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Range;
    }

    @Override
    public IAttribute<RangeValue> getAttribute() {
        return this.attribute;
    }

    @Override
    public Class<RangeValue> getTypeClass() {
        return RangeValue.class;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }

    public List<Number> getNumbers() {
        return this.values.stream().flatMap(rangeValue -> Stream.of(rangeValue.getBottomBound(), rangeValue.getTopBound())).toList();
    }

    public Double getUsualRange() {
        Set set = this.values.stream().map(rangeValue -> rangeValue.getTopBound().doubleValue() - rangeValue.getBottomBound().doubleValue()).collect(Collectors.toSet());
        if (set.size() > 1) {
            return Double.NaN;
        }
        return (Double)set.iterator().next();
    }

    public void consolidateRanges() {
        Map map = this.getNumbers().stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Double d = this.getUsualRange();
        for (Number number2 : map.keySet().stream().filter(number -> (Long)map.get(number) > 1L).toList()) {
            RangeValue rangeValue2;
            List<RangeValue> list = this.values.stream().filter(rangeValue -> rangeValue.getBottomBound().doubleValue() == number2.doubleValue() || rangeValue.getTopBound().doubleValue() == number2.doubleValue()).toList();
            double d2 = 1.0;
            if (d == Double.NaN) {
                rangeValue2 = list.stream().filter(rangeValue -> rangeValue.getTopBound().doubleValue() - rangeValue.getBottomBound().doubleValue() > d).findFirst().get();
                d2 = rangeValue2.getTopBound().doubleValue() - rangeValue2.getBottomBound().doubleValue() - d;
            } else {
                rangeValue2 = GenstarRandomUtils.oneOf(list);
            }
            if (rangeValue2.getBottomBound().doubleValue() == number2.doubleValue()) {
                rangeValue2.setBottomBound(rangeValue2.getBottomBound().doubleValue() + d2);
                continue;
            }
            rangeValue2.setTopBound(rangeValue2.getTopBound().doubleValue() - d2);
        }
    }

    public Number getRandom(RangeValue rangeValue) {
        double d = this.getStandardRange();
        Number number = rangeValue.getBottomBound();
        Number number2 = rangeValue.getTopBound();
        if (number.intValue() == Integer.MIN_VALUE) {
            number = number2.intValue() - Math.round(Math.round(d));
        } else if (number.doubleValue() == Double.MIN_VALUE) {
            number = number2.doubleValue() - d;
        } else if (number2.intValue() == Integer.MAX_VALUE) {
            number2 = number.intValue() + Math.round(Math.round(d));
        } else if (number2.doubleValue() == Double.MAX_VALUE) {
            number2 = number.doubleValue() + d;
        }
        return GenstarRandomUtils.rnd(number, number2);
    }

    private double getStandardRange() {
        List<Double> list = this.values.stream().flatMap(rangeValue -> Stream.of(rangeValue.getBottomBound(), rangeValue.getTopBound())).mapToDouble(number -> number.doubleValue()).boxed().toList();
        Collections.sort(list);
        HashMap<Double, Integer> hashMap = new HashMap<Double, Integer>();
        int n2 = 1;
        while (n2 < list.size()) {
            double d = list.get(n2) - list.get(n2 - 1);
            if (hashMap.containsKey(d)) {
                hashMap.put(d, (Integer)hashMap.get(d) + 1);
            } else {
                hashMap.put(d, 1);
            }
            ++n2;
        }
        double d = hashMap.entrySet().stream().mapToDouble(entry -> (Double)entry.getKey() * Math.pow(((Integer)entry.getValue()).intValue(), 1.5)).sum();
        double d2 = hashMap.values().stream().mapToDouble(n -> Math.pow(n.intValue(), 1.5)).sum();
        return d / d2;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEqual(object);
    }

    public String toString() {
        return this.toPrettyString();
    }

    @Override
    public String toPrettyString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(this.getType().toString()).append("] ");
        stringBuffer.append(this.values.stream().map(rangeValue -> String.valueOf(rangeValue.getActualValue() == null ? "" : String.valueOf(rangeValue.getActualValue().toString()) + ":") + rangeValue.getStringValue()).collect(Collectors.joining(",")));
        return stringBuffer.toString();
    }

    @Override
    public IValueSpace<RangeValue> clone(IAttribute<RangeValue> iAttribute) {
        return new RangeSpace(iAttribute, this.getRangeTemplate(), this.getMin(), this.getMax());
    }
}

