/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.numeric;

import com.fasterxml.jackson.annotation.JsonIgnore;
import core.metamodel.value.IValue;
import core.metamodel.value.numeric.RangeSpace;
import core.util.data.GSEnumDataType;

public class RangeValue
implements IValue {
    private Number bottomBound;
    private Number topBound;
    private final RangeSpace rs;
    private String stringValueCached = null;
    private Object actualValue = null;

    protected RangeValue(RangeSpace rangeSpace, Number number, RangeBound rangeBound) {
        this.rs = rangeSpace;
        switch (rangeBound) {
            case UPPER: {
                this.bottomBound = number;
                this.topBound = rangeSpace.getMax();
                break;
            }
            case LOWER: {
                this.topBound = number;
                this.bottomBound = rangeSpace.getMin();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected RangeValue(RangeSpace rangeSpace, Number number, Number number2) {
        this.bottomBound = number;
        this.topBound = number2;
        this.rs = rangeSpace;
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Range;
    }

    protected String computeStringValue() {
        if (this.topBound.equals(this.rs.getMax())) {
            return this.rs.getRangeTemplate().getTopTemplate(this.bottomBound);
        }
        if (this.bottomBound.equals(this.rs.getMin())) {
            return this.rs.getRangeTemplate().getBottomTemplate(this.topBound);
        }
        return this.rs.getRangeTemplate().getMiddleTemplate(this.bottomBound, this.topBound);
    }

    @Override
    public final String getStringValue() {
        if (this.stringValueCached == null) {
            this.stringValueCached = this.computeStringValue();
        }
        return this.stringValueCached;
    }

    public RangeSpace getValueSpace() {
        return this.rs;
    }

    @JsonIgnore
    public Object getActualValue() {
        return this.actualValue;
    }

    public Number getBottomBound() {
        return this.bottomBound;
    }

    public Number getTopBound() {
        return this.topBound;
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object object) {
        return this.isEquals(object);
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public <T> void setActualValue(T t) throws UnsupportedOperationException {
        this.actualValue = t;
    }

    public void setBottomBound(Number number) {
        this.bottomBound = number;
    }

    public void setTopBound(Number number) {
        this.topBound = number;
    }

    public static enum RangeBound {
        LOWER,
        UPPER;

    }
}

