/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.numeric.template;

import core.util.data.GSDataParser;
import core.util.exception.GenstarException;
import java.util.stream.Stream;

public class GSRangeTemplate {
    private final String bottomBound;
    private final String middle;
    private final String topBound;
    private final String match;
    private final GSDataParser.NumMatcher numMatcher;

    public GSRangeTemplate(String string, String string2, String string3, String string4, GSDataParser.NumMatcher numMatcher) {
        this.match = string4;
        this.middle = string2;
        this.bottomBound = string;
        this.topBound = string3;
        this.numMatcher = numMatcher;
    }

    public String getMiddleTemplate(Number number, Number number2) {
        return this.middle.replaceFirst(this.match, number.toString()).replaceFirst(this.match, number2.toString());
    }

    public String getBottomTemplate(Number number) {
        return this.bottomBound.replaceFirst(this.match, number.toString());
    }

    public String getTopTemplate(Number number) {
        return this.topBound.replaceFirst(this.match, number.toString());
    }

    public boolean isValideRangeCandidate(String string) {
        String string3 = string.replaceAll(this.numMatcher.getMatch(), this.match);
        return Stream.of(this.bottomBound, this.middle, this.topBound).anyMatch(string2 -> string2.equals(string3));
    }

    public GSDataParser.NumMatcher getNumberMatcher() {
        return this.numMatcher;
    }

    public Number getTheoreticalMin() {
        return switch (this.numMatcher) {
            case GSDataParser.NumMatcher.DOUBLE_MATCH_ENG, GSDataParser.NumMatcher.DOUBLE_MATCH_FR -> Double.MIN_VALUE;
            case GSDataParser.NumMatcher.DOUBLE_POSITIF_MATCH_ENG, GSDataParser.NumMatcher.DOUBLE_POSITIF_MATCH_FR -> 0.0;
            case GSDataParser.NumMatcher.INT_MATCH -> Integer.MIN_VALUE;
            case GSDataParser.NumMatcher.INT_POSITIF_MATCH -> 0;
            default -> throw new GenstarException();
        };
    }

    public Number getTheoreticalMax() {
        return switch (this.numMatcher) {
            case GSDataParser.NumMatcher.DOUBLE_MATCH_ENG, GSDataParser.NumMatcher.DOUBLE_POSITIF_MATCH_ENG, GSDataParser.NumMatcher.DOUBLE_MATCH_FR, GSDataParser.NumMatcher.DOUBLE_POSITIF_MATCH_FR -> Double.MAX_VALUE;
            case GSDataParser.NumMatcher.INT_POSITIF_MATCH, GSDataParser.NumMatcher.INT_MATCH -> Integer.MAX_VALUE;
            default -> throw new GenstarException();
        };
    }

    public String toString() {
        return "Template: {" + this.bottomBound + " ... " + this.middle + " ... " + this.topBound + "}";
    }
}

