/*
 * Decompiled with CFR 0.152.
 */
package core.util.data;

import core.metamodel.value.numeric.template.GSRangeTemplate;
import core.util.data.GSEnumDataType;
import core.util.exception.GSIllegalRangedData;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GSDataParser {
    private static final String DOES_NOT_REPRESENT_ANY_VALUE = " does not represent any value";
    private static final String THE_STRING_RANGED_DATA = "The string ranged data ";
    public static final String DEFAULT_NUM_MATCH = "#";
    private static String SPLIT_OPERATOR = " ";

    public GSEnumDataType getValueType(String string) {
        if ((string = string.trim()).matches(NumMatcher.INT_MATCH.getMatch())) {
            return GSEnumDataType.Integer;
        }
        if (string.matches(NumMatcher.DOUBLE_MATCH_ENG.getMatch()) || string.matches(NumMatcher.DOUBLE_MATCH_FR.getMatch())) {
            return GSEnumDataType.Continue;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(string) || Boolean.FALSE.toString().equalsIgnoreCase(string)) {
            return GSEnumDataType.Boolean;
        }
        try {
            this.getRangedDoubleData(string, NumMatcher.DOUBLE_MATCH_ENG);
            return GSEnumDataType.Range;
        }
        catch (Exception exception) {
            return GSEnumDataType.Nominal;
        }
    }

    /*
     * WARNING - void declaration
     */
    public GSRangeTemplate getRangeTemplate(List<String> list, String string, NumMatcher numMatcher) throws GSIllegalRangedData {
        void var5_10;
        void var5_8;
        List<Integer> list2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String object2 : list) {
            arrayList.addAll(this.getRangedIntegerData(object2, numMatcher));
        }
        Collections.sort(arrayList);
        String string2 = "";
        Object object3 = "";
        String string3 = "";
        for (String string4 : list) {
            List<Integer> list3 = this.getRangedIntegerData(string4, numMatcher);
            if (list3.size() == 1) {
                if (((Integer)list3.get(0)).equals(arrayList.get(0))) {
                    String string5 = string4.replaceAll(((Integer)arrayList.get(0)).toString(), string);
                    continue;
                }
                if (!((Integer)list3.get(0)).equals(arrayList.get(arrayList.size() - 1))) continue;
                object3 = string4.replaceAll(((Integer)arrayList.get(arrayList.size() - 1)).toString(), string);
                continue;
            }
            if (string3.isEmpty()) {
                string3 = string4.replaceAll(numMatcher.getMatch(), string);
                continue;
            }
            list2 = string4.replaceAll(numMatcher.getMatch(), string);
            if (((String)((Object)list2)).equalsIgnoreCase(string3)) continue;
            throw new GSIllegalRangedData("Range template has more than 3 range format");
        }
        if (var5_8.isEmpty()) {
            int n = Integer.MAX_VALUE;
            for (String string6 : list) {
                list2 = this.getRangedIntegerData(string6, numMatcher);
                if (list2.size() != 2 || Math.min(list2.get(0), list2.get(1)) >= n) continue;
                n = Math.min(list2.get(0), list2.get(1));
                String string7 = string6;
            }
        }
        if (((String)object3).isEmpty()) {
            int n = -2147483647;
            for (String string8 : list) {
                list2 = this.getRangedIntegerData(string8, numMatcher);
                if (list2.size() != 2 || Math.max(list2.get(0), list2.get(1)) <= n) continue;
                n = Math.max(list2.get(0), list2.get(1));
                object3 = string8;
            }
        }
        return new GSRangeTemplate((String)var5_10, string3, (String)object3, string, numMatcher);
    }

    public GSRangeTemplate getRangeTemplate(List<String> list, NumMatcher numMatcher) throws GSIllegalRangedData {
        return this.getRangeTemplate(list, DEFAULT_NUM_MATCH, numMatcher);
    }

    public GSRangeTemplate getRangeTemplate(List<String> list) throws GSIllegalRangedData {
        return this.getRangeTemplate(list, DEFAULT_NUM_MATCH, NumMatcher.getDefault());
    }

    public List<Double> getRangedDoubleData(String string2, NumMatcher numMatcher) throws GSIllegalRangedData {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        List<String> list = this.getNumbers(string2, numMatcher.getMatch());
        list.stream().forEach(String::trim);
        list = list.stream().filter(string -> !string.isEmpty()).toList();
        if (list.isEmpty()) {
            throw new GSIllegalRangedData(THE_STRING_RANGED_DATA + string2 + DOES_NOT_REPRESENT_ANY_VALUE);
        }
        if (list.size() > 2) {
            throw new GSIllegalRangedData(THE_STRING_RANGED_DATA + string2 + " has more than 2 (lower / upper) values");
        }
        for (String string3 : list) {
            arrayList.add(Double.valueOf(string3));
        }
        return arrayList;
    }

    @Deprecated(forRemoval=true)
    public List<Double> getRangedData(String string2, NumMatcher numMatcher, Double d, Double d2) throws GSIllegalRangedData {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        string2 = string2.replaceAll(numMatcher.getMatch(), SPLIT_OPERATOR);
        List<String> list = Arrays.asList(string2.trim().split(SPLIT_OPERATOR));
        list.stream().forEach(String::trim);
        list = list.stream().filter(string -> !string.isEmpty()).toList();
        if (list.isEmpty()) {
            throw new GSIllegalRangedData(THE_STRING_RANGED_DATA + string2 + DOES_NOT_REPRESENT_ANY_VALUE);
        }
        if (list.size() > 2) {
            throw new GSIllegalRangedData(THE_STRING_RANGED_DATA + string2 + " has more than 2 (min / max) values");
        }
        if (list.size() == 1) {
            if (d == null && d2 == null) {
                throw new GSIllegalRangedData("for implicit bounded values, either min or max value in argument must be set to a concret value !");
            }
            if (d2 == null) {
                list.add(0, String.valueOf(d));
            } else if (d == null) {
                list.add(String.valueOf(d2));
            }
            if (d != null && d2 != null && Double.valueOf(list.get(0)) - d <= d2 - Double.valueOf(list.get(0))) {
                list.add(0, String.valueOf(d));
            } else {
                list.add(String.valueOf(d2));
            }
        }
        for (String string3 : list) {
            arrayList.add(Double.valueOf(string3));
        }
        return arrayList;
    }

    public List<Integer> getRangedIntegerData(String string2, NumMatcher numMatcher) throws GSIllegalRangedData {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<String> list = this.getNumbers(string2, numMatcher.getMatch());
        list.stream().forEach(String::trim);
        list = list.stream().filter(string -> !string.isEmpty()).toList();
        if (list.isEmpty()) {
            throw new GSIllegalRangedData(THE_STRING_RANGED_DATA + string2 + DOES_NOT_REPRESENT_ANY_VALUE);
        }
        if (list.size() > 2) {
            throw new GSIllegalRangedData(THE_STRING_RANGED_DATA + string2 + " has more than 2 (lower / upper) values");
        }
        for (String string3 : list) {
            arrayList.add(Integer.valueOf(string3));
        }
        return arrayList;
    }

    @Deprecated(forRemoval=true)
    public List<Integer> getRangedData(String string2, NumMatcher numMatcher, Integer n, Integer n2) throws GSIllegalRangedData {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        string2 = string2.replaceAll(numMatcher.getMatch(), SPLIT_OPERATOR);
        List<String> list = Arrays.asList(string2.trim().split(SPLIT_OPERATOR));
        list.stream().forEach(String::trim);
        list = list.stream().filter(string -> !string.isEmpty()).toList();
        if (list.isEmpty()) {
            throw new GSIllegalRangedData(THE_STRING_RANGED_DATA + string2 + DOES_NOT_REPRESENT_ANY_VALUE);
        }
        if (list.size() > 2) {
            throw new GSIllegalRangedData(THE_STRING_RANGED_DATA + string2 + " has more than 2 (min / max) values");
        }
        if (list.size() == 1) {
            if (n == null && n2 == null) {
                throw new GSIllegalRangedData("for implicit bounded values, either min or max value in argument must be set to a concret value !");
            }
            if (n2 == null || n != null && Integer.valueOf(list.get(0)) - n <= n2 - Integer.valueOf(list.get(0))) {
                list.add(0, String.valueOf(n));
            } else {
                list.add(String.valueOf(n2));
            }
        }
        for (String string3 : list) {
            arrayList.add(Integer.valueOf(string3));
        }
        return arrayList;
    }

    public Double getDouble(String string) {
        if (string == null || string.isEmpty()) {
            throw new NumberFormatException(string);
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            Locale locale = Locale.getDefault();
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            try {
                return numberFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                String string2 = string.replace(',', '.');
                return Double.valueOf(string2);
            }
        }
    }

    public List<String> getNumber(String string) {
        return this.getNumbers(string, NumMatcher.getDefault().getMatch());
    }

    public List<Number> getNumbers(String string, NumMatcher numMatcher) {
        return this.getNumbers(string, numMatcher.getMatch()).stream().map(this::parseNumbers).toList();
    }

    public Number parseNumbers(String string) {
        return switch (this.getValueType(string)) {
            case GSEnumDataType.Continue -> Double.valueOf(this.getNumbers(string, NumMatcher.DOUBLE_MATCH_ENG.getMatch()).get(0));
            case GSEnumDataType.Integer -> Integer.valueOf(this.getNumbers(string, NumMatcher.INT_MATCH.getMatch()).get(0));
            default -> Double.NaN;
        };
    }

    private List<String> getNumbers(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList;
    }

    public static enum NumMatcher {
        DOUBLE_MATCH_ENG("(\\-)?(\\d+\\.\\d+)(E(\\-)?\\d+)?"),
        DOUBLE_POSITIF_MATCH_ENG("(^\\d+\\.\\d+)(E\\-\\d+)?"),
        DOUBLE_MATCH_FR("(\\-)?(\\d+\\,\\d+)(E(\\-)?\\d+)?"),
        DOUBLE_POSITIF_MATCH_FR("(^\\d+\\,\\d+)(E\\-\\d+)?"),
        INT_POSITIF_MATCH("\\d+"),
        INT_MATCH("-?\\d+");

        private final String match;

        private NumMatcher(String string2) {
            this.match = string2;
        }

        public String getMatch() {
            return this.match;
        }

        public static NumMatcher getDefault() {
            return INT_POSITIF_MATCH;
        }
    }
}

