/*
 * Decompiled with CFR 0.152.
 */
package core.util.random.roulette;

import java.util.Collections;
import java.util.List;

public abstract class ARouletteWheelSelection<T extends Number, K> {
    protected List<T> distribution = null;
    protected List<K> keys = null;
    T total = null;

    protected ARouletteWheelSelection(List<T> list) {
        this.setDistribution(list);
    }

    public void remove(K k) {
        int n = this.keys.indexOf(k);
        this.keys.remove(n);
        Number number = (Number)this.distribution.remove(n);
        this.decreaseTotal(number);
    }

    protected abstract void decreaseTotal(T var1);

    public List<K> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public void setKeys(List<K> list) {
        this.keys = list;
    }

    public T getValue(K k) {
        return (T)((Number)this.distribution.get(this.keys.indexOf(k)));
    }

    protected abstract T computeDistributionSum(List<T> var1);

    public void setDistribution(List<T> list) {
        this.distribution = list;
        this.total = this.computeDistributionSum(list);
    }

    public abstract int drawIndex() throws IllegalStateException;

    public <X> X drawObject() throws IllegalStateException {
        try {
            return (X)this.keys.get(this.drawIndex());
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("please call setKeys() first to define the keys");
        }
    }
}

