/*
 * Decompiled with CFR 0.152.
 */
package core.util.random.roulette;

import core.util.random.GenstarRandom;
import core.util.random.roulette.ARouletteWheelSelection;
import java.util.List;
import java.util.stream.Collectors;

public class DoubleRouletteWheelSelection<K>
extends ARouletteWheelSelection<Double, K> {
    public DoubleRouletteWheelSelection(List<Double> list) {
        super(list);
    }

    @Override
    protected Double computeDistributionSum(List<Double> list) {
        return list.stream().collect(Collectors.summingDouble(d -> d));
    }

    @Override
    protected void decreaseTotal(Double d) {
        this.total = (Double)this.total - d;
    }

    @Override
    public int drawIndex() throws IllegalStateException {
        if (this.distribution == null) {
            throw new IllegalStateException("please define the distributoin first using setDistribution()");
        }
        double d = GenstarRandom.getInstance().nextDouble() * (Double)this.total;
        double d2 = 0.0;
        int n = 0;
        while (n < this.distribution.size()) {
            if (d < (d2 += ((Double)this.distribution.get(n)).doubleValue())) {
                return n;
            }
            ++n;
        }
        return this.distribution.size() - 1;
    }
}

