/*
 * Decompiled with CFR 0.152.
 */
package core.util.random.roulette;

import core.util.random.roulette.ARouletteWheelSelection;
import core.util.random.roulette.DoubleRouletteWheelSelection;
import core.util.random.roulette.IntegerRouletteWheelSelection;
import java.util.List;

public final class RouletteWheelSelectionFactory {
    public static <X extends Number, K> ARouletteWheelSelection<X, K> getRouletteWheel(List<X> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("the distribution cannot be empty for roulette wheel selection");
        }
        X x = list.get(0);
        if (x instanceof Double) {
            return new DoubleRouletteWheelSelection(list);
        }
        if (x instanceof Integer) {
            return new IntegerRouletteWheelSelection((List<Integer>)list);
        }
        throw new IllegalArgumentException("roulette wheel selection is only implemented for Double or Integer; " + x.getClass().getSimpleName() + " found instead.");
    }

    public static <X extends Number, K> ARouletteWheelSelection<X, K> getRouletteWheel(List<X> list, List<K> list2) {
        ARouletteWheelSelection<X, K> aRouletteWheelSelection = RouletteWheelSelectionFactory.getRouletteWheel(list);
        aRouletteWheelSelection.setKeys(list2);
        return aRouletteWheelSelection;
    }

    private RouletteWheelSelectionFactory() {
    }
}

