/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.generator;

import core.configuration.GenstarConfigurationFile;
import core.configuration.dictionary.AttributeDictionary;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.AttributeFactory;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.metamodel.value.numeric.RangeSpace;
import core.util.data.GSEnumDataType;
import core.util.exception.GSIllegalRangedData;
import core.util.random.GenstarRandom;
import espacedev.gaml.extensions.genstar.generator.IGenstarGenerator;
import espacedev.gaml.extensions.genstar.statement.GenerateStatement;
import espacedev.gaml.extensions.genstar.utils.GenStarGamaUtils;
import gospl.GosplPopulation;
import gospl.algo.IGosplConcept;
import gospl.algo.sr.ds.DirectSamplingAlgo;
import gospl.distribution.GosplContingencyTable;
import gospl.distribution.GosplInputDataManager;
import gospl.distribution.exception.IllegalControlTotalException;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.generator.DistributionBasedGenerator;
import gospl.io.exception.InvalidSurveyFormatException;
import gospl.io.util.ReadDictionaryUtils;
import gospl.sampler.ISampler;
import gospl.sampler.sr.GosplBasicSampler;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import msi.gama.metamodel.agent.IAgent;
import msi.gama.metamodel.population.IPopulation;
import msi.gama.runtime.IScope;
import msi.gama.runtime.exceptions.GamaRuntimeException;
import msi.gama.util.GamaMapFactory;
import msi.gama.util.IList;
import msi.gama.util.IMap;
import msi.gama.util.file.GamaCSVFile;
import msi.gaml.statements.Arguments;
import msi.gaml.types.IType;
import msi.gaml.types.Types;
import msi.gaml.variables.IVariable;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class FileBasedGenerator
implements IGenstarGenerator {
    private static final FileBasedGenerator INSTANCE = new FileBasedGenerator();
    final IType type = Types.LIST.of((IType)Types.FILE);

    public static FileBasedGenerator getInstance() {
        return INSTANCE;
    }

    private FileBasedGenerator() {
    }

    @Override
    public IType sourceType() {
        return this.type;
    }

    @Override
    public boolean sourceMatch(IScope iScope, Object object2) {
        return object2 instanceof IList && ((IList)object2).stream(iScope).allMatch(object -> object instanceof GamaCSVFile);
    }

    @Override
    public void generate(IScope iScope, List<Map<String, Object>> list, Integer n, Object object, Object object2, Object object3, Arguments arguments, GenerateStatement generateStatement) {
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object922;
        IAgent iAgent = iScope.getAgent();
        IPopulation iPopulation = iAgent.getPopulationFor(generateStatement.getDescription().getSpeciesContext().getName());
        IMap iMap = (IMap)object2;
        ArrayList<Attribute<? extends IValue>> arrayList = new ArrayList<Attribute<? extends IValue>>();
        for (Object object922 : iMap.getKeys()) {
            object8 = iPopulation.getVar((String)object922).getType();
            object7 = ReadDictionaryUtils.detectIsRange((Collection)iMap.get(object922)) ? GSEnumDataType.Range : GenStarGamaUtils.toDataType((IType)object8, false);
            object6 = null;
            try {
                object6 = AttributeFactory.getFactory().createAttribute((String)object922, (GSEnumDataType)((Object)object7), (List)iMap.get(object922));
            }
            catch (GSIllegalRangedData gSIllegalRangedData) {
                gSIllegalRangedData.printStackTrace();
            }
            if (object6 == null) continue;
            arrayList.add((Attribute<? extends IValue>)object6);
        }
        object922 = (IList)object;
        List list2 = object922.stream(iScope).map(gamaCSVFile -> GenStarGamaUtils.toSurveyWrapper(iScope, gamaCSVFile, arrayList)).toList();
        GenstarRandom.setInstance(iScope.getRandom().getGenerator());
        object8 = new GosplPopulation();
        object7 = FileSystems.getDefault().getPath(".", new String[0]);
        object6 = new GenstarConfigurationFile();
        ((GenstarConfigurationFile)object6).setBaseDirectory((Path)object7);
        ((GenstarConfigurationFile)object6).setSurveyWrappers(list2);
        ((GenstarConfigurationFile)object6).setDictionary(new AttributeDictionary(arrayList));
        GosplInputDataManager gosplInputDataManager = new GosplInputDataManager((GenstarConfigurationFile)object6);
        IGosplConcept.EGosplAlgorithm eGosplAlgorithm = object3 == null ? IGosplConcept.EGosplAlgorithm.DS : GenStarGamaUtils.toGosplAlgorithm(object3.toString());
        switch (eGosplAlgorithm.concept) {
            case CO: {
                break;
            }
            case MIXTURE: {
                throw new UnsupportedOperationException("Mixture population synthesis have not yet been ported from API to plugin ! request dev at https://github.com/ANRGenstar/genstar.gamaplugin ;)");
            }
            case MULTILEVEL: {
                throw new UnsupportedOperationException("I'll do it asap");
            }
            default: {
                object5 = FileBasedGenerator.manageRawData(iScope, gosplInputDataManager);
                object4 = null;
                for (Attribute attribute : arrayList) {
                    if (!(attribute.getValueSpace() instanceof RangeSpace)) continue;
                    ((RangeSpace)attribute.getValueSpace()).consolidateRanges();
                }
                switch (eGosplAlgorithm) {
                    case HS: {
                        break;
                    }
                    default: {
                        try {
                            object4 = new DirectSamplingAlgo().inferSRSampler((INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double>)object5, new GosplBasicSampler());
                            break;
                        }
                        catch (IllegalDistributionCreation illegalDistributionCreation) {
                            throw GamaRuntimeException.error((String)("Error of distribution creation in infering the sampler for " + eGosplAlgorithm.name + " SR Based algorithm. " + illegalDistributionCreation.getMessage()), (IScope)iScope);
                        }
                    }
                }
                object8 = new DistributionBasedGenerator((ISampler<ACoordinate<Attribute<? extends IValue>, IValue>>)object4).generate(FileBasedGenerator.inferPopulationSize(n, gosplInputDataManager));
            }
        }
        if (n > 0 && n < object8.size()) {
            iScope.getRandom().shuffleInPlace((Collection)object8);
        }
        object4 = object8.iterator();
        while (object4.hasNext()) {
            object5 = (ADemoEntity)object4.next();
            IMap iMap2 = GamaMapFactory.create();
            for (Attribute attribute : arrayList) {
                IVariable iVariable = iPopulation.getVar(attribute.getAttributeName());
                iMap2.put(attribute.getAttributeName(), GenStarGamaUtils.toGAMAValue(iScope, ((ADemoEntity)object5).getValueForAttribute(attribute), true, iVariable.getType()));
            }
            generateStatement.fillWithUserInit(iScope, (Map)iMap2);
            list.add((Map<String, Object>)iMap2);
        }
    }

    public static INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> manageRawData(IScope iScope, GosplInputDataManager gosplInputDataManager) {
        try {
            gosplInputDataManager.buildDataTables();
        }
        catch (InvalidSurveyFormatException | IOException | RuntimeException | InvalidFormatException throwable) {
            throw GamaRuntimeException.error((String)("Error in building dataTable for the IS algorithm. " + throwable.getMessage()), (IScope)iScope);
        }
        INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> iNDimensionalMatrix = null;
        try {
            iNDimensionalMatrix = gosplInputDataManager.collapseDataTablesIntoDistribution();
        }
        catch (IllegalDistributionCreation illegalDistributionCreation) {
            throw GamaRuntimeException.error((String)("Error of distribution creation in collapsing DataTable into distibution. " + illegalDistributionCreation.getMessage()), (IScope)iScope);
        }
        catch (IllegalControlTotalException illegalControlTotalException) {
            throw GamaRuntimeException.error((String)("Error of control in collapsing DataTable into distibution. " + illegalControlTotalException.getMessage()), (IScope)iScope);
        }
        return iNDimensionalMatrix;
    }

    public static int inferPopulationSize(int n, GosplInputDataManager gosplInputDataManager) {
        if (n < 0) {
            int n2 = Integer.MAX_VALUE;
            for (INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix : gosplInputDataManager.getRawDataTables()) {
                GosplContingencyTable gosplContingencyTable;
                INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix2 = iNDimensionalMatrix;
                if (!(iNDimensionalMatrix2 instanceof GosplContingencyTable)) continue;
                GosplContingencyTable cfr_ignored_0 = (GosplContingencyTable)iNDimensionalMatrix2;
                GosplContingencyTable cfr_ignored_1 = (GosplContingencyTable)iNDimensionalMatrix2;
                n2 = Math.min(n2, gosplContingencyTable.getMatrix().values().stream().mapToInt(AControl::getValue).sum());
            }
            n = n2 < Integer.MAX_VALUE ? n2 : 1;
        }
        return n <= 0 ? 1 : n;
    }
}

