/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.statement;

import espacedev.gaml.extensions.genstar.generator.IGenstarGenerator;
import espacedev.gaml.extensions.genstar.utils.GenStarGamaUtils;
import java.util.List;
import java.util.Map;
import msi.gama.kernel.experiment.ExperimentAgent;
import msi.gama.kernel.experiment.ExperimentPlan;
import msi.gama.kernel.simulation.SimulationPopulation;
import msi.gama.metamodel.agent.IAgent;
import msi.gama.metamodel.agent.IMacroAgent;
import msi.gama.metamodel.population.IPopulation;
import msi.gama.precompiler.GamlAnnotations;
import msi.gama.runtime.IScope;
import msi.gama.runtime.exceptions.GamaRuntimeException;
import msi.gama.util.GamaListFactory;
import msi.gama.util.IList;
import msi.gaml.compilation.IDescriptionValidator;
import msi.gaml.compilation.ISymbol;
import msi.gaml.compilation.annotations.validator;
import msi.gaml.descriptions.ExperimentDescription;
import msi.gaml.descriptions.IDescription;
import msi.gaml.descriptions.ModelDescription;
import msi.gaml.descriptions.SpeciesDescription;
import msi.gaml.descriptions.StatementDescription;
import msi.gaml.expressions.IExpression;
import msi.gaml.expressions.types.SpeciesConstantExpression;
import msi.gaml.operators.Cast;
import msi.gaml.species.ISpecies;
import msi.gaml.statements.AbstractStatementSequence;
import msi.gaml.statements.Arguments;
import msi.gaml.statements.IStatement;
import msi.gaml.statements.RemoteSequence;
import msi.gaml.types.IType;
import msi.gaml.types.Types;
import one.util.streamex.StreamEx;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="species", type={14, 11}, optional=true, doc={@GamlAnnotations.doc(value="The species of the agents to be created.")}), @GamlAnnotations.facet(name="from", type={0}, optional=false, doc={@GamlAnnotations.doc(value="To specify the input data used to inform the generation process. Various data input can be used:\n * list of csv_file: can be aggregated or micro data\n * matrix: describe the joint distribution of two attributes\n * genstar generator: a dedicated gaml type to enclose various genstar options all in one")}), @GamlAnnotations.facet(name="attributes", type={10}, optional=false, doc={@GamlAnnotations.doc(value="To specify the explicit link between agent attributes and file based attributes")}), @GamlAnnotations.facet(name="number", type={1}, optional=true, doc={@GamlAnnotations.doc(value="To specify the number of created agents interpreted as an int value.\nIf facet is ommited or value is 0 or less, generator will treat data used in the 'from' facet as contingencies\n(i.e. a count of entities) and infer a number to generate (if distribution is used, then only one entity will be created")}), @GamlAnnotations.facet(name="generator", type={4}, optional=true, doc={@GamlAnnotations.doc(value="To specify the type of generator you want to use: as of now there is only DS (or DirectSampling) available")})}, omissible="species")
@GamlAnnotations.doc(value="Allows to create a synthetic population of agent from a set of given rules", usages={@GamlAnnotations.usage(value="The synthax to create a minimal synthetic population from aggregated file is:", examples={@GamlAnnotations.example(value="generate species:people number: 10000\nfrom:[csv_file(\"../includes/Age & Sexe-Tableau 1.csv\",\";\")]\nattributes:[\"Age\"::[\"Moins de 5 ans\", \"5 \u00e0 9 ans\", \"10 \u00e0 14 ans\", \"15 \u00e0 19 ans\", \"20 \u00e0 24 ans\",\n\"25 \u00e0 29 ans\", \"30 \u00e0 34 ans\", \"35 \u00e0 39 ans\", \"40 \u00e0 44 ans\", \"45 \u00e0 49 ans\",\n\"50 \u00e0 54 ans\", \"55 \u00e0 59 ans\", \"60 \u00e0 64 ans\", \"65 \u00e0 69 ans\", \"70 \u00e0 74 ans\", \"75 \u00e0 79 ans\",\n\"80 \u00e0 84 ans\", \"85 \u00e0 89 ans\", \"90 \u00e0 94 ans\", \"95 \u00e0 99 ans\", \"100 ans ou plus\"],\n\"Sexe\"::[\"Hommes\", \"Femmes\"]];", isExecutable=false)})})
@validator(value=GenerateValidator.class)
public class GenerateStatement
extends AbstractStatementSequence
implements IStatement.WithArgs {
    private Arguments init;
    private final IExpression from;
    private final IExpression number;
    private final IExpression species;
    private final IExpression attributes;
    private final IExpression algorithm;
    private final String returns = this.getLiteral("returns");
    private final RemoteSequence sequence;

    public GenerateStatement(IDescription iDescription) {
        super(iDescription);
        this.from = this.getFacet(new String[]{"from"});
        this.number = this.getFacet(new String[]{"number"});
        this.species = this.getFacet(new String[]{"species"});
        this.attributes = this.getFacet(new String[]{"attributes"});
        this.algorithm = this.getFacet(new String[]{"generator"});
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands of generate ");
        this.setName("generate");
    }

    public IList<? extends IAgent> privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Integer n;
        Integer n2 = n = this.number == null ? null : Cast.asInt((IScope)iScope, (Object)this.number.value(iScope));
        if (this.from == null && n != null && n <= 0) {
            return GamaListFactory.EMPTY_LIST;
        }
        IPopulation iPopulation = this.findPopulation(iScope);
        if (iPopulation == null || iPopulation.getSpecies() == null) {
            throw GamaRuntimeException.error((String)"Impossible to determine the species of the agents to generate", (IScope)iScope);
        }
        this.checkPopulationValidity(iPopulation, iScope);
        IList iList = GamaListFactory.create((IType)Types.MAP, (int)(n == null ? 10 : n));
        Object object = this.from.value(iScope);
        ((IGenstarGenerator)StreamEx.of((Object[])GenStarGamaUtils.getGamaGenerator()).findFirst(iGenstarGenerator -> iGenstarGenerator.sourceMatch(iScope, object)).orElseThrow(IllegalArgumentException::new)).generate(iScope, (List<Map<String, Object>>)iList, n, object, this.attributes.value(iScope), this.algorithm == null ? null : this.algorithm.value(iScope), this.init, this);
        IList iList2 = iPopulation.createAgents(iScope, iList.size(), (List)iList, false, false, this.sequence);
        if (this.returns != null) {
            iScope.setVarValue(this.returns, (Object)iList2);
        }
        return iList2;
    }

    public void fillWithUserInit(IScope iScope, Map map) {
        if (this.init == null) {
            return;
        }
        iScope.pushReadAttributes(map);
        try {
            this.init.forEachFacet((string, iExpressionDescription) -> {
                map.put(string, iExpressionDescription.getExpression().value(iScope));
                return true;
            });
        }
        finally {
            iScope.popReadAttributes();
        }
    }

    IPopulation findPopulation(IScope iScope) {
        ISpecies iSpecies;
        String string;
        IAgent iAgent = iScope.getAgent();
        if (this.species == null) {
            return iAgent.getPopulationFor(this.description.getSpeciesContext().getName());
        }
        ISpecies iSpecies2 = Cast.asSpecies((IScope)iScope, (Object)this.species.value(iScope));
        if (iSpecies2 == null && (string = this.species.getDenotedType().getSpeciesName()) != null) {
            iSpecies2 = iScope.getModel().getSpecies(string);
        }
        if (iSpecies2 == null) {
            throw GamaRuntimeException.error((String)("No population of " + this.species.serializeToGaml(false) + " is accessible in the context of " + iAgent + "."), (IScope)iScope);
        }
        string = iAgent.getPopulationFor(iSpecies2);
        if (string == null && (iSpecies = iSpecies2) instanceof ExperimentPlan) {
            ExperimentPlan experimentPlan = (ExperimentPlan)iSpecies;
            ExperimentPlan cfr_ignored_0 = (ExperimentPlan)iSpecies;
            if (iAgent instanceof IMacroAgent) {
                ExperimentPlan experimentPlan2 = experimentPlan;
                experimentPlan2.getClass();
                string = new ExperimentPlan.ExperimentPopulation(experimentPlan2, iSpecies2);
                IScope iScope2 = experimentPlan.getExperimentScope();
                string.initializeFor(iScope2);
                ((IMacroAgent)iAgent).addExternMicroPopulation(String.valueOf(iSpecies2.getDescription().getModelDescription().getAlias()) + "." + iSpecies2.getName(), (IPopulation)string);
            }
        }
        return string;
    }

    private void checkPopulationValidity(IPopulation iPopulation, IScope iScope) throws GamaRuntimeException {
        String string;
        if (iPopulation instanceof SimulationPopulation && !(iScope.getAgent() instanceof ExperimentAgent)) {
            throw GamaRuntimeException.error((String)"Simulations can only be created within experiments", (IScope)iScope);
        }
        SpeciesDescription speciesDescription = iPopulation.getSpecies().getDescription();
        String string2 = speciesDescription.isAbstract() ? "abstract" : (speciesDescription.isMirror() ? "a mirror" : (speciesDescription.isBuiltIn() ? "built-in" : (string = speciesDescription.isGrid() ? "a grid" : null)));
        if (string != null) {
            throw GamaRuntimeException.error((String)(String.valueOf(speciesDescription.getName()) + "is " + string + " and cannot be instantiated."), (IScope)iScope);
        }
    }

    public void setFormalArgs(Arguments arguments) {
        this.init = arguments;
    }

    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence.setChildren(iterable);
    }

    public void enterScope(IScope iScope) {
        if (this.returns != null) {
            iScope.addVarWithValue(this.returns, null);
        }
        super.enterScope(iScope);
    }

    public static class GenerateValidator
    implements IDescriptionValidator<StatementDescription> {
        public void validate(StatementDescription statementDescription) {
            IType iType;
            IExpression iExpression = statementDescription.getFacetExpr(new String[]{"species"});
            if (iExpression == null) {
                statementDescription.error("The species is not found", "gaml.unknown.species.issue", "species", new String[0]);
                return;
            }
            SpeciesDescription speciesDescription = iExpression.getGamlType().getDenotedSpecies();
            if (speciesDescription == null) {
                statementDescription.error("The species to instantiate cannot be determined", "gaml.unknown.species.issue", "species", new String[]{iExpression.getName()});
                return;
            }
            if (iExpression instanceof SpeciesConstantExpression) {
                boolean bl = speciesDescription.isAbstract();
                boolean bl2 = speciesDescription.isMirror();
                boolean bl3 = speciesDescription.isGrid();
                boolean bl4 = speciesDescription.isBuiltIn();
                if (bl || bl2 || bl3 || bl4) {
                    String string2 = bl ? "abstract" : (bl2 ? "a mirror" : (bl3 ? "a grid" : (bl4 ? "built-in" : "")));
                    statementDescription.error(String.valueOf(speciesDescription.getName()) + " is " + string2 + " and cannot be instantiated", "gaml.wrong.type.issue", "species", new String[0]);
                    return;
                }
            } else if (!(speciesDescription instanceof ModelDescription)) {
                statementDescription.info("The actual species will be determined at runtime. This can lead to errors if it cannot be instantiated", "gaml.wrong.type.issue", "species", new String[0]);
            }
            if (speciesDescription instanceof ModelDescription && !(statementDescription.getSpeciesContext() instanceof ExperimentDescription)) {
                statementDescription.error("Simulations can only be created within experiments", "gaml.wrong.context.issue", "species", new String[0]);
                return;
            }
            SpeciesDescription speciesDescription2 = statementDescription.getSpeciesContext();
            SpeciesDescription speciesDescription3 = speciesDescription.getMacroSpecies();
            if (speciesDescription3 == null) {
                statementDescription.error("The macro-species of " + iExpression + " cannot be determined");
                return;
            }
            if (!(speciesDescription3 instanceof ModelDescription && speciesDescription2 instanceof ModelDescription || speciesDescription2 == speciesDescription3 || speciesDescription2.hasMacroSpecies(speciesDescription3) || speciesDescription2.hasParent(speciesDescription3))) {
                statementDescription.error("No instance of " + speciesDescription3.getName() + " available for creating instances of " + speciesDescription.getName());
                return;
            }
            IExpression iExpression2 = statementDescription.getFacetExpr(new String[]{"from"});
            if (iExpression2 != null && (iType = iExpression2.getGamlType()).id() != 938373948) {
                boolean bl = false;
                List list = StreamEx.of((Object[])GenStarGamaUtils.getGamaGenerator()).map(IGenstarGenerator::sourceType).toList();
                for (IType iType2 : list) {
                    bl = iType2.isAssignableFrom(iType);
                    if (bl) break;
                }
                if (!bl) {
                    statementDescription.warning("Facet 'from' expects an expression with one of the following types: " + list, "gaml.wrong.type.issue", "from", new String[0]);
                }
            }
            Arguments arguments = statementDescription.getPassedArgs();
            arguments.forEachFacet((string, iExpressionDescription) -> {
                boolean bl;
                boolean bl2 = bl = !speciesDescription.isExperiment() && !speciesDescription.hasAttribute(string);
                if (bl) {
                    statementDescription.error("Attribute " + string + " is not defined in species " + iExpression.getName(), "gaml.unknown.var.issue");
                }
                return !bl;
            });
        }
    }
}

