/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.type;

import core.configuration.dictionary.AttributeDictionary;
import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.AttributeFactory;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.io.GSSurveyWrapper;
import core.metamodel.value.IValue;
import espacedev.gaml.extensions.genstar.utils.GenStarConstant;
import espacedev.gaml.extensions.genstar.utils.GenStarGamaConstraintBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import msi.gama.metamodel.agent.IAgent;
import msi.gama.precompiler.GamlAnnotations;
import msi.gama.runtime.IScope;
import msi.gama.util.GamaListFactory;
import msi.gama.util.IContainer;
import msi.gama.util.IList;
import msi.gama.util.file.json.Json;
import msi.gama.util.file.json.JsonValue;
import msi.gaml.types.IType;
import msi.gaml.types.Types;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="demographic_attributes", type=5, of=4, doc={@GamlAnnotations.doc(value="Returns the list of attribute names")}), @GamlAnnotations.variable(name="GOSP_algorithm", type=4, doc={@GamlAnnotations.doc(value="Returns the name of the generation algorithm")}), @GamlAnnotations.variable(name="demogrphic_marginals", type=-200, doc={@GamlAnnotations.doc(value="Returns the list of marginals to fit synthetic population with")}), @GamlAnnotations.variable(name="ipf", type=3, init="false", doc={@GamlAnnotations.doc(value="Enable the use of IPF to extrapolate a joint distribution upon marginals and seed sample")}), @GamlAnnotations.variable(name="Nests_geometries", type=4, doc={@GamlAnnotations.doc(value="Returns the spatial file used to localize entities")}), @GamlAnnotations.variable(name="distribution_feature", type=4, doc={@GamlAnnotations.doc(value="The spatial feature to based spatial distribution of nest uppon")}), @GamlAnnotations.variable(name="spatial_distribution", type=0, doc={@GamlAnnotations.doc(value="The type of spatial distribution used to locate entities: uniform, based on area, based on density or capacity")}), @GamlAnnotations.variable(name="spatial_constraints", type=0, doc={@GamlAnnotations.doc(value="The constraints that weight on probabilities that make up the spatial distribution, e.g. a constraint of distance to a given geometry")})})
public class GamaPopGenerator
implements msi.gama.common.interfaces.IValue {
    IPopulation<? extends ADemoEntity, ?> generatedPopulation;
    Map<ADemoEntity, IAgent> mapEntitiesAgent;
    public static final String GENERATION_ALGO_LABEL = "GOSP_algorithm";
    private String generationAlgorithm = GenStarConstant.GenerationAlgorithm.DIRECTSAMPLING.getAlias().get(0);
    public static final String DEMOGRAPHIC_FILES_LABEL = "demographic_files";
    private List<GSSurveyWrapper> inputFiles = new ArrayList<GSSurveyWrapper>();
    public static final String ATTRIBUTES_DICTIONARY_LABEL = "individual_dictionary";
    public static final String HOUSEHOLD_DICTIONARY_LABEL = "household_dictionary";
    public static final String ATTRIBUTES_LABEL = "demographic_attributes";
    public static final String MARGINALS_LABEL = "demogrphic_marginals";
    private AttributeDictionary householdAttributes;
    private AttributeDictionary individualAttributes = new AttributeDictionary();
    private List<Attribute<? extends IValue>> marginals;
    public static final String IPF_LABEL = "ipf";
    private boolean ipf;
    boolean spatializePopulation;
    Double minDistanceLocalize = 0.0;
    Double maxDistanceLocalize = 0.0;
    boolean localizeOverlaps = false;
    public static final String MATCH_LABEL = "matcher_file";
    String pathCensusGeometries;
    public static final String NESTS_LABEL = "Nests_geometries";
    String pathNestGeometries;
    public static final String AGENT_NESTS_LABEL = "Nests_agents";
    IContainer<?, ? extends IAgent> listOfNestAgents;
    public static final String SPATIAL_DISTRIBUTION_LABEL = "spatial_distribution";
    private GenStarConstant.SpatialDistribution spatialDistribution;
    public static final String D_FEATURE_LABEL = "distribution_feature";
    private String distributionFeature = "";
    public static final String CONSTRAINTS_LABEL = "spatial_constraints";
    private final GenStarGamaConstraintBuilder cBuilder;
    String crs;
    private int priorityCounter;
    List<String> pathAncilaryGeofiles = new ArrayList<String>();

    public GamaPopGenerator() {
        this.mapEntitiesAgent = new HashMap<ADemoEntity, IAgent>();
        this.cBuilder = new GenStarGamaConstraintBuilder();
    }

    public String stringValue(IScope iScope) {
        return null;
    }

    public msi.gama.common.interfaces.IValue copy(IScope iScope) {
        return null;
    }

    public AttributeFactory getAttf() {
        return AttributeFactory.getFactory();
    }

    @GamlAnnotations.setter(value="demographic_files")
    public void setInputFiles(List<GSSurveyWrapper> list) {
        this.inputFiles = list;
    }

    @GamlAnnotations.getter(value="household_dictionary")
    public AttributeDictionary getHouseholdAttributes() {
        return this.householdAttributes;
    }

    @GamlAnnotations.setter(value="household_dictionary")
    public void setHouseholdAttributes(AttributeDictionary attributeDictionary) {
        this.householdAttributes = attributeDictionary;
    }

    @GamlAnnotations.getter(value="individual_dictionary")
    public AttributeDictionary getInputAttributes() {
        return this.individualAttributes;
    }

    @GamlAnnotations.setter(value="individual_dictionary")
    public void setInputAttributes(AttributeDictionary attributeDictionary) {
        this.individualAttributes = attributeDictionary;
    }

    @GamlAnnotations.getter(value="demographic_attributes")
    public IList<String> getAttributeName() {
        IList iList = GamaListFactory.create((IType)Types.STRING);
        for (Attribute<? extends IValue> attribute : this.getInputAttributes().getAttributes()) {
            iList.add((Object)attribute.getAttributeName());
        }
        return iList;
    }

    @GamlAnnotations.getter(value="demogrphic_marginals")
    public IList<String> getMarginalsName() {
        IList iList = GamaListFactory.create((IType)Types.STRING);
        for (Attribute<? extends IValue> attribute : this.getMarginals()) {
            iList.add((Object)attribute.getAttributeName());
        }
        return iList;
    }

    public void setMarginals(List<Attribute<? extends IValue>> list) {
        this.marginals = list == null || list.isEmpty() ? new ArrayList<Attribute<? extends IValue>>(this.getInputAttributes().getAttributes()) : list;
    }

    public List<Attribute<? extends IValue>> getMarginals() {
        return Collections.unmodifiableList(this.marginals);
    }

    @GamlAnnotations.getter(value="demographic_files")
    public List<GSSurveyWrapper> getInputFiles() {
        return this.inputFiles;
    }

    @GamlAnnotations.getter(value="GOSP_algorithm")
    public String getGenerationAlgorithm() {
        return this.generationAlgorithm;
    }

    public GenStarConstant.GenerationAlgorithm getGenstarGenerationAlgorithm() {
        return GenStarConstant.GenerationAlgorithm.getAlgorithm(this.generationAlgorithm);
    }

    @GamlAnnotations.getter(value="ipf")
    public boolean getIPF() {
        return this.ipf;
    }

    @GamlAnnotations.setter(value="ipf")
    public void setIPF(boolean bl) {
        this.ipf = bl;
    }

    public void setGenerationAlgorithm(String string) {
        this.generationAlgorithm = string;
    }

    public boolean isSpatializePopulation() {
        return this.spatializePopulation;
    }

    public void setSpatializePopulation(boolean bl) {
        this.spatializePopulation = bl;
    }

    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String string) {
        this.crs = string;
    }

    public int uptadePriorityCounter() {
        int n = this.priorityCounter++;
        return n;
    }

    @GamlAnnotations.getter(value="Nests_geometries")
    public String getPathNestGeometries() {
        return this.pathNestGeometries;
    }

    @GamlAnnotations.setter(value="Nests_geometries")
    public void setPathNestGeometries(String string) {
        this.pathNestGeometries = string;
    }

    @GamlAnnotations.getter(value="Nests_agents")
    public void setNestAgentsGeometries(IContainer<?, ? extends IAgent> iContainer) {
        this.listOfNestAgents = iContainer;
    }

    @GamlAnnotations.setter(value="Nests_agents")
    public IContainer<?, ? extends IAgent> getNestAgentsGeometries() {
        return this.listOfNestAgents;
    }

    @GamlAnnotations.setter(value="matcher_file")
    public void setPathCensusGeometries(String string) {
        this.pathCensusGeometries = string;
        this.setSpatializePopulation(this.pathCensusGeometries != null);
    }

    @GamlAnnotations.getter(value="matcher_file")
    public String getPathCensusGeometries() {
        return this.pathCensusGeometries;
    }

    public void setLocalizedAround(Double d, Double d2, boolean bl) {
        this.setMinDistanceLocalize(d);
        this.setMaxDistanceLocalize(d2);
        this.setLocalizeOverlaps(bl);
    }

    public Double getMinDistanceLocalize() {
        return this.minDistanceLocalize;
    }

    public void setMinDistanceLocalize(Double d) {
        this.minDistanceLocalize = d;
    }

    public Double getMaxDistanceLocalize() {
        return this.maxDistanceLocalize;
    }

    public void setMaxDistanceLocalize(Double d) {
        this.maxDistanceLocalize = d;
    }

    public boolean isLocalizeOverlaps() {
        return this.localizeOverlaps;
    }

    public void setLocalizeOverlaps(boolean bl) {
        this.localizeOverlaps = bl;
    }

    @GamlAnnotations.getter(value="spatial_distribution")
    public GenStarConstant.SpatialDistribution getSpatialDistribution() {
        return this.spatialDistribution;
    }

    @GamlAnnotations.setter(value="spatial_distribution")
    public void setSpatialDistribution(GenStarConstant.SpatialDistribution spatialDistribution) {
        this.spatialDistribution = spatialDistribution;
    }

    @GamlAnnotations.getter(value="distribution_feature")
    public String getSpatialDistributionFeature() {
        return this.distributionFeature;
    }

    @GamlAnnotations.setter(value="distribution_feature")
    public void setSpatialDistributionFeature(String string) {
        this.distributionFeature = string;
    }

    @GamlAnnotations.getter(value="spatial_constraints")
    public GenStarGamaConstraintBuilder getConstraintBuilder() {
        return this.cBuilder;
    }

    public List<String> getPathAncilaryGeofiles() {
        return this.pathAncilaryGeofiles;
    }

    public void addAncilaryGeoFiles(String string) {
        this.pathAncilaryGeofiles.add(string);
    }

    public void setPathAncilaryGeofiles(List<String> list) {
        this.pathAncilaryGeofiles = list;
    }

    public void setGeneratedPopulation(IPopulation<? extends ADemoEntity, ?> iPopulation) {
        this.generatedPopulation = iPopulation;
    }

    public IPopulation<? extends ADemoEntity, ?> getGeneratedPopulation() {
        return this.generatedPopulation;
    }

    public void addAgent(ADemoEntity aDemoEntity, IAgent iAgent) {
        this.mapEntitiesAgent.put(aDemoEntity, iAgent);
    }

    public IAgent getAgent(ADemoEntity aDemoEntity) {
        return this.mapEntitiesAgent.get(aDemoEntity);
    }

    public Collection<IAgent> getAgents() {
        return this.mapEntitiesAgent.values();
    }

    public JsonValue serializeToJson(Json json) {
        return null;
    }
}

