/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.type;

import core.util.random.GenstarRandom;
import java.util.Random;
import msi.gama.common.interfaces.IValue;
import msi.gama.precompiler.GamlAnnotations;
import msi.gama.runtime.IScope;
import msi.gama.util.file.json.Json;
import msi.gama.util.file.json.JsonValue;
import msi.gaml.types.IType;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="min_value", type=2, doc={@GamlAnnotations.doc(value="The lower bound of the range.")}), @GamlAnnotations.variable(name="max_value", type=2, doc={@GamlAnnotations.doc(value="The upper bound of the range.")})})
public class GamaRange
implements IValue {
    Number min;
    Number max;

    public GamaRange(Number number, Number number2) {
        this.min = number;
        this.max = number2;
    }

    @GamlAnnotations.getter(value="min_value")
    public Number getMin() {
        return this.min.doubleValue();
    }

    @GamlAnnotations.getter(value="max_value")
    public Number getMax() {
        return this.max.doubleValue();
    }

    public String serialize(boolean bl) {
        return this.min + "->" + this.max;
    }

    public String stringValue(IScope iScope) {
        return this.serialize(true);
    }

    public String toString() {
        return this.serialize(true);
    }

    public IValue copy(IScope iScope) {
        return new GamaRange(this.min, this.max);
    }

    public Object cast(IScope iScope, IType iType) {
        Object object;
        if (iType == null) {
            object = this;
        } else {
            switch (iType.id()) {
                case 1: {
                    object = this.intValue();
                    break;
                }
                case 2: {
                    object = this.floatValue();
                    break;
                }
                case 4: {
                    object = this.stringValue(iScope);
                    break;
                }
                default: {
                    object = this;
                }
            }
        }
        return object;
    }

    private double floatValue() {
        Random random = GenstarRandom.getInstance();
        return (this.max.doubleValue() - this.min.doubleValue() + 1.0) * random.nextDouble() + this.min.doubleValue();
    }

    private int intValue() {
        return (int)this.floatValue();
    }

    public JsonValue serializeToJson(Json json) {
        return json.valueOf(this.min + "->" + this.max);
    }
}

