/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.utils;

import espacedev.gaml.extensions.genstar.utils.GenStarConstant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import msi.gama.metamodel.shape.IShape;
import msi.gama.runtime.IScope;
import msi.gama.util.IList;
import spll.localizer.constraint.ISpatialConstraint;
import spll.localizer.constraint.SpatialConstraintMaxDensity;
import spll.localizer.constraint.SpatialConstraintMaxDistance;
import spll.localizer.constraint.SpatialConstraintMaxNumber;

public class GenStarGamaConstraintBuilder {
    private final Collection<GenStarConstant.SpatialConstraint> constraints = new LinkedHashSet<GenStarConstant.SpatialConstraint>();
    boolean localizer = false;
    static final double LOCALISAZATION_DEFAULT_STEP = 10.0;
    String localizationFeature;
    String localizationAttribute;
    double localizationLimit;
    double localizationStep;
    int localizationPriority;
    static final double DENSITY_DEFAULT_STEP = 0.1;
    String densityFeature;
    double densityConstant;
    double densityLimit;
    double densityStep;
    int densityPriority;
    static final int CAPACITY_DEFAULT_STEP = 1;
    String capacityFeature;
    int capacityConstant;
    int capacityLimit;
    int capacityStep;
    int capacityPriority;
    static final double DISTANCE_DEFAULT_STEP = 1.0;
    private double distanceConstant;
    private double distanceLimit;
    private double distanceStep;
    private int distancePriority;

    public Collection<GenStarConstant.SpatialConstraint> getConstraints() {
        return Collections.unmodifiableCollection(this.constraints);
    }

    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    public Collection<ISpatialConstraint> buildConstraints(IScope iScope, IList<IShape> iList) throws IllegalStateException {
        if (!this.hasConstraints()) {
            throw new IllegalStateException("You must have at least one constraint setup to use the builder");
        }
        LinkedHashSet<ISpatialConstraint> linkedHashSet = new LinkedHashSet<ISpatialConstraint>();
        for (GenStarConstant.SpatialConstraint spatialConstraint : this.constraints) {
            switch (spatialConstraint) {
                case DENSITY: {
                    linkedHashSet.add(this.densityFeature == null || this.densityFeature.isEmpty() ? this.getConstantDensityConstraint(iList) : this.getFeatureDensityConstraint(iList));
                    break;
                }
                case CAPACITY: {
                    linkedHashSet.add(this.capacityFeature == null || this.capacityFeature.isEmpty() ? this.getConstantCapacityConstraint(iList) : this.getFeatureCapacityConstraint(iList));
                    break;
                }
                case DISTANCE: {
                    linkedHashSet.add(this.getDistanceConstraint(iList));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Trying to build an unkown spatial constraint " + spatialConstraint);
                }
            }
        }
        return linkedHashSet;
    }

    public void addDensityConstraint(String string, double d, double d2, double d3, int n) {
        this.densityFeature = string;
        this.densityConstant = d;
        this.densityLimit = d2;
        this.densityStep = d3 > 0.0 ? d3 : 0.1;
        this.densityPriority = n;
        this.constraints.add(GenStarConstant.SpatialConstraint.DENSITY);
    }

    public ISpatialConstraint getFeatureDensityConstraint(IList<IShape> iList) {
        SpatialConstraintMaxDensity spatialConstraintMaxDensity = new SpatialConstraintMaxDensity(iList, this.densityFeature);
        spatialConstraintMaxDensity.setMaxIncrease(this.densityLimit);
        spatialConstraintMaxDensity.setPriority(this.densityPriority);
        return spatialConstraintMaxDensity;
    }

    public ISpatialConstraint getConstantDensityConstraint(IList<IShape> iList) {
        SpatialConstraintMaxDensity spatialConstraintMaxDensity = new SpatialConstraintMaxDensity(iList, this.densityConstant);
        spatialConstraintMaxDensity.setMaxIncrease(this.densityLimit);
        spatialConstraintMaxDensity.setIncreaseStep(this.densityStep);
        spatialConstraintMaxDensity.setPriority(this.densityPriority);
        return spatialConstraintMaxDensity;
    }

    public void addCapacityConstraint(String string, int n, int n2, int n3, int n4) {
        this.capacityFeature = string;
        this.capacityConstant = n;
        this.capacityLimit = n2;
        this.capacityStep = n3 > 0 ? n3 : 1;
        this.capacityPriority = n4;
        this.constraints.add(GenStarConstant.SpatialConstraint.CAPACITY);
    }

    public ISpatialConstraint getFeatureCapacityConstraint(IList<IShape> iList) {
        SpatialConstraintMaxNumber spatialConstraintMaxNumber = new SpatialConstraintMaxNumber(iList, this.capacityFeature);
        spatialConstraintMaxNumber.setMaxIncrease(this.capacityLimit);
        spatialConstraintMaxNumber.setPriority(this.capacityPriority);
        return spatialConstraintMaxNumber;
    }

    public ISpatialConstraint getConstantCapacityConstraint(IList<IShape> iList) {
        SpatialConstraintMaxNumber spatialConstraintMaxNumber = new SpatialConstraintMaxNumber(iList, (double)this.capacityConstant * 1.0);
        spatialConstraintMaxNumber.setMaxIncrease(this.capacityLimit);
        spatialConstraintMaxNumber.setIncreaseStep(this.capacityStep);
        spatialConstraintMaxNumber.setPriority(this.capacityPriority);
        return spatialConstraintMaxNumber;
    }

    public void addDistanceConstraint(double d, double d2, double d3, int n) {
        this.distanceConstant = d;
        this.distanceLimit = d2;
        this.distanceStep = d3 > 0.0 ? d3 : 1.0;
        this.distancePriority = n;
        this.constraints.add(GenStarConstant.SpatialConstraint.DISTANCE);
    }

    public ISpatialConstraint getDistanceConstraint(IList<IShape> iList) {
        SpatialConstraintMaxDistance spatialConstraintMaxDistance = new SpatialConstraintMaxDistance(iList, this.distanceConstant);
        spatialConstraintMaxDistance.setMaxIncrease(this.distanceLimit);
        spatialConstraintMaxDistance.setIncreaseStep(this.distanceStep);
        spatialConstraintMaxDistance.setPriority(this.distancePriority);
        return spatialConstraintMaxDistance;
    }

    public void addLocalizationConstraint(String string, String string2, double d, double d2, int n) {
        this.localizer = true;
        this.localizationFeature = string;
        this.localizationAttribute = string2;
        this.localizationLimit = d;
        this.localizationStep = d2;
        this.localizationPriority = n;
    }

    public boolean hasLocalizerReleaseOption() {
        return this.localizer;
    }

    public String getLocalizationFeature() {
        return this.localizationFeature;
    }

    public String getLocalizationAttribute() {
        return this.localizationAttribute;
    }

    public double getLocalizationLimit() {
        return this.localizationLimit;
    }

    public double getLocalizationStep() {
        return this.localizationStep;
    }

    public int getLocalizationPriority() {
        return this.localizationPriority;
    }
}

