/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.utils;

import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import msi.gama.common.util.FileUtils;
import msi.gama.runtime.IScope;
import msi.gama.util.file.GamaCSVFile;
import msi.gama.util.file.csv.CsvReader;
import msi.gaml.types.IType;
import msi.gaml.types.Types;
import ummisco.gama.dev.utils.DEBUG;
import ummisco.gama.dev.utils.STRINGS;

public class GenStarGamaSurveyUtils {
    private final GamaCSVFile.CSVInfo stats;
    private final Path path;
    private final List<Attribute<? extends IValue>> atts;
    private final int[] rowHeaderNumber = new int[]{-1, -1};
    private final int[] columnHeaderNumber = new int[]{-1, -1};
    private IType inferedType = null;
    private Double total = null;

    public GenStarGamaSurveyUtils(IScope iScope, GamaCSVFile gamaCSVFile, List<Attribute<? extends IValue>> list) {
        this.path = Paths.get(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)gamaCSVFile.getPath(iScope), (boolean)false), new String[0]);
        this.stats = gamaCSVFile.getInfo(iScope, null);
        this.atts = list;
    }

    public int inferRowHeaders() {
        if (this.rowHeaderNumber[0] == -1) {
            int n = this.rowHeaderNumber[0];
            int n2 = 0;
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (CsvReader csvReader = new CsvReader(this.path.toString(), this.stats.delimiter.charValue());){
                    boolean bl = false;
                    do {
                        if (csvReader.readRecord()) {
                            List<String> list = Arrays.asList(csvReader.getValues()).stream().filter(string -> !string.isBlank()).toList();
                            Optional<Attribute> optional = this.atts.stream().filter(attribute -> attribute.getValueSpace().getValues().stream().allMatch(iValue -> list.contains(iValue.getStringValue()))).findFirst();
                            if (optional.isPresent()) {
                                n2 = optional.get().getValueSpace().getValues().size();
                            } else {
                                bl = true;
                            }
                        }
                        ++n;
                    } while (!bl);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            this.rowHeaderNumber[0] = n;
            this.columnHeaderNumber[1] = n2;
        }
        return this.rowHeaderNumber[0];
    }

    public int inferColumnHeaders() {
        if (this.columnHeaderNumber[0] == -1) {
            int n = 0;
            int n2 = 0;
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (CsvReader csvReader = new CsvReader(this.path.toString(), this.stats.delimiter.charValue());){
                    int n3 = this.inferRowHeaders();
                    do {
                        csvReader.skipLine();
                    } while (--n3 > 0);
                    boolean bl = false;
                    if (csvReader.readRecord()) {
                        List<String> list = Arrays.asList(csvReader.getValues()).stream().filter(string -> !string.isBlank()).toList();
                        int n4 = 0;
                        do {
                            String string2 = list.get(n4++);
                            Optional<Attribute> optional = this.atts.stream().filter(attribute -> attribute.getValueSpace().contains(string2)).findFirst();
                            if (optional.isPresent()) {
                                n2 = optional.get().getValueSpace().getValues().size() > n2 ? optional.get().getValueSpace().getValues().size() : n2;
                                continue;
                            }
                            bl = true;
                            n = list.indexOf(string2);
                        } while (!bl);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            this.columnHeaderNumber[0] = n;
            this.rowHeaderNumber[1] = n2;
        }
        return this.columnHeaderNumber[0];
    }

    public IType inferDataType() {
        if (this.inferedType != null) {
            return this.inferedType;
        }
        this.inferedType = Types.NO_TYPE;
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (CsvReader csvReader = new CsvReader(this.path.toString(), this.stats.delimiter.charValue());){
                int n = this.inferRowHeaders();
                do {
                    csvReader.skipLine();
                } while (--n > 0);
                if (csvReader.readRecord()) {
                    String[] stringArray = csvReader.getValues();
                    this.inferedType = this.processRecordType(Arrays.copyOfRange(stringArray, this.inferColumnHeaders(), stringArray.length));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return this.inferedType;
    }

    public Double getTotalData() {
        if (this.total != null) {
            return this.total;
        }
        if (!this.inferedType.isNumber()) {
            this.total = -1.0;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (CsvReader csvReader = new CsvReader(this.path.toString(), this.stats.delimiter.charValue());){
                int[] nArray = new int[]{this.inferRowHeaders(), this.inferColumnHeaders()};
                int[] nArray2 = new int[]{this.columnHeaderNumber[0] + this.columnHeaderNumber[1], this.rowHeaderNumber[0] + this.rowHeaderNumber[1]};
                DEBUG.OUT((Object)("Data matrix is" + STRINGS.TO_STRING((Object)nArray) + STRINGS.TO_STRING((Object)nArray2)));
                int n = nArray[0];
                do {
                    csvReader.skipLine();
                } while (--n > 0);
                int n2 = nArray2[1];
                while (n2-- > 0) {
                    String[] stringArray;
                    if (!csvReader.readRecord()) continue;
                    String[] stringArray2 = stringArray = Arrays.copyOfRange(csvReader.getValues(), nArray[1], nArray2[0]);
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string = stringArray2[n4];
                        this.total = this.total + Double.valueOf(string);
                        ++n4;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return this.total;
    }

    protected IType processRecordType(String[] stringArray) {
        IType iType = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            StringAnalysis stringAnalysis = new StringAnalysis(string);
            if (stringAnalysis.isInt) {
                if (iType == null) {
                    iType = Types.INT;
                }
            } else if (stringAnalysis.isFloat) {
                if (iType == null || iType == Types.INT) {
                    iType = Types.FLOAT;
                }
            } else {
                iType = Types.NO_TYPE;
            }
            ++n2;
        }
        if (iType == null) {
            iType = Types.NO_TYPE;
        }
        return iType;
    }

    public Path getPath() {
        return this.path;
    }

    public Character getDelimiter() {
        return this.stats.delimiter;
    }

    private static class StringAnalysis {
        boolean isFloat = true;
        boolean isInt = true;

        StringAnalysis(String string) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                boolean bl = Character.isDigit(c);
                if (!bl) {
                    if (c == '.') {
                        this.isInt = false;
                    } else {
                        if (Character.isLetter(c)) {
                            this.isInt = false;
                            this.isFloat = false;
                            break;
                        }
                        if (c == ',' || c == ';' || c == '|' || c == ':' || c == '/' || Character.isWhitespace(c)) {
                            this.isInt = false;
                            this.isFloat = false;
                        }
                    }
                }
                ++n2;
            }
            if (this.isInt && this.isFloat) {
                this.isFloat = false;
            }
        }
    }
}

