/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.utils;

import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.io.GSSurveyWrapper;
import core.metamodel.value.IValue;
import core.metamodel.value.binary.BooleanValue;
import core.metamodel.value.numeric.ContinuousValue;
import core.metamodel.value.numeric.IntegerValue;
import core.metamodel.value.numeric.RangeValue;
import core.util.data.GSEnumDataType;
import espacedev.gaml.extensions.genstar.generator.FileBasedGenerator;
import espacedev.gaml.extensions.genstar.generator.IGenstarGenerator;
import espacedev.gaml.extensions.genstar.generator.MatrixBasedGenerator;
import espacedev.gaml.extensions.genstar.generator.OldGenstarGenerator;
import espacedev.gaml.extensions.genstar.localisation.BasicSpatialLinker;
import espacedev.gaml.extensions.genstar.localisation.IGenstarLinker;
import espacedev.gaml.extensions.genstar.localisation.IGenstarLocaliser;
import espacedev.gaml.extensions.genstar.localisation.WithinGeometryLocaliser;
import espacedev.gaml.extensions.genstar.type.GamaRange;
import espacedev.gaml.extensions.genstar.utils.GenStarConstant;
import espacedev.gaml.extensions.genstar.utils.GenStarGamaSurveyUtils;
import gospl.algo.IGosplConcept;
import java.util.List;
import msi.gama.runtime.IScope;
import msi.gama.util.file.GamaCSVFile;
import msi.gaml.types.IType;

public class GenStarGamaUtils {
    private GenStarGamaUtils() {
    }

    public static GenStarConstant.SpatialDistribution toSpatialDistribution(String string) {
        if (GenStarConstant.SpatialDistribution.AREA.getMatch(string)) {
            return GenStarConstant.SpatialDistribution.AREA;
        }
        if (GenStarConstant.SpatialDistribution.CAPACITY.getMatch(string)) {
            return GenStarConstant.SpatialDistribution.CAPACITY;
        }
        if (GenStarConstant.SpatialDistribution.DENSITY.getMatch(string)) {
            return GenStarConstant.SpatialDistribution.DENSITY;
        }
        return null;
    }

    public static IGosplConcept.EGosplAlgorithm toGosplAlgorithm(String string) {
        if (GenStarConstant.GenerationAlgorithm.DIRECTSAMPLING.getMatch(string)) {
            return IGosplConcept.EGosplAlgorithm.DS;
        }
        if (GenStarConstant.GenerationAlgorithm.HIERARCHICALSAMPLING.getMatch(string)) {
            return IGosplConcept.EGosplAlgorithm.HS;
        }
        if (GenStarConstant.GenerationAlgorithm.UNIFORMSAMPLING.getMatch(string)) {
            return IGosplConcept.EGosplAlgorithm.US;
        }
        return null;
    }

    public static GSEnumDataType toDataType(IType iType, boolean bl) {
        int n = iType.id();
        switch (n) {
            case 2: {
                return GSEnumDataType.Continue;
            }
            case 1: {
                return GSEnumDataType.Integer;
            }
            case 3: {
                return GSEnumDataType.Boolean;
            }
            case 3524296: {
                return GSEnumDataType.Range;
            }
        }
        if (bl) {
            return GSEnumDataType.Order;
        }
        return GSEnumDataType.Nominal;
    }

    public static GSSurveyType toSurveyType(String string) {
        if (GenStarConstant.InputDataType.CONTINGENCY.getMatch(string)) {
            return GSSurveyType.ContingencyTable;
        }
        if (GenStarConstant.InputDataType.FREQUENCY.getMatch(string)) {
            return GSSurveyType.GlobalFrequencyTable;
        }
        if (GenStarConstant.InputDataType.LOCAL.getMatch(string)) {
            return GSSurveyType.LocalFrequencyTable;
        }
        if (GenStarConstant.InputDataType.SAMPLE.getMatch(string)) {
            return GSSurveyType.Sample;
        }
        return null;
    }

    public static GSSurveyWrapper toSurveyWrapper(IScope iScope, GamaCSVFile gamaCSVFile, List<Attribute<? extends IValue>> list) {
        GenStarGamaSurveyUtils genStarGamaSurveyUtils = null;
        genStarGamaSurveyUtils = new GenStarGamaSurveyUtils(iScope, gamaCSVFile, list);
        GSSurveyType gSSurveyType = GenStarGamaUtils.inferSurveyType(genStarGamaSurveyUtils);
        return new GSSurveyWrapper(genStarGamaSurveyUtils.getPath(), gSSurveyType, genStarGamaSurveyUtils.getDelimiter().charValue(), 1, 1);
    }

    public static GSSurveyType inferSurveyType(GenStarGamaSurveyUtils genStarGamaSurveyUtils) {
        switch (genStarGamaSurveyUtils.inferDataType().id()) {
            case 1: {
                return GSSurveyType.ContingencyTable;
            }
            case 2: {
                if (Math.abs(genStarGamaSurveyUtils.getTotalData() - 1.0) < GenStarConstant.EPSILON || Math.abs(genStarGamaSurveyUtils.getTotalData() - 100.0) < GenStarConstant.EPSILON) {
                    return GSSurveyType.GlobalFrequencyTable;
                }
                return GSSurveyType.LocalFrequencyTable;
            }
            case 0: 
            case 4: {
                return GSSurveyType.Sample;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + genStarGamaSurveyUtils.inferDataType().asPattern());
    }

    public static Object toGAMAValue(IScope iScope, IValue iValue, boolean bl) {
        GSEnumDataType gSEnumDataType = iValue.getType();
        if (bl && iValue.equals(iValue.getValueSpace().getEmptyValue())) {
            return GenStarGamaUtils.toGAMAValue(iScope, iValue.getValueSpace().getEmptyValue(), false);
        }
        if (gSEnumDataType == GSEnumDataType.Boolean) {
            return ((BooleanValue)iValue).getActualValue();
        }
        if (gSEnumDataType == GSEnumDataType.Continue) {
            if (iValue instanceof RangeValue) {
                return GenStarGamaUtils.toGAMARange(iValue);
            }
            return ((ContinuousValue)iValue).getActualValue();
        }
        if (gSEnumDataType == GSEnumDataType.Integer) {
            if (iValue instanceof RangeValue) {
                return GenStarGamaUtils.toGAMARange(iValue);
            }
            return ((IntegerValue)iValue).getActualValue();
        }
        if (gSEnumDataType == GSEnumDataType.Range) {
            return GenStarGamaUtils.toGAMARange(iValue);
        }
        return iValue.getStringValue();
    }

    static GamaRange toGAMARange(IValue iValue) {
        RangeValue rangeValue = (RangeValue)iValue;
        return new GamaRange(rangeValue.getBottomBound().doubleValue(), rangeValue.getTopBound().doubleValue());
    }

    public static Object toGAMAValue(IScope iScope, IValue iValue, boolean bl, IType iType) {
        Object object;
        Object object2 = GenStarGamaUtils.toGAMAValue(iScope, iValue, bl);
        if (iType != null && (object = object2) instanceof GamaRange) {
            GamaRange gamaRange = (GamaRange)object;
            GamaRange cfr_ignored_0 = (GamaRange)object;
            return gamaRange.cast(iScope, iType);
        }
        return object2;
    }

    public static IGenstarGenerator[] getGamaGenerator() {
        return new IGenstarGenerator[]{FileBasedGenerator.getInstance(), MatrixBasedGenerator.getInstance(), OldGenstarGenerator.getInstance()};
    }

    public static IGenstarLocaliser[] getGamaLocaliser() {
        return new IGenstarLocaliser[]{WithinGeometryLocaliser.getInstance()};
    }

    public static IGenstarLinker[] getGamaLinker() {
        return new IGenstarLinker[]{BasicSpatialLinker.getInstance()};
    }
}

