/*
 * Decompiled with CFR 0.152.
 */
package gospl;

import com.google.common.collect.Streams;
import core.metamodel.IMultitypePopulation;
import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.entity.EntityUniqueId;
import core.metamodel.entity.IEntity;
import core.metamodel.value.IValue;
import core.util.exception.GenstarException;
import gospl.GosplSubPopulation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GosplMultitypePopulation<E extends ADemoEntity>
implements IMultitypePopulation<E, Attribute<? extends IValue>> {
    public static final String LAYER_ID = "Layer_";
    protected final Map<String, Integer> typeToLevel = new HashMap<String, Integer>();
    protected final Map<String, Set<E>> type2agents = new HashMap<String, Set<E>>();
    protected final Map<String, Set<Attribute<? extends IValue>>> type2attributes = new HashMap<String, Set<Attribute<? extends IValue>>>();
    private int size = 0;

    public GosplMultitypePopulation(String string, IPopulation<E, Attribute<? extends IValue>> iPopulation) {
        this.addAll(string, iPopulation);
    }

    public GosplMultitypePopulation(String ... stringArray) {
        int n = 0;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            this.type2agents.put(string, new HashSet());
            this.typeToLevel.put(string, n++);
            this.type2attributes.put(string, new HashSet());
            ++n3;
        }
    }

    public GosplMultitypePopulation(List<String> list) {
        for (String string : list) {
            this.type2agents.put(string, new HashSet());
            this.typeToLevel.put(string, list.indexOf(string));
            this.type2attributes.put(string, new HashSet());
        }
    }

    public static <E extends ADemoEntity> GosplMultitypePopulation<E> getMultiPopulation(Collection<E> list, boolean bl) {
        GosplMultitypePopulation<E> gosplMultitypePopulation2;
        List list2;
        List list3;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl2 = list.stream().anyMatch(ADemoEntity::hasChildren);
        if (bl2) {
            list3 = list;
            while (bl2) {
                list3 = (List)((Object)list3.stream().flatMap(aDemoEntity -> aDemoEntity.getChildren().stream()).map(iEntity -> (ADemoEntity)iEntity).collect(Collectors.toSet()));
                arrayList.add(list3);
                bl2 = list3.stream().anyMatch(ADemoEntity::hasChildren);
            }
        }
        list3 = new ArrayList();
        boolean bl3 = list.stream().anyMatch(ADemoEntity::hasParent);
        if (bl3) {
            list2 = list;
            while (bl3) {
                list2 = list2.stream().map(aDemoEntity -> (ADemoEntity)aDemoEntity.getParent()).collect(Collectors.toSet());
                arrayList.add(list2);
                bl3 = list2.stream().anyMatch(ADemoEntity::hasParent);
            }
        }
        list2 = Streams.concat((Stream[])new Stream[]{arrayList.stream(), Stream.of(list), list3.stream()}).toList();
        for (GosplMultitypePopulation<E> gosplMultitypePopulation2 : list2) {
            Set set = gosplMultitypePopulation2.stream().map(ADemoEntity::getEntityType).collect(Collectors.toSet());
            if (set.isEmpty() || set.size() != 1) {
                arrayList2.add(LAYER_ID + list2.indexOf(gosplMultitypePopulation2));
                continue;
            }
            arrayList2.add((String)set.iterator().next());
        }
        gosplMultitypePopulation2 = new GosplMultitypePopulation<E>(arrayList2);
        int n = 0;
        while (n < arrayList2.size()) {
            gosplMultitypePopulation2.addAll((String)arrayList2.get(n), ((Collection)list2.get(n)).stream().map(aDemoEntity -> bl ? aDemoEntity.clone() : aDemoEntity).collect(Collectors.toSet()));
            ++n;
        }
        return gosplMultitypePopulation2;
    }

    protected GosplMultitypePopulation(List<String> list, Map<String, IPopulation<E, Attribute<? extends IValue>>> map) {
        for (String string : list) {
            this.addAll(string, (Collection)map.get(string));
        }
    }

    protected void recomputeSize() {
        this.size = 0;
        for (Set<E> set : this.type2agents.values()) {
            this.size += set.size();
        }
    }

    protected Set<E> getSetForType(String string) {
        Set<E> set = this.type2agents.get(string);
        if (set == null) {
            set = new HashSet();
            if (this.typeToLevel.isEmpty()) {
                this.typeToLevel.put(string, 0);
            } else {
                this.typeToLevel.put(string, Collections.max(this.typeToLevel.values()) + 1);
            }
            this.type2agents.put(string, set);
        }
        return set;
    }

    protected Set<Attribute<? extends IValue>> getAttributesForType(String string) {
        Set<Attribute<? extends IValue>> set = this.type2attributes.get(string);
        if (set == null) {
            set = new HashSet<Attribute<? extends IValue>>();
            this.type2attributes.put(string, set);
        }
        return set;
    }

    @Override
    public Set<Attribute<? extends IValue>> getPopulationAttributes() {
        return this.type2attributes.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public boolean add(E e) {
        if (!((ADemoEntity)e).hasEntityType()) {
            throw new GenstarException("the population entity should be given an entity type");
        }
        if (!this.getSetForType(((ADemoEntity)e).getEntityType()).add(e)) {
            return false;
        }
        this.type2attributes.get(((ADemoEntity)e).getEntityType()).addAll(((ADemoEntity)e).getAttributes());
        ((ADemoEntity)e)._setEntityId(EntityUniqueId.createNextId(this, ((ADemoEntity)e).getEntityType()));
        ++this.size;
        for (IEntity<? extends IAttribute<? extends IValue>> iEntity : ((ADemoEntity)e).getChildren()) {
            ADemoEntity aDemoEntity = (ADemoEntity)iEntity;
            this.add((E)aDemoEntity);
        }
        return true;
    }

    @Override
    public boolean add(String string, E e) {
        System.err.println("addedinf it multitype pop entity with forced type " + string);
        ((ADemoEntity)e).setEntityType(string);
        if (this.getSetForType(string).add(e)) {
            ++this.size;
            ((ADemoEntity)e)._setEntityId(EntityUniqueId.createNextId(this, string));
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (ADemoEntity aDemoEntity : collection) {
            boolean bl2 = bl = this.add((E)aDemoEntity) || bl;
        }
        if (bl) {
            this.recomputeSize();
        }
        return bl;
    }

    @Override
    public boolean addAll(String string, Collection<? extends E> collection) {
        Set<Attribute<? extends IValue>> set3;
        for (ADemoEntity aDemoEntity2 : collection) {
            aDemoEntity2.setEntityType(string);
        }
        boolean bl = false;
        Set<E> set2 = this.getSetForType(string);
        for (Set<Attribute<? extends IValue>> set3 : collection) {
            if (!set2.add(set3)) continue;
            bl = true;
            ((ADemoEntity)((Object)set3))._setEntityId(EntityUniqueId.createNextId(this, string));
            ++this.size;
        }
        set3 = this.type2attributes.get(string);
        if (set3 == null) {
            set3 = new HashSet();
            this.type2attributes.put(string, set3);
        }
        set3.addAll(collection.stream().flatMap(aDemoEntity -> aDemoEntity.getAttributes().stream()).collect(Collectors.toSet()));
        return bl;
    }

    @Override
    public void clear() {
        for (Set<E> set : this.type2agents.values()) {
            set.clear();
        }
        this.size = 0;
    }

    @Override
    public boolean contains(Object object) {
        for (Set<E> set : this.type2agents.values()) {
            if (!set.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        HashSet<E> hashSet = new HashSet<E>(collection);
        for (Set<E> set : this.type2agents.values()) {
            hashSet.removeAll(set);
        }
        return hashSet.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorMultipleSets(this.type2agents.values());
    }

    @Override
    public boolean remove(Object object) {
        for (Set<E> set : this.type2agents.values()) {
            if (!set.remove(object)) continue;
            --this.size;
            Collection collection = Stream.of((ADemoEntity)object).collect(Collectors.toSet());
            boolean bl = false;
            while (collection.stream().anyMatch(ADemoEntity::hasChildren)) {
                bl = false;
                collection = collection.stream().flatMap(aDemoEntity -> aDemoEntity.getChildren().stream()).map(iEntity -> (ADemoEntity)iEntity).collect(Collectors.toSet());
                for (Set<E> set2 : this.type2agents.values()) {
                    if (!set2.removeAll(collection)) continue;
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Set<E> set : this.type2agents.values()) {
            boolean bl2 = bl = set.removeAll(collection) || bl;
        }
        if (bl) {
            this.recomputeSize();
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (Set<E> set : this.type2agents.values()) {
            boolean bl2 = bl = set.retainAll(collection) || bl;
        }
        if (bl) {
            this.recomputeSize();
        }
        return bl;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n = 0;
        for (Set<E> set : this.type2agents.values()) {
            for (ADemoEntity aDemoEntity : set) {
                objectArray[n++] = aDemoEntity;
            }
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = 0;
        for (Set<E> set : this.type2agents.values()) {
            for (ADemoEntity aDemoEntity : set) {
                TArray[n++] = aDemoEntity;
            }
        }
        return TArray;
    }

    @Override
    public Set<String> getEntityTypes() {
        return this.type2agents.keySet();
    }

    @Override
    public int getEntityLevel(String string) {
        return this.typeToLevel.get(string);
    }

    @Override
    public List<Integer> getEntityLevel() {
        return new ArrayList<Integer>(this.typeToLevel.values());
    }

    @Override
    public String getEntityType(int n) {
        return this.typeToLevel.keySet().stream().filter(string -> this.typeToLevel.get(string) == n).findFirst().orElseThrow(NullPointerException::new);
    }

    @Override
    public void addEntityType(String string) {
        if (!this.type2agents.containsKey(string)) {
            this.type2agents.put(string, new HashSet());
        }
    }

    @Override
    public IPopulation<E, Attribute<? extends IValue>> getSubPopulation(String string) {
        if (!this.type2agents.containsKey(string)) {
            throw new GenstarException("unknown type " + string);
        }
        return new GosplSubPopulation(this, string);
    }

    @Override
    public IPopulation<E, Attribute<? extends IValue>> getSubPopulation(int n) {
        return this.getSubPopulation(this.getEntityType(n));
    }

    public int getSubPopulationSize(int n) {
        return this.getSetForType(this.getEntityType(n)).size();
    }

    @Override
    public void clear(String string) {
        this.getSetForType(string).clear();
        this.recomputeSize();
    }

    @Override
    public GosplMultitypePopulation<E> clone() {
        GosplMultitypePopulation<E> gosplMultitypePopulation = new GosplMultitypePopulation<E>(this.typeToLevel.values().stream().sorted().map(this::getEntityType).toList());
        gosplMultitypePopulation.type2attributes.putAll(this.type2attributes);
        gosplMultitypePopulation.type2agents.putAll(this.type2agents);
        gosplMultitypePopulation.recomputeSize();
        return gosplMultitypePopulation;
    }

    @Override
    public Iterator<E> iterateSubPopulation(String string) {
        try {
            return this.type2agents.get(string).iterator();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("no entity of type " + string + " in this " + this.getClass().getSimpleName());
        }
    }

    @Override
    public boolean isAllPopulationOfType(String string) {
        return this.type2agents.size() == 1 && this.type2agents.get(string) != null;
    }

    @Override
    public Attribute<? extends IValue> getPopulationAttributeNamed(String string) {
        for (Set<Attribute<? extends IValue>> set : this.type2attributes.values()) {
            for (Attribute<? extends IValue> attribute : set) {
                if (!attribute.getAttributeName().equals(string)) continue;
                return attribute;
            }
        }
        return null;
    }

    private static class IteratorMultipleSets<ET>
    implements Iterator<ET> {
        private final List<Set<ET>> sets;
        private final Iterator<Set<ET>> itList;
        private Iterator<ET> itCurrentSet;

        protected IteratorMultipleSets(Collection<Set<ET>> collection) {
            this.sets = new LinkedList<Set<ET>>(collection);
            this.itList = this.sets.iterator();
            try {
                this.itCurrentSet = this.itList.next().iterator();
            }
            catch (NullPointerException nullPointerException) {
                this.itCurrentSet = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.itCurrentSet != null && (this.itCurrentSet.hasNext() || this.itList.hasNext());
        }

        @Override
        public ET next() {
            if (!this.itCurrentSet.hasNext()) {
                if (!this.itList.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.itCurrentSet = this.itList.next().iterator();
            }
            return this.itCurrentSet.next();
        }
    }
}

