/*
 * Decompiled with CFR 0.152.
 */
package gospl;

import core.metamodel.IPopulation;
import core.metamodel.IQueryablePopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.entity.EntityUniqueId;
import core.metamodel.value.IValue;
import core.metamodel.value.binary.BinarySpace;
import core.metamodel.value.binary.BooleanValue;
import core.util.data.GSEnumDataType;
import core.util.exception.GenstarException;
import gospl.GosplEntity;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import ummisco.gama.dev.utils.DEBUG;

public class GosplPopulationInDatabase
implements IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> {
    public static final int VARCHAR_SIZE = 255;
    public static final int MAX_BUFFER_QRY = 10000;
    public static final String DEFAULT_ENTITY_TYPE = "unknown";
    public static final int REMOVE_ENTITIES_BATCH = 500;
    public static final int ADD_ENTITIES_BATCH = 5000;
    private final Connection connection;
    private final Map<String, String> entityType2tableName = new HashMap<String, String>();
    private final Map<String, Map<Attribute<? extends IValue>, String>> entityType2attribute2colName = new HashMap<String, Map<Attribute<? extends IValue>, String>>();
    private final Map<String, Set<Attribute<? extends IValue>>> entityType2attributes = new HashMap<String, Set<Attribute<? extends IValue>>>();
    private static int currentInstanceCount = 0;
    private static final String mySqlDBname = "IPopulation_" + ++currentInstanceCount;
    private final Map<String, Set<String>> table2createdIndex = new HashMap<String, Set<String>>();

    public GosplPopulationInDatabase(Connection connection, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        this.connection = connection;
        this.loadPopulationIntoDatabase(iPopulation);
    }

    public GosplPopulationInDatabase() {
        try {
            this.connection = DriverManager.getConnection("jdbc:hsqldb:mem:" + mySqlDBname + ";shutdown=true", "SA", "");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("error while trying to initialize the HDSQL database engine in memory: " + sQLException.getMessage(), sQLException);
        }
    }

    public GosplPopulationInDatabase(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        try {
            this.connection = DriverManager.getConnection("jdbc:hsqldb:mem:" + mySqlDBname + ";shutdown=true", "SA", "");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("error while trying to initialize the HDSQL database engine in memory: " + sQLException.getMessage(), sQLException);
        }
        this.loadPopulationIntoDatabase(iPopulation);
    }

    public GosplPopulationInDatabase(File file, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        try {
            this.connection = DriverManager.getConnection("jdbc:hsqldb:file:" + file.getPath() + ";create=true;shutdown=true;", "SA", "");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("error while trying to initialize the HDSQL database engine in file " + file + ": " + sQLException.getMessage(), sQLException);
        }
        this.loadPopulationIntoDatabase(iPopulation);
    }

    public GosplPopulationInDatabase(URL uRL, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver");
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)"ERROR: failed to load HSQLDB JDBC driver.");
            exception.printStackTrace();
            throw new GenstarException("error while trying to load the JDBC driver to load the HSQL database", exception);
        }
        try {
            this.connection = DriverManager.getConnection("jdbc:hsqldb:" + uRL + ";shutdown=true", "SA", "");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("error while trying to initialize the HDSQL database engine in file " + uRL + ": " + sQLException.getMessage(), sQLException);
        }
        this.loadPopulationIntoDatabase(iPopulation);
    }

    protected String getTableNameForEntityType(String string) {
        this.entityType2tableName.putIfAbsent(string, "entities_" + string);
        return this.entityType2tableName.get(string);
    }

    protected String getAttributeColNameForType(String string, Attribute<? extends IValue> attribute) {
        String string2;
        Map<Attribute<? extends IValue>, String> map = this.entityType2attribute2colName.get(string);
        if (map == null) {
            map = new HashMap<Attribute<? extends IValue>, String>();
            this.entityType2attribute2colName.put(string, map);
        }
        if ((string2 = map.get(attribute)) == null) {
            string2 = attribute.getAttributeName().replaceAll("(\\W|^_)*", "");
            map.put(attribute, string2);
        }
        return string2;
    }

    protected String getSQLTypeForAttribute(Attribute<? extends IValue> attribute) {
        return switch (attribute.getValueSpace().getType()) {
            case GSEnumDataType.Integer -> "INTEGER";
            case GSEnumDataType.Continue -> "DOUBLE";
            case GSEnumDataType.Range, GSEnumDataType.Order, GSEnumDataType.Nominal -> "VARCHAR(255)";
            case GSEnumDataType.Boolean -> "BOOLEAN";
            default -> throw new GenstarException("this attribute type is not managed: " + (Object)((Object)attribute.getValueSpace().getType()));
        };
    }

    protected void createTableForEntityType(String string) throws SQLException {
        Statement throwable3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE TABLE ").append(this.getTableNameForEntityType(string)).append(" (");
        stringBuilder.append("id VARCHAR(50) PRIMARY KEY");
        for (Attribute<? extends IValue> object2 : this.entityType2attributes.get(string)) {
            stringBuilder.append(", ");
            stringBuilder.append(this.getAttributeColNameForType(string, object2));
            stringBuilder.append(" ");
            stringBuilder.append(this.getSQLTypeForAttribute(object2));
            stringBuilder.append(" ");
        }
        stringBuilder.append(")");
        String string2 = stringBuilder.toString();
        DEBUG.LOG((Object)("creating table for type {} with SQL query:  " + string + "," + string2));
        HashSet<String> hashSet = null;
        Throwable throwable2 = null;
        try {
            throwable3 = this.connection.createStatement();
            try {
                throwable3.execute(string2);
            }
            finally {
                if (throwable3 != null) {
                    throwable3.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (hashSet == null) {
                hashSet = throwable;
            } else if (hashSet != throwable) {
                ((Throwable)((Object)hashSet)).addSuppressed(throwable);
            }
            throw hashSet;
        }
        hashSet = new HashSet<String>();
        this.table2createdIndex.put(this.getTableNameForEntityType(string), hashSet);
        throwable2 = null;
        throwable3 = null;
        try (Statement statement = this.connection.createStatement();){
            for (Attribute<? extends IValue> attribute : this.entityType2attributes.get(string)) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("CREATE INDEX idx_").append(this.getTableNameForEntityType(string)).append("_").append(this.getAttributeColNameForType(string, attribute));
                stringBuilder.append(" ON ");
                stringBuilder.append(this.getTableNameForEntityType(string));
                stringBuilder.append(" (");
                stringBuilder.append(this.getAttributeColNameForType(string, attribute));
                stringBuilder.append(")");
                statement.execute(stringBuilder.toString());
                hashSet.add(this.getAttributeColNameForType(string, attribute));
            }
        }
        catch (Throwable throwable) {
            if (throwable2 == null) {
                throwable2 = throwable;
            } else if (throwable2 != throwable) {
                throwable2.addSuppressed(throwable);
            }
            throw throwable2;
        }
    }

    protected void createInitialTables() throws SQLException {
        for (String string : this.entityType2attributes.keySet()) {
            this.createTableForEntityType(string);
        }
    }

    protected void loadPopulationIntoDatabase(IPopulation<? extends ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        assert (this.connection != null);
        assert (iPopulation != null);
        String string = DEFAULT_ENTITY_TYPE;
        this.entityType2attributes.put(string, new HashSet<Attribute<? extends IValue>>(iPopulation.getPopulationAttributes()));
        try {
            this.createInitialTables();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("error creating the tables to store the population in database: " + sQLException.getMessage(), sQLException);
        }
        try {
            this.storeEntities(string, iPopulation);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("error while inserting the population in database: " + sQLException.getMessage(), sQLException);
        }
    }

    private String getSQLValueFor(ADemoEntity aDemoEntity, Attribute<? extends IValue> attribute) {
        IValue iValue = aDemoEntity.getValueForAttribute(attribute);
        return switch (attribute.getValueSpace().getType()) {
            case GSEnumDataType.Continue, GSEnumDataType.Integer -> iValue.getStringValue();
            case GSEnumDataType.Range, GSEnumDataType.Order, GSEnumDataType.Nominal -> "'" + iValue.getStringValue() + "'";
            case GSEnumDataType.Boolean -> {
                if (((BooleanValue)iValue).getActualValue().booleanValue()) {
                    yield "TRUE";
                }
                yield "FALSE";
            }
            default -> throw new GenstarException("unknown value type " + (Object)((Object)attribute.getValueSpace().getType()));
        };
    }

    protected IValue readValueForAttribute(String string, Attribute<? extends IValue> attribute, ResultSet resultSet) throws SQLException {
        String string2 = this.getAttributeColNameForType(string, attribute);
        switch (attribute.getValueSpace().getType()) {
            case Integer: {
                int n = resultSet.getInt(string2);
                return attribute.getValueSpace().getValue(Integer.toString(n));
            }
            case Continue: {
                double d = resultSet.getDouble(string2);
                return attribute.getValueSpace().getValue(Double.toString(d));
            }
            case Range: 
            case Order: 
            case Nominal: {
                String string3 = resultSet.getString(string2);
                return attribute.getValueSpace().getValue(string3);
            }
            case Boolean: {
                if (resultSet.getBoolean(string2)) {
                    return ((BinarySpace)attribute.getValueSpace()).valueTrue;
                }
                return ((BinarySpace)attribute.getValueSpace()).valueFalse;
            }
        }
        throw new GenstarException("unknown entity type " + (Object)((Object)attribute.getValueSpace().getType()));
    }

    protected int storeEntities(String string, Collection<? extends ADemoEntity> collection) throws SQLException {
        Object object;
        Statement throwable4;
        Throwable throwable3;
        Object object2;
        Object throwable52;
        Object object422;
        if (!this.entityType2tableName.containsKey(string)) {
            this.createTableForEntityType(string);
        }
        int n = 0;
        LinkedList linkedList = new LinkedList(this.entityType2attributes.get(string));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ").append(this.getTableNameForEntityType(string));
        stringBuilder.append(" m (id");
        for (Object object422 : linkedList) {
            stringBuilder.append(",");
            stringBuilder.append(this.getAttributeColNameForType(string, (Attribute<? extends IValue>)object422));
        }
        stringBuilder.append(") VALUES (");
        object422 = stringBuilder.toString();
        boolean bl = true;
        for (ADemoEntity object5 : collection) {
            if (stringBuilder.length() >= 10000) {
                stringBuilder.append(")");
                throwable52 = stringBuilder.toString();
                DEBUG.LOG((Object)("adding entities with query " + (String)throwable52));
                object2 = null;
                throwable3 = null;
                try {
                    throwable4 = this.connection.createStatement();
                    try {
                        throwable4.executeQuery((String)throwable52);
                        object = null;
                        Object throwable2 = null;
                        try (ResultSet resultSet = throwable4.executeQuery("CALL DIAGNOSTICS ( ROW_COUNT )");){
                            resultSet.next();
                            n += resultSet.getInt(1);
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            throw object;
                        }
                    }
                    finally {
                        if (throwable4 != null) {
                            throwable4.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (object2 == null) {
                        object2 = throwable;
                    } else if (object2 != throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                    throw object2;
                }
                bl = true;
                stringBuilder = new StringBuilder((String)object422);
            }
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("('");
            stringBuilder.append(object5.getEntityId());
            stringBuilder.append("'");
            for (Object throwable52 : linkedList) {
                stringBuilder.append(",");
                stringBuilder.append(this.getSQLValueFor(object5, (Attribute<? extends IValue>)throwable52));
            }
            stringBuilder.append(")");
        }
        if (stringBuilder.length() > ((String)object422).length()) {
            stringBuilder.append(")");
            String string2 = stringBuilder.toString();
            DEBUG.LOG((Object)("adding last entities with query " + string2));
            Object object6 = null;
            throwable52 = null;
            try {
                object2 = this.connection.createStatement();
                try {
                    object2.executeQuery(string2);
                    throwable3 = null;
                    throwable4 = null;
                    try {
                        object = object2.executeQuery("CALL DIAGNOSTICS ( ROW_COUNT )");
                        try {
                            object.next();
                            n += object.getInt(1);
                        }
                        finally {
                            if (object != null) {
                                object.close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (throwable3 == null) {
                            throwable3 = throwable;
                        } else if (throwable3 != throwable) {
                            throwable3.addSuppressed(throwable);
                        }
                        throw throwable3;
                    }
                }
                finally {
                    if (object2 != null) {
                        object2.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (object6 == null) {
                    object6 = throwable;
                } else if (object6 != throwable) {
                    ((Throwable)object6).addSuppressed(throwable);
                }
                throw object6;
            }
        }
        return n;
    }

    @Override
    public boolean add(ADemoEntity aDemoEntity) {
        block20: {
            Object object2;
            String string = aDemoEntity.getEntityType();
            if (string == null) {
                string = DEFAULT_ENTITY_TYPE;
            }
            if (!this.entityType2attributes.containsKey(string)) {
                this.entityType2attributes.put(string, new HashSet<Attribute<? extends IValue>>(aDemoEntity.getAttributes()));
            }
            if (!this.entityType2tableName.containsKey(string)) {
                try {
                    this.createTableForEntityType(string);
                }
                catch (SQLException sQLException) {
                    throw new GenstarException("error while creating table for type " + string);
                }
            }
            LinkedList linkedList = new LinkedList(this.entityType2attributes.get(string));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("INSERT INTO ").append(this.getTableNameForEntityType(string));
            stringBuilder.append(" (id");
            for (Object object2 : linkedList) {
                stringBuilder.append(",");
                stringBuilder.append(this.getAttributeColNameForType(string, (Attribute<? extends IValue>)object2));
            }
            stringBuilder.append(") VALUES");
            stringBuilder.append("('");
            stringBuilder.append(aDemoEntity.getEntityId());
            stringBuilder.append("'");
            for (Object object2 : linkedList) {
                stringBuilder.append(",");
                stringBuilder.append(this.getSQLValueFor(aDemoEntity, (Attribute<? extends IValue>)object2));
            }
            stringBuilder.append(")");
            object2 = null;
            Iterator iterator = null;
            Statement statement = this.connection.createStatement();
            try {
                statement.executeQuery(stringBuilder.toString());
                if (statement == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (object2 == null) {
                            object2 = throwable2;
                        } else if (object2 != throwable2) {
                            ((Throwable)object2).addSuppressed(throwable2);
                        }
                        throw object2;
                    }
                }
                catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
                    return false;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    throw new GenstarException("error while adding entity " + aDemoEntity, sQLException);
                }
            }
            statement.close();
        }
        return true;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public boolean addAll(Collection<? extends ADemoEntity> var1_1) {
        var2_2 = 0;
        var3_3 = new HashMap<Object, ArrayList<Object>>();
        try {
            for (Object var4_5 : var1_1) {
                block17: {
                    var6_7 = var4_5.getEntityType();
                    if (var6_7 == null) {
                        var6_7 = "unknown";
                    }
                    if (!var4_5._hasEntityId()) {
                        var4_5._setEntityId(EntityUniqueId.createNextId(this, (String)var6_7));
                    }
                    DEBUG.OUT((Object)("should add entity id: " + var4_5.getEntityId()));
                    if (!this.entityType2attributes.containsKey(var6_7)) {
                        this.entityType2attributes.put((String)var6_7, new HashSet<Attribute<? extends IValue>>(var4_5.getAttributes()));
                    }
                    if (!this.entityType2tableName.containsKey(var6_7)) {
                        try {
                            this.createTableForEntityType((String)var6_7);
                        }
                        catch (SQLException v0) {
                            throw new GenstarException("error while creating table for type " + (String)var6_7);
                        }
                    }
                    if ((var7_8 = (List)var3_3.get(var6_7)) == null) {
                        var7_8 = new ArrayList<Object>(5000);
                        var3_3.put(var6_7, var7_8);
                    }
                    var7_8.add(var4_5);
                    if (var7_8.size() < 5000) continue;
                    try {
                        var2_2 += this.storeEntities((String)var6_7, var7_8);
                        break block17;
                    }
                    catch (SQLIntegrityConstraintViolationException v1) {
                        DEBUG.ERR((Object)"some of these agents already existed; switching to add 1 by 1");
                        ** for (var8_9 : var7_8)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (!this.add(var8_9)) continue;
                        ++var2_2;
                        continue;
                    }
                }
                var7_8.clear();
            }
            block10: for (Object var4_5 : var3_3.keySet()) {
                try {
                    var2_2 += this.storeEntities((String)var4_5, (Collection)var3_3.get(var4_5));
                    continue;
                }
                catch (SQLIntegrityConstraintViolationException v2) {
                    DEBUG.ERR((Object)"some of these agents already existed; switching to add 1 by 1");
                    ** for (var6_7 : (List)var3_3.get((Object)var4_5))
                }
lbl-1000:
                // 1 sources

                {
                    if (!this.add((ADemoEntity)var6_7)) continue;
                    ++var2_2;
                    continue;
lbl49:
                    // 1 sources

                }
            }
        }
        catch (SQLException var4_6) {
            var4_6.printStackTrace();
            throw new GenstarException("error while adding entities", var4_6);
        }
        return var2_2 > 0;
    }

    @Override
    public void clear() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Statement statement = this.connection.createStatement();){
                for (String string : this.entityType2tableName.values()) {
                    statement.executeQuery("TRUNCATE TABLE " + string);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("error while dropping the table containing the entities", sQLException);
        }
    }

    @Override
    public GosplPopulationInDatabase clone() {
        throw new UnsupportedOperationException("Not yet coded");
    }

    @Override
    public boolean contains(Object object) {
        Object object2 = object;
        if (object2 instanceof ADemoEntity) {
            String string;
            ADemoEntity aDemoEntity = (ADemoEntity)object2;
            ADemoEntity cfr_ignored_0 = (ADemoEntity)object2;
            String string2 = aDemoEntity.getEntityType();
            if (string2 == null) {
                string2 = DEFAULT_ENTITY_TYPE;
            }
            if ((string = this.entityType2tableName.get(string2)) == null) {
                return false;
            }
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (Statement statement = this.connection.createStatement();){
                    ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + string + " WHERE id='" + aDemoEntity.getEntityId() + "'");
                    resultSet.next();
                    Integer n = resultSet.getInt(1);
                    boolean bl = n > 0;
                    return bl;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new GenstarException("Unable to search for entity " + object, sQLException);
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new NotImplementedException("Not yet implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEmpty() {
        if (this.entityType2tableName.isEmpty()) {
            return true;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Statement statement = this.connection.createStatement(1004, 1007);){
                String string;
                ResultSet resultSet;
                Iterator<String> iterator = this.entityType2tableName.values().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while ((resultSet = statement.executeQuery("SELECT * FROM " + (string = iterator.next()) + " LIMIT 1")).next());
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("Error while checking if the table is empty", sQLException);
        }
    }

    private ADemoEntity createEntity(ResultSet resultSet, String string, Set<Attribute<? extends IValue>> set) throws SQLException {
        HashMap<Attribute<? extends IValue>, IValue> hashMap = new HashMap<Attribute<? extends IValue>, IValue>();
        String string2 = resultSet.getString("id");
        for (Attribute<? extends IValue> object2 : set) {
            hashMap.put(object2, this.readValueForAttribute(string, object2, resultSet));
        }
        resultSet.next();
        GosplEntity gosplEntity = new GosplEntity(hashMap);
        gosplEntity._setEntityId(string2);
        gosplEntity.setEntityType(string);
        return gosplEntity;
    }

    @Override
    public Iterator<ADemoEntity> iterator() {
        return new AllTypesIterator(this.connection, this.entityType2tableName, this.entityType2attributes);
    }

    public Iterator<ADemoEntity> iterator(String string) {
        return new DatabaseEntitiesIterator(this.connection, this.entityType2attributes.get(string), string);
    }

    @Override
    public boolean remove(Object object) {
        ADemoEntity aDemoEntity;
        block14: {
            try {
                aDemoEntity = (ADemoEntity)object;
                if (this.entityType2tableName.containsKey(aDemoEntity.getEntityType()) && aDemoEntity._hasEntityId()) break block14;
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Statement statement = this.connection.createStatement();){
                statement.executeQuery("DELETE FROM " + this.getTableNameForEntityType(aDemoEntity.getEntityType()) + " WHERE id='" + aDemoEntity.getEntityId() + "'");
                ResultSet resultSet = statement.executeQuery("CALL DIAGNOSTICS ( ROW_COUNT )");
                resultSet.next();
                boolean bl = resultSet.getInt(1) > 0;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("SQL error while deleting the entity " + aDemoEntity, sQLException);
        }
    }

    protected void createIdsClause(StringBuilder stringBuilder, Collection<String> collection) {
        stringBuilder.append("IN (");
        boolean bl = true;
        for (String string : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("'").append(string).append("'");
        }
        stringBuilder.append(")");
    }

    protected int deleteIds(String string, Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ").append(this.getTableNameForEntityType(string)).append(" WHERE id ");
        this.createIdsClause(stringBuilder, collection);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Statement statement = this.connection.createStatement();){
                statement.executeQuery(stringBuilder.toString());
                ResultSet resultSet = statement.executeQuery("CALL DIAGNOSTICS ( ROW_COUNT )");
                resultSet.next();
                return resultSet.getInt(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("SQL error while deleting the entities " + sQLException, sQLException);
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        for (Object object : collection) {
            ADemoEntity aDemoEntity = null;
            try {
                aDemoEntity = (ADemoEntity)object;
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (!aDemoEntity._hasEntityId()) continue;
            String string = aDemoEntity.getEntityType();
            if (string == null) {
                string = DEFAULT_ENTITY_TYPE;
            }
            if (!this.entityType2tableName.containsKey(string)) continue;
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>(500);
                hashMap.put(string, arrayList);
            }
            arrayList.add(aDemoEntity.getEntityId());
            if (arrayList.size() < 500) continue;
            bl = this.deleteIds(string, arrayList) > 0 || bl;
            arrayList.clear();
        }
        for (Object object : hashMap.keySet()) {
            boolean bl2 = bl = this.deleteIds((String)object, (Collection)hashMap.get(object)) > 0 || bl;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new NotImplementedException("cannot retain all for all the types");
    }

    @Override
    public int size() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Statement statement = this.connection.createStatement();){
                int n = 0;
                DEBUG.OUT((Object)"in size");
                for (String string : this.entityType2tableName.values()) {
                    ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) as TOTAL FROM " + string + ";");
                    resultSet.next();
                    n += resultSet.getInt("TOTAL");
                }
                return n;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException("Error while counting entities", sQLException);
        }
    }

    @Override
    public Object[] toArray() {
        throw new NotImplementedException("no array feature for this");
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        throw new NotImplementedException("no array feature for this");
    }

    @Override
    public Set<Attribute<? extends IValue>> getPopulationAttributes() {
        return this.entityType2attributes.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public boolean isAllPopulationOfType(String string) {
        return this.entityType2tableName.size() == 1 && this.entityType2tableName.containsKey(string);
    }

    @Override
    public Attribute<? extends IValue> getPopulationAttributeNamed(String string) {
        Set<Attribute<? extends IValue>> set = this.getPopulationAttributes();
        if (set == null) {
            return null;
        }
        for (Attribute<? extends IValue> attribute : set) {
            if (!attribute.getAttributeName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        if (this.connection != null) {
            this.connection.close();
        }
        super.finalize();
    }

    @Override
    public int getCountHavingValues(Attribute<? extends IValue> attribute, IValue ... iValueArray) {
        int n = 0;
        for (String string : this.entityType2tableName.keySet()) {
            if (!this.entityType2attributes.get(string).contains(attribute)) continue;
            try {
                n += this.getEntitiesHavingValues(string, attribute, iValueArray);
            }
            catch (SQLException sQLException) {
                throw new GenstarException("error while counting entities of type " + string, sQLException);
            }
        }
        return n;
    }

    protected void addWhereClauseForAttribute(StringBuilder stringBuilder, String string, Attribute<? extends IValue> attribute, IValue ... iValueArray) {
        boolean bl = true;
        switch (attribute.getValueSpace().getType()) {
            case Continue: 
            case Integer: {
                IValue[] iValueArray2 = iValueArray;
                int n = iValueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IValue iValue = iValueArray2[n2];
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(" OR ");
                    }
                    stringBuilder.append(this.getAttributeColNameForType(string, attribute));
                    stringBuilder.append("=");
                    stringBuilder.append(iValue.getActualValue().toString());
                    ++n2;
                }
                break;
            }
            case Range: 
            case Order: 
            case Nominal: {
                IValue[] iValueArray3 = iValueArray;
                int n = iValueArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IValue iValue = iValueArray3[n3];
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(" OR ");
                    }
                    stringBuilder.append(this.getAttributeColNameForType(string, attribute));
                    stringBuilder.append("='");
                    stringBuilder.append(iValue.getActualValue().toString());
                    stringBuilder.append("'");
                    ++n3;
                }
                break;
            }
            case Boolean: {
                IValue[] iValueArray4 = iValueArray;
                int n = iValueArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IValue iValue = iValueArray4[n4];
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(" OR ");
                    }
                    stringBuilder.append(this.getAttributeColNameForType(string, attribute));
                    stringBuilder.append("=");
                    stringBuilder.append(iValue.getStringValue());
                    ++n4;
                }
                break;
            }
            default: {
                throw new GenstarException("unknown attribute type " + (Object)((Object)attribute.getValueSpace().getType()));
            }
        }
    }

    public int getEntitiesHavingValues(String string, Attribute<? extends IValue> attribute, IValue ... iValueArray) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT COUNT(*) AS TOTAL FROM ").append(this.getTableNameForEntityType(string));
        if (iValueArray.length > 0) {
            stringBuilder.append(" WHERE ");
            this.addWhereClauseForAttribute(stringBuilder, string, attribute, iValueArray);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(stringBuilder.toString());
            resultSet.next();
            return resultSet.getInt("TOTAL");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addWhereClauseForAttributes(StringBuilder stringBuilder, String string, Map<Attribute<? extends IValue>, Collection<IValue>> map) {
        stringBuilder.append(" WHERE (");
        boolean bl = true;
        for (Attribute<? extends IValue> attribute : map.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(") AND (");
            }
            Collection<IValue> collection = map.get(attribute);
            this.addWhereClauseForAttribute(stringBuilder, string, attribute, collection.toArray(new IValue[collection.size()]));
        }
        stringBuilder.append(")");
    }

    private void addWhereClauseForCoordinate(StringBuilder stringBuilder, String string, Map<Attribute<? extends IValue>, IValue> map) {
        stringBuilder.append(" WHERE (");
        boolean bl = true;
        for (Attribute<? extends IValue> attribute : map.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(") AND (");
            }
            this.addWhereClauseForAttribute(stringBuilder, string, attribute, map.get(attribute));
        }
        stringBuilder.append(")");
    }

    protected int getEntitiesHavingValues(String string, Map<Attribute<? extends IValue>, Collection<IValue>> map) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT COUNT(*) AS TOTAL FROM ").append(this.getTableNameForEntityType(string));
        if (!map.isEmpty()) {
            this.addWhereClauseForAttributes(stringBuilder, string, map);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(stringBuilder.toString());
            resultSet.next();
            return resultSet.getInt("TOTAL");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getCountHavingValues(Map<Attribute<? extends IValue>, Collection<IValue>> map) {
        int n = 0;
        for (String string : this.entityType2tableName.keySet()) {
            try {
                n += this.getEntitiesHavingValues(string, map);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new GenstarException("error while counting entities of type " + string, sQLException);
            }
        }
        return n;
    }

    protected int getEntitiesHavingCoordinate(String string, Map<Attribute<? extends IValue>, IValue> map) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT COUNT(*) AS TOTAL FROM ").append(this.getTableNameForEntityType(string));
        if (!map.isEmpty()) {
            this.addWhereClauseForCoordinate(stringBuilder, string, map);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(stringBuilder.toString());
            resultSet.next();
            return resultSet.getInt("TOTAL");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getCountHavingCoordinate(Map<Attribute<? extends IValue>, IValue> map) {
        int n = 0;
        for (String string : this.entityType2tableName.keySet()) {
            try {
                n += this.getEntitiesHavingCoordinate(string, map);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new GenstarException("error while counting entities of type " + string, sQLException);
            }
        }
        return n;
    }

    @Override
    public Iterator<ADemoEntity> getEntitiesHavingValues(Attribute<? extends IValue> attribute, IValue ... iValueArray) {
        HashMap<Attribute<? extends IValue>, Collection<IValue>> hashMap = new HashMap<Attribute<? extends IValue>, Collection<IValue>>();
        hashMap.put(attribute, Arrays.asList(iValueArray));
        return new AllTypesWithWhereIterator(this.connection, this.entityType2tableName, this.entityType2attributes, hashMap);
    }

    @Override
    public Iterator<ADemoEntity> getEntitiesHavingValues(Map<Attribute<? extends IValue>, Collection<IValue>> map) {
        return new AllTypesWithWhereIterator(this.connection, this.entityType2tableName, this.entityType2attributes, map);
    }

    @Override
    public ADemoEntity getEntityForId(String string) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                Iterator<String> iterator = this.entityType2tableName.keySet().iterator();
                if (iterator.hasNext()) {
                    String string2 = iterator.next();
                    ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.getTableNameForEntityType(string2) + " WHERE id='" + string + "'");
                    resultSet.next();
                    return this.createEntity(resultSet, string2, this.entityType2attributes.get(string2));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new GenstarException(sQLException);
        }
        return null;
    }

    @Override
    public Iterator<ADemoEntity> getEntitiesForIds(String ... stringArray) {
        throw new NotImplementedException("sorry.");
    }

    public class AllTypesIterator
    implements Iterator<ADemoEntity> {
        protected Connection connection;
        protected Map<String, Set<Attribute<? extends IValue>>> entityType2attributes;
        protected Iterator<String> itTypes = null;
        protected DatabaseEntitiesIterator itEntities = null;
        protected String whereClause = null;

        public AllTypesIterator(Connection connection, Map<String, String> map, Map<String, Set<Attribute<? extends IValue>>> map2) {
            this(connection, map, map2, "");
        }

        public AllTypesIterator(Connection connection, Map<String, String> map, Map<String, Set<Attribute<? extends IValue>>> map2, String string) {
            if (connection == null) {
                throw new IllegalArgumentException("Resource is null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Clause is null");
            }
            if (map2 == null) {
                throw new IllegalArgumentException("Entity types to attributes is null");
            }
            this.connection = connection;
            this.entityType2attributes = map2;
            this.whereClause = string;
            this.itTypes = map.keySet().iterator();
        }

        protected void initEntitiesIteratorForType(String string) {
            this.itEntities = new DatabaseEntitiesIterator(this.connection, this.entityType2attributes.get(string), string, this.whereClause);
        }

        protected void initEntitiesIterator() {
            this.initEntitiesIteratorForType(this.itTypes.next());
        }

        @Override
        public boolean hasNext() {
            if (this.itEntities == null) {
                this.initEntitiesIterator();
            }
            if (!this.itEntities.hasNext()) {
                return this.itTypes.hasNext();
            }
            return true;
        }

        @Override
        public ADemoEntity next() {
            if (this.itEntities == null || !this.itEntities.hasNext()) {
                this.initEntitiesIterator();
            }
            return this.itEntities.next();
        }
    }

    public class AllTypesWithWhereIterator
    extends AllTypesIterator {
        Map<Attribute<? extends IValue>, Collection<IValue>> attribute2values;

        public AllTypesWithWhereIterator(Connection connection, Map<String, String> map, Map<String, Set<Attribute<? extends IValue>>> map2, Map<Attribute<? extends IValue>, Collection<IValue>> map3) {
            super(connection, map, map2);
            this.attribute2values = map3;
        }

        @Override
        protected void initEntitiesIteratorForType(String string) {
            if (this.attribute2values.isEmpty()) {
                super.initEntitiesIteratorForType(string);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            GosplPopulationInDatabase.this.addWhereClauseForAttributes(stringBuilder, string, this.attribute2values);
            this.itEntities = new DatabaseEntitiesIterator(this.connection, (Set)this.entityType2attributes.get(string), string, stringBuilder.toString());
        }
    }

    public class DatabaseEntitiesIterator
    implements Iterator<ADemoEntity> {
        private ResultSet rs;
        private PreparedStatement ps;
        private final Connection connection;
        private final String sql;
        private final String type;
        private final Set<Attribute<? extends IValue>> attributes;

        public DatabaseEntitiesIterator(Connection connection, Set<Attribute<? extends IValue>> set, String string, String string2) {
            if (connection == null) {
                throw new IllegalArgumentException("Resource is null");
            }
            if (string2 == null) {
                throw new IllegalArgumentException("Clause is null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Type is null");
            }
            if (set == null) {
                throw new IllegalArgumentException("Attributes are null");
            }
            this.connection = connection;
            this.sql = "SELECT * FROM " + GosplPopulationInDatabase.this.entityType2tableName.get(string) + string2;
            this.attributes = set;
            this.type = string;
        }

        public DatabaseEntitiesIterator(Connection connection, Set<Attribute<? extends IValue>> set, String string) {
            this(connection, set, string, "");
        }

        public void init() {
            try {
                this.ps = this.connection.prepareStatement(this.sql);
                this.rs = this.ps.executeQuery();
                this.rs.next();
            }
            catch (SQLException sQLException) {
                this.close();
                throw new GenstarException(sQLException);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.ps == null) {
                this.init();
            }
            try {
                boolean bl;
                boolean bl2 = bl = !this.rs.isAfterLast();
                if (bl) {
                    try {
                        this.rs.getString("id");
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                    }
                }
                if (!bl) {
                    this.close();
                }
                return bl;
            }
            catch (SQLException sQLException) {
                this.close();
                throw new GenstarException(sQLException);
            }
        }

        private void close() {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                if (this.ps != null) {
                    try {
                        this.ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (SQLException sQLException) {}
        }

        @Override
        public ADemoEntity next() {
            if (this.ps == null) {
                this.init();
            }
            try {
                return GosplPopulationInDatabase.this.createEntity(this.rs, this.type, this.attributes);
            }
            catch (SQLException sQLException) {
                throw new GenstarException(sQLException);
            }
        }
    }
}

