/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.hillclimbing;

import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import gospl.GosplMultitypePopulation;
import gospl.algo.co.metamodel.AMultiLayerOptimizationAlgorithm;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.neighbor.MultiPopulationNeighborSearch;
import gospl.algo.co.metamodel.solution.ISyntheticPopulationSolution;
import gospl.algo.co.metamodel.solution.MultiLayerSPSolution;
import gospl.distribution.matrix.INDimensionalMatrix;
import java.util.Map;

public class MultiHillClimbing
extends AMultiLayerOptimizationAlgorithm {
    private final int nbIteration;

    public MultiHillClimbing(MultiPopulationNeighborSearch multiPopulationNeighborSearch, int n, double d) {
        this(multiPopulationNeighborSearch, n, 0.2, d);
    }

    public MultiHillClimbing(MultiPopulationNeighborSearch multiPopulationNeighborSearch, int n, double d, double d2) {
        super(multiPopulationNeighborSearch, d2);
        this.nbIteration = n;
        this.setKNeighborRatio(d);
    }

    @Override
    public MultiLayerSPSolution run(MultiLayerSPSolution multiLayerSPSolution) {
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Start HIll Climbing Algorithm\nPopulation size = " + ((GosplMultitypePopulation)multiLayerSPSolution.getSolution()).size() + "\nSample size = " + super.getSample().size() + "\nMax iteration = " + this.nbIteration + "\nNeighbor search = " + super.getNeighborSearchAlgorithm().getClass().getSimpleName() + "\nSolution = " + multiLayerSPSolution.getClass().getSimpleName(), GSPerformanceUtil.Level.DEBUG);
        gSPerformanceUtil.setObjectif(this.nbIteration);
        ISyntheticPopulationSolution<GosplMultitypePopulation<ADemoEntity>> iSyntheticPopulationSolution = multiLayerSPSolution;
        gSPerformanceUtil.sysoStempMessage("Initial solution has " + ((MultiLayerSPSolution)iSyntheticPopulationSolution).getSolution().stream().flatMap(aDemoEntity -> aDemoEntity.getChildren().stream()).map(iEntity -> (ADemoEntity)iEntity).toList().size() + " individuals");
        Double d = this.getFitness(((MultiLayerSPSolution)iSyntheticPopulationSolution).getFitness(this.getLayeredObjectives()));
        gSPerformanceUtil.sysoStempPerformance("Compute initial fitness", (Object)this);
        MultiPopulationNeighborSearch multiPopulationNeighborSearch = (MultiPopulationNeighborSearch)super.getNeighborSearchAlgorithm();
        for (Integer n : super.getLayeredObjectives().keySet()) {
            super.getLayeredObjectives().get(n).stream().forEach(iNDimensionalMatrix -> multiPopulationNeighborSearch.addObjectives((INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>)iNDimensionalMatrix, n));
        }
        multiPopulationNeighborSearch.updatePredicates((GosplMultitypePopulation<ADemoEntity>)multiLayerSPSolution.getSolution());
        int n = 0;
        int n2 = this.computeBuffer(d, multiLayerSPSolution);
        gSPerformanceUtil.sysoStempMessage("Initial fitness: " + d);
        while (n++ < this.nbIteration && d > this.getFitnessThreshold()) {
            ISyntheticPopulationSolution iSyntheticPopulationSolution2 = ((MultiLayerSPSolution)iSyntheticPopulationSolution).getRandomNeighbor((IPopulationNeighborSearch)super.getNeighborSearchAlgorithm(), n2);
            gSPerformanceUtil.sysoStempPerformance("Elicit a new neighbor candidate", (Object)this);
            double d2 = this.getFitness(((MultiLayerSPSolution)iSyntheticPopulationSolution2).getFitness(this.getLayeredObjectives()));
            gSPerformanceUtil.sysoStempPerformance("New neighbor candidate fitness " + d2, (Object)this);
            if (d2 < d) {
                iSyntheticPopulationSolution = iSyntheticPopulationSolution2;
                d = d2;
                multiPopulationNeighborSearch.updatePredicates((GosplMultitypePopulation<ADemoEntity>)((MultiLayerSPSolution)iSyntheticPopulationSolution).getSolution());
                n2 = super.computeBuffer(d, iSyntheticPopulationSolution);
            }
            if (n % (this.nbIteration / 10) != 0) continue;
            gSPerformanceUtil.sysoStempPerformance((double)n / gSPerformanceUtil.getObjectif(), (Object)this);
            gSPerformanceUtil.sysoStempMessage("Best fitness = " + d + " (buffer = " + n2 + ") | Pop size = " + ((GosplMultitypePopulation)((MultiLayerSPSolution)iSyntheticPopulationSolution).getSolution()).size());
            gSPerformanceUtil.sysoStempMessage("BF = " + d + " | CF = " + d2);
        }
        return iSyntheticPopulationSolution;
    }

    private double getFitness(Map<Integer, Double> map) {
        return map.values().stream().mapToDouble(d -> d).average().getAsDouble();
    }
}

