/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.metamodel;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import gospl.GosplMultitypePopulation;
import gospl.algo.co.metamodel.IOptimizationAlgorithm;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.solution.ISyntheticPopulationSolution;
import gospl.algo.co.metamodel.solution.MultiLayerSPSolution;
import gospl.distribution.matrix.INDimensionalMatrix;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AMultiLayerOptimizationAlgorithm
implements IOptimizationAlgorithm<GosplMultitypePopulation<ADemoEntity>, MultiLayerSPSolution> {
    private final Map<Integer, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>> layeredObjectives;
    private final Map<Integer, Integer> layerSizeConstraint;
    private GosplMultitypePopulation<ADemoEntity> sample;
    private IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, ?> neighborSearch;
    private int layer;
    private double fitnessThreshold;
    private double kNeighborRatio;

    protected AMultiLayerOptimizationAlgorithm(IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, ?> iPopulationNeighborSearch, double d) {
        this.neighborSearch = iPopulationNeighborSearch;
        this.fitnessThreshold = d;
        this.layeredObjectives = new HashMap<Integer, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>>();
        this.layerSizeConstraint = new HashMap<Integer, Integer>();
    }

    @Override
    public Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> getObjectives() {
        return this.layeredObjectives.get(0);
    }

    public Map<Integer, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>> getLayeredObjectives() {
        return this.layeredObjectives;
    }

    @Override
    public void addObjectives(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix) {
        this.addObjectives(0, iNDimensionalMatrix);
    }

    public void addObjectives(int n, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix) {
        if (!this.layeredObjectives.containsKey(n)) {
            this.layeredObjectives.put(n, new HashSet());
        }
        this.layeredObjectives.get(n).add(iNDimensionalMatrix);
        this.layerSizeConstraint.put(n, iNDimensionalMatrix.getVal().getValue());
    }

    @Override
    public IPopulation<ADemoEntity, Attribute<? extends IValue>> getSample() {
        return this.sample;
    }

    public IPopulation<ADemoEntity, Attribute<? extends IValue>> getSample(int n) {
        return this.sample.getSubPopulation(n);
    }

    @Override
    public void setSample(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation) {
        this.sample = gosplMultitypePopulation;
        this.neighborSearch.setSample(gosplMultitypePopulation);
    }

    @Override
    public IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, ?> getNeighborSearchAlgorithm() {
        return this.neighborSearch;
    }

    @Override
    public void setNeighborSearch(IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, ?> iPopulationNeighborSearch) {
        this.neighborSearch = iPopulationNeighborSearch;
    }

    @Override
    public double getFitnessThreshold() {
        return this.fitnessThreshold;
    }

    @Override
    public void setFitnessThreshold(double d) {
        this.fitnessThreshold = d;
    }

    @Override
    public double getKNeighborRatio() {
        return this.kNeighborRatio;
    }

    @Override
    public void setKNeighborRatio(double d) {
        this.kNeighborRatio = d;
    }

    public int getSampledLayer() {
        return this.layer;
    }

    public void setSampledLayer(int n) {
        this.layer = n;
    }

    public int computeBuffer(double d, ISyntheticPopulationSolution<GosplMultitypePopulation<ADemoEntity>> iSyntheticPopulationSolution) {
        return (int)Math.round((double)iSyntheticPopulationSolution.getSolution().getSubPopulationSize(this.layer) * this.kNeighborRatio);
    }
}

