/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.metamodel.neighbor;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.entity.comparator.HammingEntityComparator;
import core.metamodel.value.IValue;
import core.util.random.GenstarRandomUtils;
import gospl.GosplPopulation;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public class PopulationAttributeNeighborSearch
implements IPopulationNeighborSearch<GosplPopulation, Attribute<? extends IValue>> {
    private Collection<Attribute<? extends IValue>> predicates = new HashSet<Attribute<? extends IValue>>();
    private IPopulation<ADemoEntity, Attribute<? extends IValue>> sample;

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplPopulation gosplPopulation, Attribute<? extends IValue> attribute, int n) {
        return this.getPairwisedEntities(gosplPopulation, attribute, n, false);
    }

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplPopulation gosplPopulation, int n, boolean bl) {
        return this.getPairwisedEntities(gosplPopulation, GenstarRandomUtils.oneOf(this.getPredicates()), n, bl);
    }

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplPopulation gosplPopulation, Attribute<? extends IValue> attribute, int n, boolean bl) {
        if (!gosplPopulation.hasPopulationAttributeNamed(attribute.getAttributeName())) {
            throw new IllegalArgumentException("Trying to search for neighbor population on attribute " + attribute.getAttributeName() + " that is not present");
        }
        HashMap<ADemoEntity, ADemoEntity> hashMap = new HashMap<ADemoEntity, ADemoEntity>();
        HashMap<ADemoEntity, Object> hashMap2 = new HashMap<ADemoEntity, Object>();
        while (hashMap2.size() < n) {
            ADemoEntity aDemoEntity = GenstarRandomUtils.oneOf(gosplPopulation);
            if (hashMap2.containsKey(aDemoEntity)) continue;
            ArrayList<IValue> arrayList = new ArrayList<IValue>(aDemoEntity.getValues());
            arrayList.remove(aDemoEntity.getValueForAttribute(attribute));
            hashMap2.put(aDemoEntity, arrayList);
        }
        for (ADemoEntity aDemoEntity : hashMap2.keySet()) {
            Optional<ADemoEntity> optional = this.sample.stream().filter(aDemoEntity2 -> !aDemoEntity2.getValueForAttribute(attribute).equals(aDemoEntity.getValueForAttribute(attribute)) && aDemoEntity2.getValues().containsAll((Collection)hashMap2.get(aDemoEntity)) && bl ? aDemoEntity2.hasChildren() && aDemoEntity.getChildren().size() == aDemoEntity2.getChildren().size() : true).findFirst();
            if (optional.isPresent()) {
                hashMap.put(aDemoEntity, optional.get());
                continue;
            }
            hashMap.put(aDemoEntity, this.sample.stream().filter(aDemoEntity2 -> !aDemoEntity2.getValueForAttribute(attribute).equals(aDemoEntity.getValueForAttribute(attribute)) && bl ? aDemoEntity2.hasChildren() && aDemoEntity.getChildren().size() == aDemoEntity2.getChildren().size() : true).sorted(new HammingEntityComparator(aDemoEntity)).findFirst().get());
        }
        return hashMap;
    }

    @Override
    public Collection<Attribute<? extends IValue>> getPredicates() {
        return Collections.unmodifiableCollection(this.predicates);
    }

    @Override
    public void setPredicates(Collection<Attribute<? extends IValue>> collection) {
        this.predicates = collection;
    }

    @Override
    public void updatePredicates(GosplPopulation gosplPopulation) {
        this.setPredicates((Collection<Attribute<? extends IValue>>)gosplPopulation.getPopulationAttributes());
    }

    @Override
    public void setSample(GosplPopulation gosplPopulation) {
        this.sample = gosplPopulation;
    }
}

