/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.metamodel.solution;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import core.util.random.GenstarRandomUtils;
import gospl.GosplMultitypePopulation;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.solution.ISyntheticPopulationSolution;
import gospl.distribution.GosplNDimensionalMatrixFactory;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.validation.GosplIndicatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiLayerSPSolution
implements ISyntheticPopulationSolution<GosplMultitypePopulation<ADemoEntity>> {
    private final GosplMultitypePopulation<ADemoEntity> population;
    private final Map<Integer, Double> layeredFitness;
    private final int layer;
    private final boolean subPopulationConstant;

    public MultiLayerSPSolution(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation, int n, boolean bl) {
        this.population = gosplMultitypePopulation;
        this.layer = n;
        this.subPopulationConstant = bl;
        this.layeredFitness = new HashMap<Integer, Double>();
    }

    public MultiLayerSPSolution(Collection<ADemoEntity> collection, int n, boolean bl) {
        this.population = GosplMultitypePopulation.getMultiPopulation(collection, false);
        this.layer = n;
        this.subPopulationConstant = bl;
        this.layeredFitness = new HashMap<Integer, Double>();
    }

    @Override
    public <U> Collection<ISyntheticPopulationSolution<GosplMultitypePopulation<ADemoEntity>>> getNeighbors(IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, U> iPopulationNeighborSearch) {
        return this.getNeighbors(iPopulationNeighborSearch, 1);
    }

    @Override
    public <U> Collection<ISyntheticPopulationSolution<GosplMultitypePopulation<ADemoEntity>>> getNeighbors(IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, U> iPopulationNeighborSearch, int n) {
        return iPopulationNeighborSearch.getPredicates().stream().map(object -> new MultiLayerSPSolution(iPopulationNeighborSearch.getNeighbor(this.population, object, n, true), this.layer, this.subPopulationConstant)).collect(Collectors.toCollection(ArrayList::new));
    }

    public <U> MultiLayerSPSolution getRandomNeighbor(IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, U> iPopulationNeighborSearch) {
        return this.getRandomNeighbor((IPopulationNeighborSearch)iPopulationNeighborSearch, 1);
    }

    public <U> MultiLayerSPSolution getRandomNeighbor(IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, U> iPopulationNeighborSearch, int n) {
        return new MultiLayerSPSolution(iPopulationNeighborSearch.getNeighbor(this.population, GenstarRandomUtils.oneOf(iPopulationNeighborSearch.getPredicates()), n, true), this.layer, this.subPopulationConstant);
    }

    @Override
    public Double getFitness(Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> set) {
        return this.getFitness(0, set);
    }

    public Double getFitness(int n, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> set) {
        if (this.layeredFitness.containsKey(n)) {
            return this.layeredFitness.get(n);
        }
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("== Fitness Computation ==", GSPerformanceUtil.Level.TRACE);
        double d = System.currentTimeMillis();
        Set<Attribute<? extends IValue>> set2 = set.stream().flatMap(iNDimensionalMatrix -> iNDimensionalMatrix.getDimensions().stream()).collect(Collectors.toSet());
        IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation = ((GosplMultitypePopulation)this.getSolution()).getSubPopulation(n);
        set2 = set2.stream().filter(attribute -> iPopulation.getPopulationAttributes().stream().anyMatch(attribute::isLinked)).collect(Collectors.toSet());
        gSPerformanceUtil.sysoStempMessage("Convert population of " + iPopulation.size() + " individual into a contingency based on the distribution of " + set2.stream().map(Attribute::getAttributeName).collect(Collectors.joining(", ")) + " attributes", new Object[]{this.getClass()});
        if (set2.isEmpty()) {
            throw new IllegalArgumentException("Population attribute set does not match objectives attributes: \nMarginals: " + set.stream().flatMap(iNDimensionalMatrix -> iNDimensionalMatrix.getDimensions().stream()).map(Attribute::getAttributeName).collect(Collectors.joining("; ")) + "\nPopulation: " + iPopulation.getPopulationAttributes().stream().map(Attribute::getAttributeName).collect(Collectors.joining("; ")));
        }
        AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix = GosplNDimensionalMatrixFactory.getFactory().createContingency(set2, iPopulation);
        gSPerformanceUtil.sysoStempMessage("Build population contingency (" + aFullNDimensionalMatrix.getVal().getValue() + ") for attributes: " + aFullNDimensionalMatrix.getDimensions().stream().map(Attribute::getAttributeName).collect(Collectors.joining(", ")) + " (" + ((double)System.currentTimeMillis() - d) / 1000.0 + "s)");
        for (IValue iValue : set2.stream().map(attribute -> (IValue)attribute.getValueSpace().getValues().stream().findFirst().get()).toList()) {
            gSPerformanceUtil.sysoStempMessage("Exemple comparison on value " + iValue.getStringValue() + ": " + "POP=" + aFullNDimensionalMatrix.getVal(iValue, true) + " | MARGINAL=" + set.iterator().next().getVal(iValue, true));
        }
        double d2 = System.currentTimeMillis();
        double d3 = set.stream().mapToDouble(iNDimensionalMatrix -> GosplIndicatorFactory.getFactory().getIntegerTAE((INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number>)iNDimensionalMatrix, aFullNDimensionalMatrix)).sum();
        gSPerformanceUtil.sysoStempMessage("Compute fitness for given contingency: " + d3 + " (" + ((double)System.currentTimeMillis() - d2) / 1000.0 + "s)");
        this.layeredFitness.put(n, d3);
        return d3;
    }

    @Override
    public INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> getAbsoluteErrors(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> set) {
        return this.getAbsoluteErrors(0, iNDimensionalMatrix, set);
    }

    public INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> getAbsoluteErrors(int n, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> set) {
        return GosplIndicatorFactory.getFactory().getAbsoluteErrors(((GosplMultitypePopulation)this.getSolution()).getSubPopulation(n), iNDimensionalMatrix, set);
    }

    public Map<Integer, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> getAbsoluteErrors(Map<Integer, AFullNDimensionalMatrix<Integer>> map, Map<Integer, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>> map2) {
        return map2.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getAbsoluteErrors((INDimensionalMatrix)map.get(entry.getKey()), (Set)entry.getValue())));
    }

    public Map<Integer, Double> getFitness(Map<Integer, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getFitness((Integer)entry.getKey(), (Set)entry.getValue())));
    }

    @Override
    public GosplMultitypePopulation<ADemoEntity> getSolution() {
        return this.population;
    }
}

