/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.simannealing;

import core.util.GSPerformanceUtil;
import core.util.random.GenstarRandom;
import gospl.GosplPopulation;
import gospl.algo.co.metamodel.AOptimizationAlgorithm;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.neighbor.PopulationEntityNeighborSearch;
import gospl.algo.co.metamodel.solution.ISyntheticPopulationSolution;
import gospl.algo.co.simannealing.ISimulatedAnnealingTransitionFunction;
import gospl.algo.co.simannealing.SimulatedAnnealingDefaultTransitionFunction;

public class SimulatedAnnealing
extends AOptimizationAlgorithm<GosplPopulation> {
    private static final double coolTempRatio = 0.06;
    private int initTemp = 100000;
    private double coolingRate = 3.0;
    private static final int transitionLength = 4;
    private ISimulatedAnnealingTransitionFunction transFunction;

    public SimulatedAnnealing(IPopulationNeighborSearch<GosplPopulation, ?> iPopulationNeighborSearch, double d, int n, double d2, ISimulatedAnnealingTransitionFunction iSimulatedAnnealingTransitionFunction) {
        super(iPopulationNeighborSearch, d);
        this.initTemp = n;
        this.coolingRate = d2;
    }

    public SimulatedAnnealing(double d, int n, double d2, ISimulatedAnnealingTransitionFunction iSimulatedAnnealingTransitionFunction) {
        super(new PopulationEntityNeighborSearch(), d);
        this.initTemp = n;
        this.coolingRate = d2;
    }

    public SimulatedAnnealing() {
        super(new PopulationEntityNeighborSearch(), 0.0);
        this.transFunction = new SimulatedAnnealingDefaultTransitionFunction();
    }

    @Override
    public ISyntheticPopulationSolution<GosplPopulation> run(ISyntheticPopulationSolution<GosplPopulation> iSyntheticPopulationSolution) {
        double d;
        ISyntheticPopulationSolution<GosplPopulation> iSyntheticPopulationSolution2 = iSyntheticPopulationSolution;
        ISyntheticPopulationSolution<GosplPopulation> iSyntheticPopulationSolution3 = iSyntheticPopulationSolution;
        this.getNeighborSearchAlgorithm().updatePredicates(iSyntheticPopulationSolution.getSolution());
        int n = (int)((double)super.getNeighborSearchAlgorithm().getPredicates().size() * super.getKNeighborRatio());
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Start Simulated annealing algorithm\nPopulation size = " + iSyntheticPopulationSolution.getSolution().size() + "\nSample size = " + super.getSample().size() + "\nFreezing temperature = " + (double)this.initTemp * 0.06 + "\nNeighbor search = " + super.getNeighborSearchAlgorithm().getClass().getSimpleName() + "\nSolution = " + iSyntheticPopulationSolution.getClass().getSimpleName(), GSPerformanceUtil.Level.DEBUG);
        double d2 = d = iSyntheticPopulationSolution2.getFitness(this.getObjectives()).doubleValue();
        double d3 = this.initTemp;
        int n2 = 0;
        int n3 = 4;
        double d4 = 1.0;
        while (d3 > (double)this.initTemp * 0.06 && d > super.getFitnessThreshold()) {
            boolean bl = false;
            int n4 = 0;
            while (n4 < n3) {
                ISyntheticPopulationSolution<GosplPopulation> iSyntheticPopulationSolution4 = iSyntheticPopulationSolution2.getRandomNeighbor(super.getNeighborSearchAlgorithm(), n);
                double d5 = iSyntheticPopulationSolution4.getFitness(this.getObjectives());
                if (this.transFunction.getTransitionProbability(d, d5, d3)) {
                    if (n2 % 10 == 0) {
                        gSPerformanceUtil.sysoStempPerformance("Updats energy (TS = " + n2 + ") [" + d + " -> " + d5 + "] - " + "Temp = " + Math.round(d3) + "\u00b0 - " + "Transition lenght = " + (n4 + 1), (Object)this);
                    }
                    iSyntheticPopulationSolution2 = iSyntheticPopulationSolution4;
                    d = d5;
                    bl = true;
                    break;
                }
                if (d2 > d) {
                    iSyntheticPopulationSolution3 = iSyntheticPopulationSolution2;
                    d2 = d;
                }
                ++n4;
            }
            double d6 = 1.0 - d4;
            if (bl || GenstarRandom.getInstance().nextDouble() < d6) {
                this.getNeighborSearchAlgorithm().updatePredicates(iSyntheticPopulationSolution2.getSolution());
                d3 = (double)this.initTemp / (1.0 + this.coolingRate * Math.log(1.0 + (double)(++n2)));
                n3 = 4;
                d4 = 1.0;
                continue;
            }
            n3 = (int)((double)n3 * 1.2);
            d4 *= 0.8;
        }
        gSPerformanceUtil.sysoStempPerformance("End simulated annealing with: Temperature = " + d3 + " | Energy = " + d2, (Object)this);
        return iSyntheticPopulationSolution3;
    }
}

