/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.ipf;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import core.util.random.GenstarRandom;
import gospl.algo.ipf.margin.Margin;
import gospl.algo.ipf.margin.MarginDescriptor;
import gospl.algo.ipf.margin.MarginalsIPFBuilder;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.control.ControlFrequency;
import gospl.distribution.matrix.coordinate.ACoordinate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import ummisco.gama.dev.utils.DEBUG;

public abstract class AGosplIPF<T extends Number> {
    private int step = 100;
    private double delta = Math.pow(10.0, -4.0);
    protected IPopulation<ADemoEntity, Attribute<? extends IValue>> sampleSeed;
    protected INDimensionalMatrix<Attribute<? extends IValue>, IValue, T> marginals;
    protected MarginalsIPFBuilder<T> marginalProcessor;

    protected AGosplIPF(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation, MarginalsIPFBuilder<T> marginalsIPFBuilder, int n, double d) {
        this.sampleSeed = iPopulation;
        this.marginalProcessor = marginalsIPFBuilder;
        this.step = n;
        this.delta = d;
    }

    protected AGosplIPF(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation, int n, double d) {
        this(iPopulation, new MarginalsIPFBuilder(), n, d);
    }

    protected AGosplIPF(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation, MarginalsIPFBuilder<T> marginalsIPFBuilder) {
        this.sampleSeed = iPopulation;
        this.marginalProcessor = marginalsIPFBuilder;
    }

    protected AGosplIPF(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        this(iPopulation, new MarginalsIPFBuilder());
    }

    protected void setMarginalMatrix(INDimensionalMatrix<Attribute<? extends IValue>, IValue, T> iNDimensionalMatrix) {
        this.marginals = iNDimensionalMatrix;
    }

    protected void setMaxStep(int n) {
        this.step = n;
    }

    protected void setMaxDelta(double d) {
        this.delta = d;
    }

    public abstract AFullNDimensionalMatrix<T> process();

    public AFullNDimensionalMatrix<T> process(double d, int n) {
        this.delta = d;
        this.step = n;
        return this.process();
    }

    protected AFullNDimensionalMatrix<T> process(AFullNDimensionalMatrix<T> aFullNDimensionalMatrix) {
        if (aFullNDimensionalMatrix.getDimensions().stream().noneMatch(attribute -> this.marginals.getDimensions().contains(attribute) || this.marginals.getDimensions().contains(attribute.getReferentAttribute()))) {
            throw new IllegalArgumentException("Output distribution and sample seed does not have any matching dimensions\nDistribution: " + Arrays.toString(this.marginals.getDimensions().toArray()) + "\n" + "Sample seed: :" + Arrays.toString(aFullNDimensionalMatrix.getDimensions().toArray()));
        }
        List<Attribute> list = aFullNDimensionalMatrix.getDimensions().stream().filter(attribute -> this.marginals.getDimensions().contains(attribute) || this.marginals.getDimensions().contains(attribute.getReferentAttribute())).toList();
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("*** IPF PROCEDURE ***", GSPerformanceUtil.Level.INFO);
        gSPerformanceUtil.sysoStempPerformance(0, (Object)this);
        gSPerformanceUtil.sysoStempMessage(String.valueOf((double)list.size() / (double)aFullNDimensionalMatrix.getDimensions().size() * 100.0) + "% of samples dimensions will be estimate with output controls");
        gSPerformanceUtil.sysoStempMessage("Sample seed controls' dimension: " + aFullNDimensionalMatrix.getDimensions().stream().map(attribute -> String.valueOf(attribute.getAttributeName()) + " = " + attribute.getValueSpace().getValues().size()).collect(Collectors.joining(";")));
        Collection collection = this.marginalProcessor.buildCompliantMarginals(this.marginals, aFullNDimensionalMatrix);
        int n = this.step;
        int n2 = collection.stream().mapToInt(Margin::size).sum();
        gSPerformanceUtil.sysoStempMessage("Convergence criterias are: step = " + this.step + " | delta = " + this.delta);
        double d = ((Number)this.marginals.getVal().getValue()).doubleValue();
        double d2 = collection.stream().mapToDouble(margin -> margin.getMarginDescriptors().stream().mapToDouble(marginDescriptor -> Math.abs(((Number)aFullNDimensionalMatrix.getVal((Collection<IValue>)marginDescriptor.getSeed()).getDiff(margin.getControl((MarginDescriptor)marginDescriptor))).doubleValue()) / d).sum()).sum() / (double)n2;
        gSPerformanceUtil.sysoStempMessage("Start fitting iterations with AAPD = " + d2);
        double d3 = Double.MAX_VALUE;
        while (n-- > 0 && d2 > this.delta || d3 < this.delta) {
            if ((double)(n % (int)((double)this.step * 0.1)) == 0.0) {
                gSPerformanceUtil.sysoStempMessage("Step = " + (this.step - n) + " | average error = " + d2, GSPerformanceUtil.Level.DEBUG);
            }
            for (Margin margin2 : collection) {
                for (MarginDescriptor marginDescriptor : margin2.getMarginDescriptors()) {
                    double d4 = ((Number)((Object)margin2.getControl(marginDescriptor).getValue())).doubleValue();
                    double d5 = ((Number)((Object)aFullNDimensionalMatrix.getVal((Collection<IValue>)marginDescriptor.getSeed()).getValue())).doubleValue();
                    ControlFrequency controlFrequency = new ControlFrequency(d4 / (d5 == 0.0 ? d4 : d5));
                    Collection<ACoordinate<Attribute<IValue>, IValue>> collection2 = aFullNDimensionalMatrix.getCoordinates(marginDescriptor.getSeed());
                    for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : collection2) {
                        if (d5 == 0.0 && d4 > 0.0) {
                            aFullNDimensionalMatrix.setValue(aCoordinate, aFullNDimensionalMatrix.getAtomicVal());
                        }
                        AControl<AControl<ControlFrequency>> aControl = aFullNDimensionalMatrix.getVal((ACoordinate<Attribute<? extends IValue>, IValue>)((ACoordinate<Attribute<IValue>, IValue>)aCoordinate));
                        double d6 = ((Number)((Object)aControl.getValue())).doubleValue();
                        aControl.multiply(controlFrequency);
                        if (!DEBUG.IS_ON() || !(GenstarRandom.getInstance().nextDouble() < 0.01)) continue;
                        gSPerformanceUtil.sysoStempMessage("Coord " + aCoordinate + ":\n AV = " + d6 + " | Factor = " + (Double)controlFrequency.getValue() + " | UV = " + ((Number)((Object)aControl.getValue())).doubleValue(), GSPerformanceUtil.Level.TRACE);
                    }
                }
            }
            double d7 = collection.stream().mapToDouble(margin -> margin.getMarginDescriptors().stream().mapToDouble(marginDescriptor -> Math.abs(((Number)aFullNDimensionalMatrix.getVal((Collection<IValue>)marginDescriptor.getSeed()).getDiff(margin.getControl((MarginDescriptor)marginDescriptor))).doubleValue()) / d).sum()).sum() / (double)n2;
            d3 = Math.abs(d2 - d7);
            d2 = d7;
        }
        aFullNDimensionalMatrix.normalize();
        gSPerformanceUtil.sysoStempMessage("IPF fitting ends with final " + d2 + " AAPD value and " + (this.step - n) + " iteration(s)");
        return aFullNDimensionalMatrix;
    }
}

